/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import org.jruby.nb.MetaClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyMethod;
import org.jruby.nb.RubyModule;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"UnboundMethod"}, parent="Method")
public class RubyUnboundMethod
extends RubyMethod {
    protected RubyUnboundMethod(Ruby runtime) {
        super(runtime, runtime.getUnboundMethod());
    }

    public static RubyUnboundMethod newUnboundMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, DynamicMethod method) {
        RubyUnboundMethod newMethod = new RubyUnboundMethod(implementationModule.getRuntime());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method;
        return newMethod;
    }

    public static RubyClass defineUnboundMethodClass(Ruby runtime) {
        RubyClass newClass = runtime.defineClass("UnboundMethod", runtime.getMethod(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setUnboundMethod(newClass);
        newClass.defineAnnotatedMethods(RubyUnboundMethod.class);
        return newClass;
    }

    @Override
    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true)
    public IRubyObject call(ThreadContext context, IRubyObject[] args, Block block) {
        throw context.getRuntime().newTypeError("you cannot call unbound method; bind first");
    }

    @Override
    @JRubyMethod(name={"unbind"}, frame=true)
    public RubyUnboundMethod unbind(Block block) {
        return this;
    }

    @JRubyMethod(name={"bind"}, required=1, frame=true)
    public RubyMethod bind(ThreadContext context, IRubyObject aReceiver, Block block) {
        RubyClass receiverClass = aReceiver.getMetaClass();
        if (!this.originModule.isInstance(aReceiver)) {
            if (this.originModule instanceof MetaClass) {
                throw context.getRuntime().newTypeError("singleton method called for a different object");
            }
            if (receiverClass instanceof MetaClass && receiverClass.getMethods().containsKey(this.originName)) {
                throw context.getRuntime().newTypeError("method `" + this.originName + "' overridden");
            }
            if (!(!this.originModule.isModule() ? aReceiver.getType() == this.originModule : this.originModule.isInstance(aReceiver))) {
                throw context.getRuntime().newTypeError("bind argument must be an instance of " + this.originModule.getName());
            }
        }
        return RubyMethod.newMethod(this.implementationModule, this.methodName, receiverClass, this.originName, this.method, aReceiver);
    }

    @Override
    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        return RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
    }

    @Override
    @JRubyMethod(name={"to_proc"}, frame=true)
    public IRubyObject to_proc(ThreadContext context, Block unusedBlock) {
        return super.to_proc(context, unusedBlock);
    }
}

