/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.BrowseFolders;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.EventListenerPanel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.EventTableModel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.SecurityTablePanel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.Util;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class EventTablePanel
extends DefaultTablePanel {
    private EventTableModel model;
    private HibernateCfgDataObject configDataObject;

    public EventTablePanel(HibernateCfgDataObject hibernateCfgDataObject, final EventTableModel eventTableModel) {
        super((AbstractTableModel)eventTableModel);
        this.model = eventTableModel;
        this.configDataObject = hibernateCfgDataObject;
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventTablePanel.this.configDataObject.modelUpdatedFromUI();
                int n = EventTablePanel.this.getTable().getSelectedRow();
                eventTableModel.removeRow(n);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean bl) {
            this.add = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            int n = this.add ? -1 : EventTablePanel.this.getTable().getSelectedRow();
            final EventListenerPanel eventListenerPanel = new EventListenerPanel();
            if (!this.add) {
                string = (String)EventTablePanel.this.model.getValueAt(n, 0);
                eventListenerPanel.initValues(string);
            }
            eventListenerPanel.addBrowseClassActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        SourceGroup[] sourceGroupArray = Util.getJavaSourceGroups(EventTablePanel.this.configDataObject);
                        FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
                        if (fileObject != null) {
                            String string = Util.getResourcePath(sourceGroupArray, fileObject);
                            eventListenerPanel.getListenerClassTextField().setText(string);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            string = new EditDialog(eventListenerPanel, NbBundle.getMessage(SecurityTablePanel.class, (String)"LBL_Event_Listener"), this.add){

                protected String validate() {
                    String string = eventListenerPanel.getListenerClass();
                    if (string.length() == 0) {
                        return NbBundle.getMessage(SecurityTablePanel.class, (String)"TXT_Listener_Class_Empty");
                    }
                    return null;
                }
            };
            if (this.add) {
                string.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener((EditDialog)string);
            eventListenerPanel.getListenerClassTextField().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)string);
            dialog.setVisible(true);
            eventListenerPanel.getListenerClassTextField().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (string.getValue().equals(EditDialog.OK_OPTION)) {
                EventTablePanel.this.configDataObject.modelUpdatedFromUI();
                String string2 = eventListenerPanel.getListenerClass();
                if (this.add) {
                    EventTablePanel.this.model.addRow(string2);
                } else {
                    EventTablePanel.this.model.editRow(n, string2);
                }
            }
        }
    }
}

