/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSource;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourcePopulator;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourceProvider;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.util.SourceLevelChecker;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaFileList;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaManager;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaTableProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaUISupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.EmptyTableProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableSource;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableUISupport;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class DatabaseTablesPanel
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final DBSchemaManager dbschemaManager = new DBSchemaManager();
    private PersistenceGenerator persistenceGen;
    private SchemaElement sourceSchemaElement;
    private DatabaseConnection dbconn;
    private FileObject dbschemaFile;
    private String datasourceName;
    private TableClosure tableClosure;
    private boolean sourceSchemaUpdateEnabled;
    private Project project;
    private JButton addAllButton;
    private JButton addButton;
    private JLabel availableTablesLabel;
    private JList availableTablesList;
    private JScrollPane availableTablesScrollPane;
    private JPanel buttonPanel;
    private JComboBox datasourceComboBox;
    private JRadioButton datasourceRadioButton;
    private JComboBox dbschemaComboBox;
    private JRadioButton dbschemaRadioButton;
    private JScrollPane jScrollPane3;
    private JButton removeAllButton;
    private JButton removeButton;
    private ButtonGroup schemaSource;
    private JLabel selectedTablesLabel;
    private JList selectedTablesList;
    private JScrollPane selectedTablesScrollPane;
    private JCheckBox tableClosureCheckBox;
    private JTextPane tableError;
    private JPanel tablesPanel;

    public DatabaseTablesPanel() {
        this.initComponents();
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DatabaseTablesPanel.this.updateButtons();
            }
        };
        this.availableTablesList.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.selectedTablesList.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void initialize(Project project, DBSchemaFileList dBSchemaFileList, PersistenceGenerator persistenceGenerator, TableSource tableSource, FileObject fileObject) {
        boolean bl;
        boolean bl2;
        this.persistenceGen = persistenceGenerator;
        this.project = project;
        boolean bl3 = ProviderUtil.isValidServerInstanceOrNone(project);
        boolean bl4 = bl2 = Util.isContainerManaged(project) || Util.isEjb21Module(project);
        if (bl2 && bl3) {
            this.initializeWithDatasources();
        } else {
            this.initializeWithDbConnections();
        }
        DBSchemaUISupport.connect(this.dbschemaComboBox, dBSchemaFileList);
        boolean bl5 = bl = this.dbschemaComboBox.getItemCount() > 0 && this.dbschemaComboBox.getItemAt(0) instanceof FileObject;
        if (!bl) {
            this.dbschemaRadioButton.setEnabled(bl);
            this.dbschemaComboBox.setEnabled(bl);
        }
        this.selectDefaultTableSource(tableSource, bl2, project, fileObject);
        this.sourceSchemaUpdateEnabled = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DatabaseTablesPanel.this.updateSourceSchema();
            }
        });
    }

    private void initializeWithDatasources() {
        Mnemonics.setLocalizedText((AbstractButton)this.datasourceRadioButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_Datasource"));
        JPADataSourcePopulator jPADataSourcePopulator = (JPADataSourcePopulator)this.project.getLookup().lookup(JPADataSourcePopulator.class);
        jPADataSourcePopulator.connect(this.datasourceComboBox);
    }

    private void initializeWithDbConnections() {
        Mnemonics.setLocalizedText((AbstractButton)this.datasourceRadioButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_JDBCConnection"));
        DatabaseExplorerUIs.connect((JComboBox)this.datasourceComboBox, (ConnectionManager)ConnectionManager.getDefault());
    }

    private void selectDefaultTableSource(TableSource tableSource, boolean bl, Project project, FileObject fileObject) {
        Object object;
        Object object2;
        SourceGroup sourceGroup;
        int n;
        if (tableSource == null) {
            n = this.dbschemaComboBox.getItemCount();
            if (fileObject != null && (sourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])(object2 = SourceGroups.getJavaSourceGroups((Project)project)), (FileObject)fileObject)) != null) {
                for (int i = 0; i < n; ++i) {
                    FileObject fileObject2;
                    object = this.dbschemaComboBox.getItemAt(i);
                    if (!(object instanceof FileObject) || !(fileObject2 = ((FileObject)object).getParent()).equals(fileObject)) continue;
                    this.dbschemaComboBox.setSelectedIndex(i);
                    this.dbschemaRadioButton.setSelected(true);
                    return;
                }
            }
            if (n > 0 && this.dbschemaComboBox.getItemAt(0) instanceof FileObject) {
                this.dbschemaComboBox.setSelectedIndex(0);
                this.dbschemaRadioButton.setSelected(true);
                return;
            }
        } else {
            String string = tableSource.getName();
            switch (tableSource.getType()) {
                case DATA_SOURCE: {
                    if (!bl || !this.selectDatasource(string, false)) break;
                    return;
                }
                case CONNECTION: {
                    if (bl || !this.selectDbConnection(string)) break;
                    return;
                }
                case SCHEMA_FILE: {
                    if (!this.selectDBSchemaFile(string)) break;
                    return;
                }
            }
        }
        n = 0;
        try {
            n = ProviderUtil.persistenceExists(project) ? 1 : 0;
        }
        catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
            // empty catch block
        }
        if (n != 0) {
            object2 = null;
            try {
                object2 = ProviderUtil.getPUDataObject(project);
            }
            catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
                Exceptions.printStackTrace((Throwable)invalidPersistenceXmlException);
            }
            PersistenceUnit persistenceUnit = sourceGroup = object2 != null && ((PUDataObject)((Object)object2)).getPersistence().getPersistenceUnit().length == 1 ? ((PUDataObject)((Object)object2)).getPersistence().getPersistenceUnit()[0] : null;
            if (sourceGroup != null) {
                if (bl) {
                    String string = sourceGroup.getJtaDataSource();
                    if (string != null) {
                        this.selectDatasource(string, true);
                    } else {
                        object = sourceGroup.getNonJtaDataSource();
                        if (object != null) {
                            this.selectDatasource((String)object, true);
                        }
                    }
                } else {
                    DatabaseConnection databaseConnection = ProviderUtil.getConnection((PersistenceUnit)sourceGroup);
                    if (databaseConnection != null) {
                        this.datasourceComboBox.setSelectedItem(databaseConnection);
                    }
                }
            }
        }
        this.datasourceRadioButton.setSelected(true);
    }

    private static List<DatabaseConnection> findDatabaseConnections(JPADataSource jPADataSource) {
        if (jPADataSource == null) {
            throw new NullPointerException("The datasource parameter cannot be null.");
        }
        String string = jPADataSource.getUrl();
        String string2 = jPADataSource.getUsername();
        if (string == null || string2 == null) {
            return Collections.emptyList();
        }
        ArrayList<DatabaseConnection> arrayList = new ArrayList<DatabaseConnection>();
        for (DatabaseConnection databaseConnection : ConnectionManager.getDefault().getConnections()) {
            if (!string.equals(databaseConnection.getDatabaseURL()) || !string2.equals(databaseConnection.getUser())) continue;
            arrayList.add(databaseConnection);
        }
        if (arrayList.size() > 0) {
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    private boolean selectDatasource(String string, boolean bl) {
        JPADataSource jPADataSource3;
        JPADataSourceProvider jPADataSourceProvider = (JPADataSourceProvider)this.project.getLookup().lookup(JPADataSourceProvider.class);
        if (jPADataSourceProvider == null) {
            return false;
        }
        JPADataSource jPADataSource2 = null;
        for (JPADataSource jPADataSource3 : jPADataSourceProvider.getDataSources()) {
            if (!string.equals(jPADataSource3.getJndiName())) continue;
            jPADataSource2 = jPADataSource3;
        }
        if (jPADataSource2 == null) {
            return false;
        }
        List<DatabaseConnection> list = DatabaseTablesPanel.findDatabaseConnections(jPADataSource2);
        if (list.size() == 0) {
            return false;
        }
        if (!bl && (jPADataSource3 = (DatabaseConnection)list.get(0)).getJDBCConnection() == null) {
            return false;
        }
        boolean bl2 = false;
        for (int i = 0; i < this.datasourceComboBox.getItemCount(); ++i) {
            JPADataSource jPADataSource4;
            Object e = this.datasourceComboBox.getItemAt(i);
            JPADataSource jPADataSource5 = jPADataSource4 = jPADataSourceProvider != null ? jPADataSourceProvider.toJPADataSource(e) : null;
            if (jPADataSource4 == null || !jPADataSource2.getJndiName().equals(jPADataSource4.getJndiName()) || !jPADataSource2.getUrl().equals(jPADataSource4.getUrl()) || !jPADataSource2.getUsername().equals(jPADataSource4.getUsername())) continue;
            this.datasourceComboBox.setSelectedIndex(i);
            bl2 = true;
            break;
        }
        if (!bl2) {
            return false;
        }
        this.datasourceRadioButton.setSelected(true);
        return true;
    }

    private boolean selectDbConnection(String string) {
        DatabaseConnection databaseConnection = ConnectionManager.getDefault().getConnection(string);
        if (databaseConnection == null || databaseConnection.getJDBCConnection() == null) {
            return false;
        }
        this.datasourceComboBox.setSelectedItem(databaseConnection);
        if (!databaseConnection.equals(this.datasourceComboBox.getSelectedItem())) {
            return false;
        }
        this.datasourceRadioButton.setSelected(true);
        return true;
    }

    private boolean selectDBSchemaFile(String string) {
        FileObject fileObject = FileUtil.toFileObject((File)new File(string));
        if (fileObject == null) {
            return false;
        }
        this.dbschemaComboBox.setSelectedItem(fileObject);
        if (!fileObject.equals(this.dbschemaComboBox.getSelectedItem())) {
            return false;
        }
        this.dbschemaRadioButton.setSelected(true);
        return true;
    }

    public SchemaElement getSourceSchemaElement() {
        return this.sourceSchemaElement;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.dbconn;
    }

    public FileObject getDBSchemaFile() {
        return this.dbschemaFile;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public TableClosure getTableClosure() {
        return this.tableClosure;
    }

    private void updateSourceSchema() {
        Object object;
        if (!this.sourceSchemaUpdateEnabled) {
            return;
        }
        this.sourceSchemaElement = null;
        this.datasourceName = null;
        this.dbconn = null;
        this.dbschemaFile = null;
        if (this.datasourceRadioButton.isSelected()) {
            JPADataSource jPADataSource;
            object = this.datasourceComboBox.getSelectedItem();
            JPADataSourceProvider jPADataSourceProvider = (JPADataSourceProvider)this.project.getLookup().lookup(JPADataSourceProvider.class);
            JPADataSource jPADataSource2 = jPADataSource = jPADataSourceProvider != null ? jPADataSourceProvider.toJPADataSource(object) : null;
            if (jPADataSource != null) {
                List<DatabaseConnection> list = DatabaseTablesPanel.findDatabaseConnections(jPADataSource);
                if (list.size() > 0) {
                    this.dbconn = list.get(0);
                } else {
                    String string = jPADataSource.getDriverClassName();
                    if (string == null) {
                        DatabaseTablesPanel.notify(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_NoDriverClassName"));
                    } else {
                        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(string);
                        if (jDBCDriverArray.length == 0) {
                            DatabaseTablesPanel.notify(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_NoDriverError", (Object)string));
                        } else {
                            JDBCDriver jDBCDriver = JDBCDriverManager.getDefault().getDrivers(string)[0];
                            this.dbconn = ConnectionManager.getDefault().showAddConnectionDialogFromEventThread(jDBCDriver, jPADataSource.getUrl(), jPADataSource.getUsername(), jPADataSource.getPassword());
                        }
                    }
                }
                if (this.dbconn != null) {
                    try {
                        this.sourceSchemaElement = this.dbschemaManager.getSchemaElement(this.dbconn);
                        this.datasourceName = jPADataSource.getJndiName();
                    }
                    catch (SQLException sQLException) {
                        DatabaseTablesPanel.notify(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_DatabaseError"));
                    }
                }
            } else if (object instanceof DatabaseConnection) {
                this.dbconn = (DatabaseConnection)object;
                try {
                    this.sourceSchemaElement = this.dbschemaManager.getSchemaElement(this.dbconn);
                }
                catch (SQLException sQLException) {
                    DatabaseTablesPanel.notify(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_DatabaseError"));
                }
            }
        } else if (this.dbschemaRadioButton.isSelected() && (object = this.dbschemaComboBox.getSelectedItem()) instanceof FileObject) {
            this.dbschemaFile = (FileObject)object;
            this.sourceSchemaElement = this.dbschemaManager.getSchemaElement(this.dbschemaFile);
        }
        object = null;
        object = this.sourceSchemaElement != null ? new DBSchemaTableProvider(this.sourceSchemaElement, this.persistenceGen) : new EmptyTableProvider();
        this.tableClosure = new TableClosure((TableProvider)object);
        this.tableClosure.setClosureEnabled(this.tableClosureCheckBox.isSelected());
        TableUISupport.connectAvailable(this.availableTablesList, this.tableClosure);
        TableUISupport.connectSelected(this.selectedTablesList, this.tableClosure);
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private static void notify(String string) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private void updateSourceSchemaComboBoxes() {
        this.datasourceComboBox.setEnabled(this.datasourceRadioButton.isSelected());
        this.dbschemaComboBox.setEnabled(this.dbschemaRadioButton.isSelected());
    }

    private void updateButtons() {
        Set<Table> set = TableUISupport.getSelectedTables(this.availableTablesList);
        this.addButton.setEnabled(this.tableClosure.canAddAllTables(set));
        this.addAllButton.setEnabled(this.tableClosure.canAddSomeTables(this.tableClosure.getAvailableTables()));
        Set<Table> set2 = TableUISupport.getSelectedTables(this.selectedTablesList);
        this.removeButton.setEnabled(this.tableClosure.canRemoveAllTables(set2));
        this.removeAllButton.setEnabled(this.tableClosure.getSelectedTables().size() > 0);
        this.tableError.setText("");
        for (Table table : set) {
            if (!table.isDisabled()) continue;
            if (table.getDisabledReason() instanceof Table.ExistingDisabledReason) {
                String string = ((Table.ExistingDisabledReason)table.getDisabledReason()).getFQClassName();
                this.tableError.setText(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"MSG_Already_Mapped", (Object[])new Object[]{table.getName(), string}));
                break;
            }
            if (!(table.getDisabledReason() instanceof Table.NoPrimaryKeyDisabledReason)) continue;
            this.tableError.setText(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"MSG_No_Primary_Key", (Object[])new Object[]{table.getName()}));
            break;
        }
    }

    private void initComponents() {
        this.schemaSource = new ButtonGroup();
        this.datasourceRadioButton = new JRadioButton();
        this.datasourceComboBox = new JComboBox();
        this.dbschemaRadioButton = new JRadioButton();
        this.dbschemaComboBox = new JComboBox();
        this.tablesPanel = new TablesPanel();
        this.availableTablesLabel = new JLabel();
        this.availableTablesScrollPane = new JScrollPane();
        this.availableTablesList = TableUISupport.createTableList();
        this.selectedTablesLabel = new JLabel();
        this.selectedTablesScrollPane = new JScrollPane();
        this.selectedTablesList = TableUISupport.createTableList();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addAllButton = new JButton();
        this.removeAllButton = new JButton();
        this.tableClosureCheckBox = new JCheckBox();
        this.jScrollPane3 = new JScrollPane();
        this.tableError = new JTextPane();
        this.setName(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_DatabaseTables"));
        this.schemaSource.add(this.datasourceRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.datasourceRadioButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_Datasource"));
        this.datasourceRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DatabaseTablesPanel.this.datasourceRadioButtonItemStateChanged(itemEvent);
            }
        });
        this.datasourceComboBox.setEnabled(false);
        this.datasourceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseTablesPanel.this.datasourceComboBoxActionPerformed(actionEvent);
            }
        });
        this.schemaSource.add(this.dbschemaRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.dbschemaRadioButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_DbSchema"));
        this.dbschemaRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DatabaseTablesPanel.this.dbschemaRadioButtonItemStateChanged(itemEvent);
            }
        });
        this.dbschemaComboBox.setEnabled(false);
        this.dbschemaComboBox.setNextFocusableComponent(this.availableTablesList);
        this.dbschemaComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseTablesPanel.this.dbschemaComboBoxActionPerformed(actionEvent);
            }
        });
        this.tablesPanel.setLayout(new GridBagLayout());
        this.availableTablesLabel.setLabelFor(this.availableTablesList);
        Mnemonics.setLocalizedText((JLabel)this.availableTablesLabel, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_AvailableTables"));
        this.availableTablesLabel.setToolTipText(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"TXT_AvailableTables"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.tablesPanel.add((Component)this.availableTablesLabel, gridBagConstraints);
        this.availableTablesList.setNextFocusableComponent(this.addButton);
        this.availableTablesScrollPane.setViewportView(this.availableTablesList);
        this.availableTablesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ACSN_AvailableTables"));
        this.availableTablesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ACSD_AvailableTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tablesPanel.add((Component)this.availableTablesScrollPane, gridBagConstraints);
        this.selectedTablesLabel.setLabelFor(this.selectedTablesList);
        Mnemonics.setLocalizedText((JLabel)this.selectedTablesLabel, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_SelectedTables"));
        this.selectedTablesLabel.setToolTipText(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"TXT_SelectedTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.tablesPanel.add((Component)this.selectedTablesLabel, gridBagConstraints);
        this.selectedTablesScrollPane.setViewportView(this.selectedTablesList);
        this.selectedTablesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ACSN_SelectedTables"));
        this.selectedTablesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ACSD_SelectedTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tablesPanel.add((Component)this.selectedTablesScrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseTablesPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseTablesPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addAllButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_AddAll"));
        this.addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseTablesPanel.this.addAllButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.buttonPanel.add((Component)this.addAllButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeAllButton, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_RemoveAll"));
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseTablesPanel.this.removeAllButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this.tablesPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.tableClosureCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tableClosureCheckBox, (String)NbBundle.getMessage(DatabaseTablesPanel.class, (String)"LBL_IncludeRelatedTables"));
        this.tableClosureCheckBox.setToolTipText(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"TXT_IncludeRelatedTables"));
        this.tableClosureCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableClosureCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DatabaseTablesPanel.this.tableClosureCheckBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.tablesPanel.add((Component)this.tableClosureCheckBox, gridBagConstraints);
        this.jScrollPane3.setBorder(null);
        this.tableError.setEditable(false);
        this.tableError.setOpaque(false);
        this.jScrollPane3.setViewportView(this.tableError);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.datasourceRadioButton).add((Component)this.dbschemaRadioButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.dbschemaComboBox, 0, 387, Short.MAX_VALUE).add((Component)this.datasourceComboBox, 0, 387, Short.MAX_VALUE))).add(2, (Component)this.tablesPanel, -1, 536, Short.MAX_VALUE).add(2, (Component)this.jScrollPane3, -1, 536, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.datasourceRadioButton).add((Component)this.datasourceComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.dbschemaRadioButton).add((Component)this.dbschemaComboBox, -2, -1, -2)).addPreferredGap(0, 6, Short.MAX_VALUE).add((Component)this.tablesPanel, -2, 235, -2).addPreferredGap(0).add((Component)this.jScrollPane3, -2, 38, -2)));
    }

    private void tableClosureCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.tableClosure.setClosureEnabled(this.tableClosureCheckBox.isSelected());
    }

    private void removeAllButtonActionPerformed(ActionEvent actionEvent) {
        this.tableClosure.removeAllTables();
        this.selectedTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void addAllButtonActionPerformed(ActionEvent actionEvent) {
        this.tableClosure.addAllTables();
        this.availableTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Set<Table> set = TableUISupport.getSelectedTables(this.selectedTablesList);
        this.tableClosure.removeTables(set);
        this.selectedTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        Set<Table> set = TableUISupport.getSelectedTables(this.availableTablesList);
        this.tableClosure.addTables(set);
        this.availableTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void dbschemaComboBoxActionPerformed(ActionEvent actionEvent) {
        this.updateSourceSchema();
    }

    private void dbschemaRadioButtonItemStateChanged(ItemEvent itemEvent) {
        this.updateSourceSchemaComboBoxes();
        this.updateSourceSchema();
    }

    private void datasourceComboBoxActionPerformed(ActionEvent actionEvent) {
        this.datasourceComboBox.hidePopup();
        this.updateSourceSchema();
    }

    private void datasourceRadioButtonItemStateChanged(ItemEvent itemEvent) {
        this.updateSourceSchemaComboBoxes();
        this.updateSourceSchema();
    }

    public static final class WizardPanel
    implements WizardDescriptor.Panel<WizardDescriptor>,
    ChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private DatabaseTablesPanel component;
        private boolean componentInitialized;
        private WizardDescriptor wizardDescriptor;
        private Project project;
        private boolean cmp;
        boolean waitingForScan;
        private String title;

        public WizardPanel(String string) {
            this.title = string;
        }

        public DatabaseTablesPanel getComponent() {
            if (this.component == null) {
                this.component = new DatabaseTablesPanel();
                this.component.addChangeListener(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            if (this.cmp) {
                return new HelpCtx("org.netbeans.modules.j2ee.ejbcore.ejb.wizard.cmp." + DatabaseTablesPanel.class.getSimpleName());
            }
            return new HelpCtx(DatabaseTablesPanel.class);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void readSettings(WizardDescriptor wizardDescriptor) {
            this.wizardDescriptor = wizardDescriptor;
            this.wizardDescriptor.putProperty("NewFileWizard_Title", (Object)this.title);
            if (!this.componentInitialized) {
                this.componentInitialized = true;
                this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
                this.cmp = RelatedCMPWizard.isCMP(this.wizardDescriptor);
                RelatedCMPHelper relatedCMPHelper = RelatedCMPWizard.getHelper(this.wizardDescriptor);
                DBSchemaFileList dBSchemaFileList = relatedCMPHelper.getDBSchemaFileList();
                PersistenceGenerator persistenceGenerator = relatedCMPHelper.getPersistenceGenerator();
                TableSource tableSource = relatedCMPHelper.getTableSource();
                FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
                this.getComponent().initialize(this.project, dBSchemaFileList, persistenceGenerator, tableSource, fileObject);
            }
        }

        public boolean isValid() {
            if (!this.cmp && SourceLevelChecker.isSourceLevel14orLower(this.project)) {
                this.setErrorMessage(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_NeedProperSourceLevel"));
                return false;
            }
            if (this.getComponent().getSourceSchemaElement() == null) {
                this.setErrorMessage(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_SelectTableSource"));
                return false;
            }
            if (this.getComponent().getTableClosure().getSelectedTables().size() <= 0) {
                this.setErrorMessage(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_SelectTables"));
                return false;
            }
            for (Table table : this.getComponent().getTableClosure().getSelectedTables()) {
                if (table.isTable()) continue;
                this.setWarningMessage(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"MSG_ViewSelected"));
                return true;
            }
            this.setErrorMessage(" ");
            if (!ProviderUtil.isValidServerInstanceOrNone(this.project)) {
                this.setWarningMessage(NbBundle.getMessage(DatabaseTablesPanel.class, (String)"ERR_MissingServer"));
            }
            return true;
        }

        public void storeSettings(WizardDescriptor wizardDescriptor) {
            RelatedCMPHelper relatedCMPHelper = RelatedCMPWizard.getHelper(this.wizardDescriptor);
            SchemaElement schemaElement = this.getComponent().getSourceSchemaElement();
            DatabaseConnection databaseConnection = this.getComponent().getDatabaseConnection();
            FileObject fileObject = this.getComponent().getDBSchemaFile();
            String string = this.getComponent().getDatasourceName();
            if (fileObject != null) {
                relatedCMPHelper.setTableSource(schemaElement, fileObject);
            } else {
                relatedCMPHelper.setTableSource(schemaElement, databaseConnection, string);
            }
            relatedCMPHelper.setTableClosure(this.getComponent().getTableClosure());
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.changeSupport.fireChange();
        }

        private void setErrorMessage(String string) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        }

        private void setWarningMessage(String string) {
            this.wizardDescriptor.putProperty("WizardPanel_warningMessage", (Object)string);
        }
    }

    private final class TablesPanel
    extends JPanel {
        private TablesPanel() {
        }

        @Override
        public void doLayout() {
            super.doLayout();
            Rectangle rectangle = DatabaseTablesPanel.this.availableTablesScrollPane.getBounds();
            Rectangle rectangle2 = DatabaseTablesPanel.this.selectedTablesScrollPane.getBounds();
            if (Math.abs(rectangle.width - rectangle2.width) > 1) {
                GridBagConstraints gridBagConstraints = ((GridBagLayout)this.getLayout()).getConstraints(DatabaseTablesPanel.this.buttonPanel);
                int n = this.getWidth() - DatabaseTablesPanel.this.buttonPanel.getWidth() - gridBagConstraints.insets.left - gridBagConstraints.insets.right;
                int n2 = n / 2;
                int n3 = n2 - rectangle.width;
                rectangle.width = n2;
                DatabaseTablesPanel.this.availableTablesScrollPane.setBounds(rectangle);
                Rectangle rectangle3 = DatabaseTablesPanel.this.buttonPanel.getBounds();
                rectangle3.x += n3;
                DatabaseTablesPanel.this.buttonPanel.setBounds(rectangle3);
                Rectangle rectangle4 = DatabaseTablesPanel.this.selectedTablesLabel.getBounds();
                rectangle4.x += n3;
                DatabaseTablesPanel.this.selectedTablesLabel.setBounds(rectangle4);
                rectangle2.x += n3;
                rectangle2.width = n - n2;
                DatabaseTablesPanel.this.selectedTablesScrollPane.setBounds(rectangle2);
                Rectangle rectangle5 = DatabaseTablesPanel.this.tableClosureCheckBox.getBounds();
                rectangle5.x += n3;
                rectangle5.width = n - n2;
                DatabaseTablesPanel.this.tableClosureCheckBox.setBounds(rectangle5);
            }
        }
    }
}

