/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.indexing;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class CopyResourcesIndexer
extends CustomIndexer {
    private static final String NAME = "CopyResourcesIndexer";
    private static final int VERSION = 1;
    private static final String MIME_JAVA = "text/x-java";
    private static final String JAVA_NAME = "java";
    private static final String PATH_TEMPLATE = "%s/%d/classes/META-INF";
    private final Factory factory;

    private CopyResourcesIndexer(Factory factory) {
        this.factory = factory;
    }

    protected void index(Iterable<? extends Indexable> iterable, Context context) {
    }

    public static class Factory
    extends CustomIndexerFactory {
        private volatile String cachedPath;
        private Date timestamp;
        private long length;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean scanStarted(Context context) {
            FileObject fileObject;
            FileObject fileObject2;
            Project project;
            FileObject fileObject3 = context.getRoot();
            if (fileObject3 != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject3)) != null && (fileObject2 = PersistenceLocation.getLocation((Project)project)) != null && (fileObject = fileObject2.getFileObject("persistence.xml")) != null) {
                Date date = fileObject.lastModified();
                long l = fileObject.getSize();
                Object object = this;
                synchronized (object) {
                    if (date.equals(this.timestamp) && this.length == l) {
                        return super.scanStarted(context);
                    }
                    this.timestamp = date;
                    this.length = l;
                }
                try {
                    FileObject fileObject4;
                    FileObject fileObject5;
                    object = this.getCachePath();
                    if (object != null && (fileObject5 = FileUtil.createFolder((FileObject)(fileObject4 = context.getIndexFolder().getParent().getParent()), (String)object)) != null) {
                        FileObject fileObject6 = fileObject5.getFileObject(fileObject.getName(), fileObject.getExt());
                        if (fileObject6 != null) {
                            fileObject6.delete();
                        }
                        FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject5, (String)fileObject.getName());
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return super.scanStarted(context);
        }

        public CustomIndexer createIndexer() {
            return new CopyResourcesIndexer(this);
        }

        public boolean supportsEmbeddedIndexers() {
            return true;
        }

        public void filesDeleted(Iterable<? extends Indexable> iterable, Context context) {
        }

        public void filesDirty(Iterable<? extends Indexable> iterable, Context context) {
        }

        public String getIndexerName() {
            return CopyResourcesIndexer.NAME;
        }

        public int getIndexVersion() {
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getCachePath() {
            String string = this.cachedPath;
            if (string != null) {
                return string;
            }
            CustomIndexerFactory customIndexerFactory = null;
            Collection collection = MimeLookup.getLookup((String)CopyResourcesIndexer.MIME_JAVA).lookupAll(CustomIndexerFactory.class);
            for (CustomIndexerFactory customIndexerFactory2 : collection) {
                if (!CopyResourcesIndexer.JAVA_NAME.equals(customIndexerFactory2.getIndexerName())) continue;
                customIndexerFactory = customIndexerFactory2;
                break;
            }
            if (customIndexerFactory == null) {
                return null;
            }
            Object object = this;
            synchronized (object) {
                this.cachedPath = String.format(CopyResourcesIndexer.PATH_TEMPLATE, customIndexerFactory.getIndexerName(), customIndexerFactory.getIndexVersion());
                return this.cachedPath;
            }
        }
    }
}

