/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.util.ByteBuffer;
import org.apache.tomcat.util.MimeHeaders;
import org.apache.tomcat.util.RequestUtil;
import org.apache.tomcat.util.SimplePrincipal;
import org.apache.tomcat.util.StringManager;

public class RequestImpl
implements Request {
    protected String jvmRoute;
    protected String requestURI;
    protected String queryString;
    protected String serverName = null;
    protected Vector cookies = new Vector();
    protected String contextPath;
    protected String lookupPath;
    protected String servletPath;
    protected String pathInfo;
    protected String pathTranslated;
    protected boolean pathTranslatedIsSet = false;
    protected Hashtable parameters = new Hashtable();
    protected int contentLength = -1;
    protected String contentType = null;
    protected String charEncoding = null;
    protected String authType;
    boolean notAuthenticated = true;
    protected String remoteUser;
    protected Principal principal;
    protected String[] userRoles;
    protected String[] reqRoles;
    protected Response response;
    protected HttpServletRequest requestFacade;
    protected Context context;
    protected ContextManager contextM;
    protected Hashtable attributes = new Hashtable();
    protected boolean didReadFormData;
    protected boolean didParameters;
    protected boolean didCookies;
    protected String reqSessionId;
    protected String sessionIdSource;
    protected HttpSession serverSession;
    protected String servletName;
    protected ServletWrapper handler = null;
    Container container;
    protected String mappedPath = null;
    protected String scheme;
    protected String method;
    protected String protocol;
    protected MimeHeaders headers;
    protected ServletInputStream in;
    protected int serverPort;
    protected String remoteAddr;
    protected String remoteHost;
    protected String localHost;
    protected ByteBuffer bBuffer;
    Request top;
    Request parent;
    Request child;
    protected static StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    public static final int ACC_PRE_CMAP = 0;
    public static final int ACC_PRE_RMAP = 1;
    public static final int ACC_POST_MAP = 2;
    public static final int ACC_PRE_SERVICE = 3;
    public static final int ACC_POST_SERVICE = 4;
    public static final int ACC_IN_OUT = 5;
    public static final int ACC_OUT_COUNT = 6;
    public static final int ACCOUNTS = 7;
    long[] accTable = new long[7];
    Object[] notes = new Object[32];

    public RequestImpl() {
        this.headers = new MimeHeaders();
        this.initRequest();
    }

    public int doRead() throws IOException {
        return -1;
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        return -1;
    }

    public long getAccount(int pos) {
        return this.accTable[pos];
    }

    public Object getAttribute(String name) {
        Object value = this.attributes.get(name);
        if (value != null) {
            return value;
        }
        if (name.equals("org.apache.tomcat.facade")) {
            return this.context.getAttribute(name);
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        if (this.charEncoding != null) {
            return this.charEncoding;
        }
        this.charEncoding = RequestUtil.getCharsetFromContentType(this.getContentType());
        return this.charEncoding;
    }

    public Request getChild() {
        return this.child;
    }

    public Container getContainer() {
        return this.container;
    }

    public int getContentLength() {
        if (this.contentLength > -1) {
            return this.contentLength;
        }
        String value = this.getHeader("content-length");
        if (value == null) {
            return -1;
        }
        this.contentLength = Integer.parseInt(value);
        return this.contentLength;
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = this.getHeader("content-type");
        if (this.contentType != null) {
            return this.contentType;
        }
        return this.contentType;
    }

    public Context getContext() {
        return this.context;
    }

    public ContextManager getContextManager() {
        return this.contextM;
    }

    public Cookie getCookie(int idx) {
        if (!this.didCookies) {
            this.didCookies = true;
            RequestUtil.processCookies(this, this.cookies);
        }
        return (Cookie)this.cookies.elementAt(idx);
    }

    public int getCookieCount() {
        if (!this.didCookies) {
            this.didCookies = true;
            RequestUtil.processCookies(this, this.cookies);
        }
        return this.cookies.size();
    }

    public Cookie[] getCookies() {
        int count = this.getCookieCount();
        Cookie[] cookieArray = new Cookie[count];
        int i = 0;
        while (i < count) {
            cookieArray[i] = this.getCookie(i);
            ++i;
        }
        return cookieArray;
    }

    public HttpServletRequest getFacade() {
        if (this.requestFacade == null) {
            if (this.context == null) {
                this.requestFacade = this.contextM.getContext("").getFacadeManager().createHttpServletRequestFacade(this);
                return this.requestFacade;
            }
            this.requestFacade = this.context.getFacadeManager().createHttpServletRequestFacade(this);
        }
        return this.requestFacade;
    }

    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.headers.names();
    }

    public Enumeration getHeaders(String name) {
        Vector v = this.getMimeHeaders().getHeadersVector(name);
        return v.elements();
    }

    public ByteBuffer getInputBuffer() {
        return this.bBuffer;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.in;
    }

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public String getLookupPath() {
        return this.lookupPath;
    }

    public String getMappedPath() {
        return this.mappedPath;
    }

    public String getMethod() {
        return this.method;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public Object getNote(int pos) {
        return this.notes[pos];
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        this.handleParameters();
        return this.parameters.keys();
    }

    public String[] getParameterValues(String name) {
        this.handleParameters();
        return (String[])this.parameters.get(name);
    }

    public Hashtable getParameters() {
        return this.parameters;
    }

    public Request getParent() {
        return this.parent;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        if (this.pathTranslatedIsSet) {
            return this.pathTranslated;
        }
        this.pathTranslatedIsSet = true;
        String path = this.getPathInfo();
        this.pathTranslated = null;
        if (path == null || "".equals(path)) {
            return null;
        }
        this.pathTranslated = this.context.getRealPath(path);
        return this.pathTranslated;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        if (this.queryString != null) {
            return this.queryString;
        }
        return this.queryString;
    }

    public BufferedReader getReader() throws IOException {
        return RequestUtil.getReader(this);
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteUser() {
        if (this.notAuthenticated) {
            this.notAuthenticated = false;
            this.contextM.doAuthenticate(this, this.response);
        }
        return this.remoteUser;
    }

    public String getRequestURI() {
        if (this.requestURI != null) {
            return this.requestURI;
        }
        return this.requestURI;
    }

    public String getRequestedSessionId() {
        return this.reqSessionId;
    }

    public String[] getRequiredRoles() {
        return this.reqRoles;
    }

    public Response getResponse() {
        return this.response;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        if (this.serverName != null) {
            return this.serverName;
        }
        String hostHeader = this.getHeader("host");
        if (hostHeader != null) {
            int i = hostHeader.indexOf(58);
            if (i > -1) {
                hostHeader = hostHeader.substring(0, i);
            }
            this.serverName = hostHeader;
            return this.serverName;
        }
        if (this.localHost != null) {
            this.serverName = this.localHost;
            return this.serverName;
        }
        this.serverName = "localhost";
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getServletPrefix() {
        return null;
    }

    public HttpSession getSession(boolean create) {
        if (this.serverSession != null) {
            try {
                this.serverSession.getCreationTime();
            }
            catch (IllegalStateException illegalStateException) {
                this.serverSession = null;
            }
            if (this.serverSession != null) {
                return this.serverSession;
            }
        }
        if (!create) {
            return null;
        }
        this.contextM.doNewSessionRequest(this, this.response);
        if (this.serverSession == null) {
            this.context.log("RequestImpl: no session created!");
            return null;
        }
        this.reqSessionId = this.serverSession.getId();
        this.response.setSessionId(this.reqSessionId);
        return this.serverSession;
    }

    public String getSessionIdSource() {
        return this.sessionIdSource;
    }

    public Request getTop() {
        if (this.top == null) {
            if (this.parent == null) {
                this.top = this;
            } else {
                int i = 10;
                Request p = this.parent;
                while (i-- > 0 && p.getParent() != null) {
                    p = p.getParent();
                }
                if (i == 0) {
                    throw new IllegalStateException("Too deep includes");
                }
                this.top = p;
            }
        }
        return this.top;
    }

    public Principal getUserPrincipal() {
        if (this.getRemoteUser() == null) {
            return null;
        }
        if (this.principal == null) {
            this.principal = new SimplePrincipal(this.getRemoteUser());
        }
        return this.principal;
    }

    public String[] getUserRoles() {
        return this.userRoles;
    }

    public ServletWrapper getWrapper() {
        return this.handler;
    }

    private void handleParameters() {
        String qString;
        if (!this.didParameters && (qString = this.getQueryString()) != null) {
            this.didParameters = true;
            RequestUtil.processFormData(qString, this.parameters);
        }
        if (!this.didReadFormData) {
            this.didReadFormData = true;
            Hashtable postParameters = RequestUtil.readFormData(this);
            if (postParameters != null) {
                this.parameters = RequestUtil.mergeParameters(this.parameters, postParameters);
            }
        }
    }

    private void initRequest() {
        this.context = null;
        this.attributes.clear();
        this.parameters.clear();
        this.cookies.removeAllElements();
        this.contentLength = -1;
        this.contentType = null;
        this.charEncoding = null;
        this.authType = null;
        this.remoteUser = null;
        this.reqSessionId = null;
        this.serverSession = null;
        this.didParameters = false;
        this.didReadFormData = false;
        this.didCookies = false;
        this.container = null;
        this.handler = null;
        this.jvmRoute = null;
        this.scheme = "http";
        this.method = "GET";
        this.requestURI = "/";
        this.queryString = null;
        this.protocol = "HTTP/1.0";
        this.headers.clear();
        this.serverName = null;
        this.serverPort = -1;
        this.pathTranslated = null;
        this.pathInfo = null;
        this.pathTranslatedIsSet = false;
        this.sessionIdSource = null;
        this.remoteAddr = "127.0.0.1";
        this.remoteHost = "localhost";
        this.localHost = "localhost";
        if (this.bBuffer != null) {
            this.bBuffer.recycle();
        }
        int i = 0;
        while (i < 7) {
            this.accTable[i] = 0L;
            ++i;
        }
        int i2 = 0;
        while (i2 < 32) {
            this.notes[i2] = null;
            ++i2;
        }
        this.parent = null;
        this.child = null;
        this.top = null;
        this.notAuthenticated = true;
        this.userRoles = null;
        this.reqRoles = null;
    }

    public boolean isSecure() {
        return this.getScheme().equalsIgnoreCase("HTTPS");
    }

    public boolean isUserInRole(String role) {
        String[] checkRoles = new String[]{role};
        int status = this.contextM.doAuthorize(this, this.response, checkRoles);
        return status == 0;
    }

    public void recycle() {
        if (this.requestFacade != null && this.context != null) {
            this.context.getFacadeManager().recycle(this);
        }
        this.initRequest();
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAccount(int pos, long value) {
        this.accTable[pos] = value;
    }

    public void setAttribute(String name, Object value) {
        if (name != null && value != null) {
            this.attributes.put(name, value);
        }
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setBody(StringBuffer body) {
    }

    public void setCharEncoding(String enc) {
        this.charEncoding = enc;
    }

    public void setChild(Request req) {
        this.child = req;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setContextManager(ContextManager cm) {
        this.contextM = cm;
    }

    public void setInputBuffer(ByteBuffer buf) {
        this.bBuffer = buf;
    }

    public void setJvmRoute(String jvmRoute) {
        this.jvmRoute = jvmRoute;
    }

    public void setLocalHost(String host) {
        this.localHost = host;
    }

    public void setLookupPath(String l) {
        this.lookupPath = l;
    }

    public void setMappedPath(String m) {
        this.mappedPath = m;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setMimeHeaders(MimeHeaders headers) {
        this.headers = headers;
    }

    public void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public void setParameters(Hashtable h) {
        if (h != null) {
            this.parameters = h;
        }
    }

    public void setParent(Request req) {
        this.parent = req;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setPathTranslated(String s) {
        this.pathTranslated = s;
        this.pathTranslatedIsSet = true;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemoteUser(String s) {
        this.remoteUser = s;
        this.notAuthenticated = false;
    }

    public void setRequestURI(String r) {
        this.requestURI = r;
    }

    public void setRequestedSessionId(String reqSessionId) {
        this.reqSessionId = reqSessionId;
    }

    public void setRequiredRoles(String[] roles) {
        this.reqRoles = roles;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setSession(HttpSession serverSession) {
        this.serverSession = serverSession;
    }

    public void setSessionIdSource(String s) {
        this.sessionIdSource = s;
    }

    public void setUserPrincipal(Principal p) {
        this.principal = p;
    }

    public void setUserRoles(String[] roles) {
        this.userRoles = roles;
    }

    public void setWrapper(ServletWrapper handler) {
        this.handler = handler;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("R( ");
        if (this.context != null) {
            sb.append(this.context.getPath());
            if (this.getServletPath() != null) {
                sb.append(" + " + this.getServletPath() + " + " + this.getPathInfo());
            } else {
                sb.append(" + " + this.getLookupPath());
            }
        } else {
            sb.append(this.getRequestURI());
        }
        sb.append(")");
        return sb.toString();
    }

    public String toStringDebug() {
        StringBuffer sb = new StringBuffer();
        sb.append("Request( " + this.context).append("\n");
        sb.append("    URI:" + this.getRequestURI()).append("\n");
        sb.append("    SP:" + this.getServletPath());
        sb.append(",PI:" + this.getPathInfo());
        sb.append(",LP:" + this.getLookupPath());
        sb.append(",MP:" + this.getMappedPath());
        sb.append("," + this.getWrapper() + ") ");
        return sb.toString();
    }
}

