/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.ui;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Controller;

public abstract class BreakpointType {
    public abstract String getCategoryDisplayName();

    public String getTypeDisplayName() {
        return null;
    }

    public abstract JComponent getCustomizer();

    public Controller getController() {
        return null;
    }

    public abstract boolean isDefault();

    static class ContextAware
    extends BreakpointType
    implements ContextAwareService<BreakpointType> {
        private String serviceName;
        private String displayName;
        private ContextProvider context;
        private BreakpointType delegate;

        private ContextAware(String serviceName, String displayName) {
            this.serviceName = serviceName;
            this.displayName = displayName;
        }

        private ContextAware(String serviceName, String displayName, ContextProvider context) {
            this.serviceName = serviceName;
            this.displayName = displayName;
            this.context = context;
        }

        private synchronized BreakpointType getDelegate() {
            if (this.delegate == null) {
                this.delegate = (BreakpointType)ContextAwareSupport.createInstance((String)this.serviceName, (ContextProvider)this.context);
            }
            return this.delegate;
        }

        public BreakpointType forContext(ContextProvider context) {
            if (context == this.context) {
                return this;
            }
            return new ContextAware(this.serviceName, this.displayName, context);
        }

        @Override
        public String getTypeDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return this.getDelegate().getTypeDisplayName();
        }

        @Override
        public JComponent getCustomizer() {
            return this.getDelegate().getCustomizer();
        }

        @Override
        public Controller getController() {
            return this.getDelegate().getController();
        }

        @Override
        public String getCategoryDisplayName() {
            return this.getDelegate().getCategoryDisplayName();
        }

        @Override
        public boolean isDefault() {
            return this.getDelegate().isDefault();
        }

        static ContextAwareService createService(Map attrs) throws ClassNotFoundException {
            String serviceName = (String)attrs.get("serviceName");
            String displayName = (String)attrs.get("displayName");
            return new ContextAware(serviceName, displayName);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String displayName();

        public String path() default "";

        public int position() default 0x7FFFFFFF;
    }
}

