/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui;

import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;

public class Utils {
    public static String getIdentifier() {
        EditorCookie e = Utils.getCurrentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane ep = Utils.getCurrentEditor(e);
        if (ep == null) {
            return null;
        }
        return Utils.getIdentifier(e.getDocument(), ep, ep.getCaret().getDot());
    }

    private static String getIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && (Character.isJavaIdentifierPart(t.charAt(identStart - 1)) || t.charAt(identStart - 1) == '.'); --identStart) {
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            return t.substring(identStart, identEnd);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private static JEditorPane getCurrentEditor(EditorCookie e) {
        JEditorPane[] op = e.getOpenedPanes();
        if (op == null || op.length < 1) {
            return null;
        }
        return op[0];
    }

    private static EditorCookie getCurrentEditorCookie() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes == null || nodes.length != 1) {
            return null;
        }
        Node node = nodes[0];
        DataObject dob = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dob != null && !dob.isValid()) {
            return null;
        }
        return (EditorCookie)node.getCookie(EditorCookie.class);
    }

    public static ImageIcon getIcon(String iconBase) {
        return ImageUtilities.loadImageIcon((String)(iconBase + ".gif"), (boolean)false);
    }
}

