/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby;

import java.awt.Color;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.Node;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.refactoring.ruby.RubyElementCtx;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;

public class RetoucheUtils {
    private RetoucheUtils() {
    }

    public static BaseDocument getDocument(ParserResult parserResult, FileObject fo) {
        BaseDocument doc = null;
        if (parserResult != null) {
            doc = RubyUtils.getDocument((Parser.Result)parserResult);
        }
        if (doc == null) {
            try {
                DataObject od = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
                if (ec != null) {
                    doc = (BaseDocument)ec.openDocument();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return doc;
    }

    public static BaseDocument getDocument(ParserResult info) {
        BaseDocument doc = null;
        if (info != null) {
            doc = RubyUtils.getDocument((Parser.Result)info, (boolean)true);
        }
        return doc;
    }

    public static String[] getNodeNames(Node node) {
        Colon2Node c2n;
        String name = null;
        String simpleName = null;
        if (node instanceof Colon2Node) {
            c2n = (Colon2Node)node;
            simpleName = c2n.getName();
            name = AstUtilities.getFqn((Colon2Node)c2n);
        } else if (node instanceof AliasNode) {
            name = AstUtilities.getNameOrValue((Node)((AliasNode)node).getNewName());
        }
        if (name == null && node instanceof INameNode) {
            name = ((INameNode)node).getName();
        }
        if (name == null && node instanceof IScopingNode) {
            if (((IScopingNode)node).getCPath() instanceof Colon2Node) {
                c2n = (Colon2Node)((IScopingNode)node).getCPath();
                simpleName = c2n.getName();
                name = AstUtilities.getFqn((Colon2Node)c2n);
            } else {
                name = AstUtilities.getClassOrModuleName((IScopingNode)((IScopingNode)node));
            }
        }
        if (simpleName == null) {
            simpleName = name;
        }
        return new String[]{name, simpleName};
    }

    public static CloneableEditorSupport findCloneableEditorSupport(ParserResult info) {
        DataObject dob = null;
        try {
            dob = DataObject.find((FileObject)RubyUtils.getFileObject((Parser.Result)info));
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return RetoucheUtils.findCloneableEditorSupport(dob);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dob) {
        Node.Cookie obj = dob.getCookie(OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getCookie(EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    public static String htmlize(String input) {
        try {
            return XMLUtil.toElementContent((String)input);
        }
        catch (CharConversionException cce) {
            Exceptions.printStackTrace((Throwable)cce);
            return input;
        }
    }

    public static IndexedMethod getOverridingMethod(RubyElementCtx element, ParserResult info) {
        return RetoucheUtils.getOverridingMethod(element, RubyIndex.get((Parser.Result)info));
    }

    public static IndexedMethod getOverridingMethod(RubyElementCtx element, FileObject fo) {
        return RetoucheUtils.getOverridingMethod(element, RubyIndex.get((FileObject)fo));
    }

    private static IndexedMethod getOverridingMethod(RubyElementCtx element, RubyIndex index) {
        if (index == null) {
            return null;
        }
        String fqn = AstUtilities.getFqnName((AstPath)element.getPath());
        return index.getSuperMethod(fqn, element.getName(), false);
    }

    public static String getHtml(String text) {
        StringBuffer buf = new StringBuffer();
        TokenHierarchy tokenH = TokenHierarchy.create((CharSequence)text, (Language)RubyTokenId.language());
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-ruby"));
        FontColorSettings settings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        TokenSequence tok = tokenH.tokenSequence();
        while (tok.moveNext()) {
            Token token = tok.token();
            String category = token.id().name();
            AttributeSet set = settings.getTokenFontColors(category);
            if (set == null) {
                category = token.id().primaryCategory();
                if (category == null) {
                    category = "whitespace";
                }
                set = settings.getTokenFontColors(category);
            }
            String tokenText = RetoucheUtils.htmlize(((Object)token.text()).toString());
            buf.append(RetoucheUtils.color(tokenText, set));
        }
        return buf.toString();
    }

    private static String color(String string, AttributeSet set) {
        if (set == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return string.replace(" ", "&nbsp;").replace("\n", "<br>");
        }
        StringBuffer buf = new StringBuffer(string);
        if (StyleConstants.isBold(set)) {
            buf.insert(0, "<b>");
            buf.append("</b>");
        }
        if (StyleConstants.isItalic(set)) {
            buf.insert(0, "<i>");
            buf.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(set)) {
            buf.insert(0, "<s>");
            buf.append("</s>");
        }
        buf.insert(0, "<font color=" + RetoucheUtils.getHTMLColor(StyleConstants.getForeground(set)) + ">");
        buf.append("</font>");
        return buf.toString();
    }

    private static String getHTMLColor(Color c) {
        String colorR = "0" + Integer.toHexString(c.getRed());
        colorR = colorR.substring(colorR.length() - 2);
        String colorG = "0" + Integer.toHexString(c.getGreen());
        colorG = colorG.substring(colorG.length() - 2);
        String colorB = "0" + Integer.toHexString(c.getBlue());
        colorB = colorB.substring(colorB.length() - 2);
        String html_color = "#" + colorR + colorG + colorB;
        return html_color;
    }

    public static boolean isFileInOpenProject(FileObject file) {
        assert (file != null);
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        return OpenProjects.getDefault().isProjectOpen(p);
    }

    public static boolean isOnSourceClasspath(FileObject fo) {
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            return false;
        }
        Project[] opened = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < opened.length; ++i) {
            if (!p.equals(opened[i]) && !opened[i].equals(p)) continue;
            SourceGroup[] gr = ProjectUtils.getSources((Project)p).getSourceGroups("ruby");
            for (int j = 0; j < gr.length; ++j) {
                if (fo == gr[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)gr[j].getRootFolder(), (FileObject)fo)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isRefactorable(FileObject file) {
        return RubyUtils.canContainRuby((FileObject)file) && RetoucheUtils.isFileInOpenProject(file) && RetoucheUtils.isOnSourceClasspath(file);
    }

    public static String getPackageName(FileObject folder) {
        assert (folder.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)folder, (String)"classpath/source").getResourceName(folder, '.', false);
    }

    public static Collection<FileObject> getProjectRoots(FileObject fileInProject) {
        Project owner = FileOwnerQuery.getOwner((FileObject)fileInProject);
        if (owner instanceof RubyBaseProject) {
            HashSet<FileObject> result = new HashSet<FileObject>();
            result.addAll(Arrays.asList(((RubyBaseProject)owner).getSourceRootFiles()));
            result.addAll(Arrays.asList(((RubyBaseProject)owner).getTestSourceRootFiles()));
            return result;
        }
        return QuerySupport.findRoots((FileObject)fileInProject, null, Collections.emptySet(), Collections.emptySet());
    }

    public static Set<FileObject> getRubyFilesInProject(FileObject fileInProject) {
        HashSet<FileObject> files = new HashSet<FileObject>(100);
        Project owner = FileOwnerQuery.getOwner((FileObject)fileInProject);
        Collection<FileObject> sourceRoots = RetoucheUtils.getProjectRoots(fileInProject);
        for (FileObject root : sourceRoots) {
            String name = root.getName();
            if (name.equals("vendor") || name.equals("script")) continue;
            RetoucheUtils.addRubyFiles(files, root);
        }
        return files;
    }

    private static void addRubyFiles(Set<FileObject> files, FileObject f) {
        if (f.isFolder()) {
            for (FileObject child : f.getChildren()) {
                RetoucheUtils.addRubyFiles(files, child);
            }
        } else if (RubyUtils.canContainRuby((FileObject)f)) {
            files.add(f);
        }
    }
}

