/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.openide.util.Lookup;

public abstract class CsmClassifierResolver {
    private static CsmClassifierResolver DEFAULT = new Default();

    public abstract CsmClassifier getOriginalClassifier(CsmClassifier var1, CsmFile var2);

    public abstract CsmClassifier getTypeClassifier(CsmType var1, CsmFile var2, int var3, boolean var4);

    public CsmClassifier findClassifierUsedInFile(CharSequence qualifiedName, CsmFile csmFile, boolean classesOnly) {
        CsmProject project;
        if (csmFile != null && (project = csmFile.getProject()) != null) {
            return project.findClassifier(qualifiedName);
        }
        return null;
    }

    public abstract boolean isForwardClass(CsmObject var1);

    protected CsmClassifierResolver() {
    }

    public static synchronized CsmClassifierResolver getDefault() {
        return DEFAULT;
    }

    private static final class Default
    extends CsmClassifierResolver {
        private final Lookup.Result<CsmClassifierResolver> res = Lookup.getDefault().lookupResult(CsmClassifierResolver.class);
        private static final boolean FIX_SERVICE = true;
        private CsmClassifierResolver fixedResolver;

        Default() {
        }

        private CsmClassifierResolver getService() {
            CsmClassifierResolver service = this.fixedResolver;
            if (service == null) {
                Iterator i$ = this.res.allInstances().iterator();
                if (i$.hasNext()) {
                    CsmClassifierResolver selector;
                    service = selector = (CsmClassifierResolver)i$.next();
                }
                if (service != null) {
                    this.fixedResolver = service;
                }
            }
            return service;
        }

        @Override
        public CsmClassifier getOriginalClassifier(CsmClassifier orig, CsmFile contextFile) {
            CsmClassifierResolver service = this.getService();
            if (service != null) {
                return service.getOriginalClassifier(orig, contextFile);
            }
            return orig;
        }

        @Override
        public CsmClassifier getTypeClassifier(CsmType type, CsmFile contextFile, int contextOffset, boolean resolveTypeChain) {
            CsmClassifierResolver service = this.getService();
            if (service != null) {
                return service.getTypeClassifier(type, contextFile, contextOffset, resolveTypeChain);
            }
            CsmClassifier classifier = type.getClassifier();
            if (resolveTypeChain) {
                classifier = this.getOriginalClassifier(classifier, contextFile);
            }
            return classifier;
        }

        @Override
        public CsmClassifier findClassifierUsedInFile(CharSequence qualifiedName, CsmFile csmFile, boolean classesOnly) {
            CsmClassifierResolver service = this.getService();
            if (service != null) {
                return service.findClassifierUsedInFile(qualifiedName, csmFile, classesOnly);
            }
            return super.findClassifierUsedInFile(qualifiedName, csmFile, classesOnly);
        }

        @Override
        public boolean isForwardClass(CsmObject cls) {
            CsmClassifierResolver service = this.getService();
            if (service != null) {
                return service.isForwardClass(cls);
            }
            return false;
        }
    }
}

