/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformProvider;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.PlatformChangeListener;
import org.netbeans.modules.ruby.rubyproject.RubyLoggingOption;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.queries.RubyProjectEncodingQueryImpl;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.spi.project.support.rake.FilterPropertyProvider;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyProvider;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyUtils;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectEvent;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectListener;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class RubyBaseProject
implements Project,
RakeProjectListener {
    public static final String SOURCES_TYPE_RUBY = "ruby";
    private static final RequestProcessor requestProcessor;
    protected final RakeProjectHelper helper;
    private final PropertyEvaluator eval;
    protected final ReferenceHelper refHelper;
    protected final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    protected final UpdateHelper updateHelper;
    protected final RubyProjectEncodingQueryImpl encodingQueryImpl;
    private final String projectConfigurationNamespace;
    private CopyOnWriteArrayList<PlatformChangeListener> platformCLs;

    protected RubyBaseProject(RakeProjectHelper helper, String projectConfigurationNamespace) {
        this.helper = helper;
        this.projectConfigurationNamespace = projectConfigurationNamespace;
        this.eval = this.createEvaluator();
        this.encodingQueryImpl = new RubyProjectEncodingQueryImpl(this.eval);
        AuxiliaryConfiguration aux = helper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(helper, aux, this.eval);
        this.genFilesHelper = new GeneratedFilesHelper(helper);
        this.updateHelper = new UpdateHelper(this, this.helper, aux, this.genFilesHelper, UpdateHelper.createDefaultNotifier(), projectConfigurationNamespace);
        this.lookup = this.createLookup(aux, helper.createAuxiliaryProperties(), new Info(), new ProjectOpenedHookImpl());
        helper.addRakeProjectListener((RakeProjectListener)this);
        this.platformCLs = new CopyOnWriteArrayList();
    }

    protected abstract Icon getIcon();

    protected abstract Lookup createLookup(AuxiliaryConfiguration var1, AuxiliaryProperties var2, ProjectInformation var3, ProjectOpenedHook var4);

    protected abstract void registerClassPath();

    protected abstract void unregisterClassPath();

    public RubyPlatform getPlatform() {
        return RubyPlatform.platformFor((Project)this);
    }

    private PropertyEvaluator createEvaluator() {
        PropertyEvaluator baseEval1 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties")});
        PropertyEvaluator baseEval2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/private.properties")});
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties"), new ConfigPropertyProvider(baseEval1, "nbproject/private/configs", this.helper), this.helper.getPropertyProvider("nbproject/private/private.properties"), PropertyUtils.userPropertiesProvider((PropertyEvaluator)baseEval2, (String)"user.properties.file", (File)FileUtil.toFile((FileObject)this.getProjectDirectory())), new ConfigPropertyProvider(baseEval1, "nbproject/configs", this.helper), this.helper.getPropertyProvider("nbproject/project.properties")});
    }

    private boolean hasRakeFile() {
        return this.getRakeFile() != null;
    }

    FileObject getRakeFile() {
        return RakeSupport.findRakeFile(this);
    }

    public abstract FileObject[] getSourceRootFiles();

    public abstract FileObject[] getTestSourceRootFiles();

    public PropertyEvaluator evaluator() {
        return this.eval;
    }

    public ReferenceHelper getReferenceHelper() {
        return this.refHelper;
    }

    public UpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    public GeneratedFilesHelper getGenFilesHelper() {
        return this.genFilesHelper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public RakeProjectHelper getRakeProjectHelper() {
        return this.helper;
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public void changeAndStorePlatform(final RubyPlatform platform) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    EditableProperties props = RubyBaseProject.this.helper.getProperties("nbproject/private/private.properties");
                    SharedRubyProjectProperties.storePlatform(props, platform);
                    RubyBaseProject.this.helper.putProperties("nbproject/private/private.properties", props);
                    ProjectManager.getDefault().saveProject((Project)RubyBaseProject.this);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            ErrorManager.getDefault().notify((Throwable)((IOException)e.getException()));
        }
    }

    public void configurationXmlChanged(RakeProjectEvent ev) {
        if (ev.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(RakeProjectEvent ev) {
        for (PlatformChangeListener platformCL : this.platformCLs) {
            platformCL.platformChanged();
        }
    }

    public void setName(final String name) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                Element nameEl;
                Element data = RubyBaseProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS(RubyBaseProject.this.projectConfigurationNamespace, "name");
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS(RubyBaseProject.this.projectConfigurationNamespace, "name");
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                RubyBaseProject.this.helper.putPrimaryConfigurationData(data, true);
                return null;
            }
        });
    }

    public void addPlatformChangeListener(PlatformChangeListener platformChangeListener) {
        this.platformCLs.add(platformChangeListener);
    }

    public void removePlatformChangeListener(PlatformChangeListener platformChangeListener) {
        this.platformCLs.remove(platformChangeListener);
    }

    protected void open() {
        this.registerClassPath();
        FileObject rakeFile = this.getRakeFile();
        if (rakeFile != null) {
            rakeFile.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    RubyBaseProject.this.updateRakeTasks();
                }

                public void fileDeleted(FileEvent fe) {
                    RubyBaseProject.this.updateRakeTasks();
                }

                public void fileRenamed(FileRenameEvent fe) {
                    RubyBaseProject.this.updateRakeTasks();
                }
            });
            this.updateRakeTasks();
        }
    }

    private void updateRakeTasks() {
        RubyPlatform platform = this.getPlatform();
        if (this.hasRakeFile() && platform != null && platform.hasValidRake(false)) {
            requestProcessor.post(new Runnable(){

                @Override
                public void run() {
                    RakeSupport.refreshTasks(RubyBaseProject.this, false);
                }
            });
        }
    }

    private void reloadGems() {
        GemManager gemManager = RubyPlatform.gemManagerFor((Project)this);
        if (gemManager != null) {
            gemManager.reloadLocalGems(false);
        }
    }

    static {
        RubyLoggingOption.initLoggers();
        requestProcessor = new RequestProcessor("Ruby refresh rake tasks");
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            RubyPlatformProvider.ensurePlatformsReady();
            RubyBaseProject.this.open();
            RubyBaseProject.this.reloadGems();
            RubyCoverageProvider provider = RubyCoverageProvider.get((Project)RubyBaseProject.this);
            if (provider.isEnabled()) {
                provider.notifyProjectOpened();
            }
        }

        protected void projectClosed() {
            try {
                ProjectManager.getDefault().saveProject((Project)RubyBaseProject.this);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            RubyBaseProject.this.unregisterClassPath();
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        void firePropertyChange(String prop) {
            this.pcs.firePropertyChange(prop, null, null);
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this.getDisplayName());
        }

        public String getDisplayName() {
            return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    Element data = RubyBaseProject.this.updateHelper.getPrimaryConfigurationData(true);
                    NodeList nl = data.getElementsByTagNameNS(RubyBaseProject.this.projectConfigurationNamespace, "name");
                    if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                        return ((Text)nl.item(0)).getNodeValue();
                    }
                    return "???";
                }
            });
        }

        public Icon getIcon() {
            return RubyBaseProject.this.getIcon();
        }

        public Project getProject() {
            return RubyBaseProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    private static final class ConfigPropertyProvider
    extends FilterPropertyProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator baseEval;
        private final String prefix;
        private final RakeProjectHelper helper;

        public ConfigPropertyProvider(PropertyEvaluator baseEval, String prefix, RakeProjectHelper helper) {
            super(ConfigPropertyProvider.computeDelegate(baseEval, prefix, helper));
            this.baseEval = baseEval;
            this.prefix = prefix;
            this.helper = helper;
            baseEval.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if ("config".equals(ev.getPropertyName())) {
                this.setDelegate(ConfigPropertyProvider.computeDelegate(this.baseEval, this.prefix, this.helper));
            }
        }

        private static PropertyProvider computeDelegate(PropertyEvaluator baseEval, String prefix, RakeProjectHelper helper) {
            String config = baseEval.getProperty("config");
            if (config != null) {
                return helper.getPropertyProvider(prefix + "/" + config + ".properties");
            }
            return PropertyUtils.fixedPropertyProvider(Collections.emptyMap());
        }
    }
}

