/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.codegenerator;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.codegenerator.NewCodeGeneratorIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CodeGeneratorPanel
extends BasicWizardIterator.Panel {
    private NewCodeGeneratorIterator.DataModel data;
    private JCheckBox cpCheckBox;
    private JTextField cpFileNameField;
    private JLabel cpFileNameLabel;
    private JLabel fileNameLabel;
    private JTextField fileNametextField;
    private JLabel mimeTypeLabel;
    private JTextField mimeTypeTextField;
    private JComboBox packageNameCombo;
    private JLabel packageNameLabel;

    CodeGeneratorPanel(WizardDescriptor settings, NewCodeGeneratorIterator.DataModel data) {
        super(settings);
        this.data = data;
        this.initComponents();
        this.putClientProperty("NewFileWizard_Title", this.getMessage("LBL_CodeGeneratorPanel_Title"));
        UIUtil.DocumentAdapter dListener = new UIUtil.DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CodeGeneratorPanel.this.checkValidity();
            }
        };
        if (data.getPackageName() != null) {
            this.packageNameCombo.setSelectedItem(data.getPackageName());
        }
        this.fileNametextField.getDocument().addDocumentListener(dListener);
        this.cpFileNameField.getDocument().addDocumentListener(dListener);
        this.mimeTypeTextField.getDocument().addDocumentListener(dListener);
        Component editorComp = this.packageNameCombo.getEditor().getEditorComponent();
        if (editorComp instanceof JTextComponent) {
            ((JTextComponent)editorComp).getDocument().addDocumentListener(dListener);
        }
    }

    private void initComponents() {
        this.fileNameLabel = new JLabel();
        this.fileNametextField = new JTextField();
        this.mimeTypeLabel = new JLabel();
        this.mimeTypeTextField = new JTextField();
        this.cpCheckBox = new JCheckBox();
        this.cpFileNameLabel = new JLabel();
        this.cpFileNameField = new JTextField();
        this.packageNameCombo = UIUtil.createPackageComboBox(this.data.getSourceRootGroup());
        this.packageNameLabel = new JLabel();
        this.fileNameLabel.setLabelFor(this.fileNametextField);
        Mnemonics.setLocalizedText((JLabel)this.fileNameLabel, (String)NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.fileNameLabel.text"));
        this.fileNametextField.setText(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.fileNametextField.text"));
        this.mimeTypeLabel.setLabelFor(this.mimeTypeTextField);
        Mnemonics.setLocalizedText((JLabel)this.mimeTypeLabel, (String)NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.mimeTypeLabel.text"));
        this.mimeTypeTextField.setText(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.mimeTypeTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cpCheckBox, (String)NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpCheckBox.text"));
        this.cpCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CodeGeneratorPanel.this.cpCheckBoxStateChanged(evt);
            }
        });
        this.cpFileNameLabel.setLabelFor(this.cpFileNameField);
        Mnemonics.setLocalizedText((JLabel)this.cpFileNameLabel, (String)NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpFileNameLabel.text"));
        this.cpFileNameField.setEditable(this.cpCheckBox.isSelected());
        this.cpFileNameField.setText(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpFileNameField.text"));
        this.packageNameCombo.setEditable(true);
        this.packageNameLabel.setLabelFor(this.packageNameCombo);
        Mnemonics.setLocalizedText((JLabel)this.packageNameLabel, (String)NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.packageNameLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileNameLabel).addComponent(this.mimeTypeLabel).addComponent(this.packageNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileNametextField, -1, 311, Short.MAX_VALUE).addComponent(this.mimeTypeTextField, -1, 311, Short.MAX_VALUE).addComponent(this.packageNameCombo, 0, 311, Short.MAX_VALUE))).addComponent(this.cpCheckBox))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(33, 33, 33).addComponent(this.cpFileNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cpFileNameField, -1, 172, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileNameLabel).addComponent(this.fileNametextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageNameCombo, -2, -1, -2).addComponent(this.packageNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mimeTypeLabel).addComponent(this.mimeTypeTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.cpCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cpFileNameLabel).addComponent(this.cpFileNameField, -2, -1, -2)).addContainerGap(123, Short.MAX_VALUE)));
        this.fileNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.fileNameLabel.AccessibleContext.accessibleDescription"));
        this.fileNametextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.fileNametextField.AccessibleContext.accessibleName"));
        this.fileNametextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.fileNametextField.AccessibleContext.accessibleDescription"));
        this.mimeTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.mimeTypeLabel.AccessibleContext.accessibleDescription"));
        this.mimeTypeTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.mimeTypeTextField.AccessibleContext.accessibleName"));
        this.mimeTypeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.mimeTypeTextField.AccessibleContext.accessibleDescription"));
        this.cpCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpCheckBox.AccessibleContext.accessibleDescription"));
        this.cpFileNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpFileNameLabel.AccessibleContext.accessibleDescription"));
        this.cpFileNameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpFileNameField.AccessibleContext.accessibleName"));
        this.cpFileNameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpFileNameField.AccessibleContext.accessibleDescription"));
        this.packageNameCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.packageNameCombo.AccessibleContext.accessibleDescription"));
        this.packageNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.packageNameLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.AccessibleContext.accessibleDescription"));
    }

    private void cpCheckBoxStateChanged(ChangeEvent evt) {
        this.cpFileNameField.setEditable(this.cpCheckBox.isSelected());
        this.checkValidity();
    }

    @Override
    protected String getPanelName() {
        return NbBundle.getMessage(CodeGeneratorPanel.class, (String)"LBL_CodeGeneratorPanel_Title");
    }

    @Override
    protected void storeToDataModel() {
        this.data.setMimeType(this.mimeTypeTextField.getText().trim());
        this.data.setFileName(this.normalize(this.fileNametextField.getText().trim()));
        this.data.setContextProviderRequired(this.cpCheckBox.isSelected());
        this.data.setProviderFileName(this.cpFileNameField.getText().trim());
        this.data.setPackageName(this.packageNameCombo.getEditor().getItem().toString());
        NewCodeGeneratorIterator.generateFileChanges(this.data);
    }

    @Override
    protected void readFromDataModel() {
        this.mimeTypeTextField.setText(this.data.getMimeType());
        this.fileNametextField.setText(this.data.getFileName());
        this.cpFileNameField.setText(this.data.getProviderFileName());
        this.cpCheckBox.setSelected(this.data.isContextProviderRequired());
        this.packageNameCombo.setSelectedItem(this.data.getPackageName());
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(CodeGeneratorPanel.class);
    }

    private String normalize(String trim) {
        if (trim.endsWith(".java")) {
            return trim.substring(0, trim.length() - 5);
        }
        return trim;
    }

    private boolean checkValidity() {
        String fileName = this.fileNametextField.getText().trim();
        String mimeType = this.mimeTypeTextField.getText().trim();
        if (fileName.length() == 0) {
            this.setWarning(this.getMessage("ERR_FN_EMPTY"), false);
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)this.normalize(fileName))) {
            this.setError(this.getMessage("ERR_FN_INVALID"));
            return false;
        }
        if (mimeType.length() == 0) {
            this.setWarning(this.getMessage("ERR_MT_EMPTY"), false);
            return false;
        }
        String packName = this.packageNameCombo.getEditor().getItem().toString();
        if (packName.equals("")) {
            this.setWarning(this.getMessage("EMPTY_PACKAGE"), false);
            return false;
        }
        if (this.cpCheckBox.isSelected()) {
            String cpFileName = this.cpFileNameField.getText().trim();
            if (cpFileName.length() == 0) {
                this.setWarning(this.getMessage("ERR_FN_EMPTY"), false);
                return false;
            }
            if (!Utilities.isJavaIdentifier((String)this.normalize(cpFileName))) {
                this.setError(this.getMessage("ERR_FN_INVALID"));
                return false;
            }
        }
        this.markValid();
        return true;
    }

    private String getMessage(String key) {
        return NbBundle.getMessage(CodeGeneratorPanel.class, (String)key);
    }
}

