/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PlatformChooserVisualPanel
extends BasicVisualPanel
implements PropertyChangeListener {
    private JPanel infoPanel;
    private JPanel inner;
    private JLabel plafLabel;
    private JTextField plafLabelValue;
    private JFileChooser platformChooser;

    public PlatformChooserVisualPanel(WizardDescriptor setting) {
        super(setting);
        this.initComponents();
        this.initAccessibility();
        String location = ModuleUISettings.getDefault().getLastUsedNbPlatformLocation();
        if (location != null) {
            this.platformChooser.setCurrentDirectory(new File(location));
        }
        this.platformChooser.setAcceptAllFileFilterUsed(false);
        this.platformChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return PlatformChooserVisualPanel.getMessage("CTL_PlatformFolder");
            }
        });
        this.platformChooser.addPropertyChangeListener(this);
        this.setName(NbPlatformCustomizer.CHOOSER_STEP);
        this.platformChooser.putClientProperty("JFileChooser.appBundleIsTraversable", "always");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.checkForm();
    }

    void storeData() {
        File file = this.platformChooser.getSelectedFile();
        if (file != null) {
            this.getSettings().putProperty("selectedPlafDir", (Object)file.getAbsolutePath());
            this.getSettings().putProperty("selectedPlafLabel", (Object)this.plafLabelValue.getText());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName.equals("SelectedFileChangedProperty")) {
            this.checkForm();
        }
    }

    private void checkForm() {
        File plafDir;
        File selFile = this.platformChooser.getSelectedFile();
        boolean invalid = true;
        if (selFile != null && (plafDir = FileUtil.normalizeFile((File)selFile)) != null && NbPlatform.isPlatformDirectory(plafDir)) {
            try {
                this.setPlafLabel(NbPlatform.computeDisplayName(plafDir));
            }
            catch (IOException e) {
                this.setPlafLabel(plafDir.getAbsolutePath());
            }
            if (!NbPlatform.isSupportedPlatform(plafDir)) {
                this.setError(PlatformChooserVisualPanel.getMessage("MSG_UnsupportedPlatform"));
            } else if (NbPlatform.contains(plafDir)) {
                this.setError(PlatformChooserVisualPanel.getMessage("MSG_AlreadyAddedPlatform"));
            } else if (!NbPlatform.isLabelValid(this.plafLabelValue.getText())) {
                this.setWarning(PlatformChooserVisualPanel.getMessage("MSG_NameIsAlreadyUsedGoToNext"));
            } else {
                this.markValid();
                ModuleUISettings.getDefault().setLastUsedNbPlatformLocation(plafDir.getParentFile().getAbsolutePath());
            }
            invalid = false;
        }
        if (invalid) {
            this.markInvalid();
            this.setPlafLabel(null);
            this.storeData();
        }
    }

    private void setPlafLabel(String label) {
        this.plafLabelValue.setText(label);
        this.plafLabelValue.setCaretPosition(0);
        this.storeData();
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(PlatformChooserVisualPanel.class, (String)key);
    }

    private void initComponents() {
        this.infoPanel = new JPanel();
        this.inner = new JPanel();
        this.plafLabel = new JLabel();
        this.plafLabelValue = new JTextField();
        this.platformChooser = new JFileChooser();
        this.infoPanel.setLayout(new FlowLayout(0, 6, 0));
        this.inner.setLayout(new GridLayout(2, 1, 0, 6));
        this.plafLabel.setLabelFor(this.plafLabelValue);
        Mnemonics.setLocalizedText((JLabel)this.plafLabel, (String)NbBundle.getMessage(PlatformChooserVisualPanel.class, (String)"LBL_PlatformName_P"));
        this.inner.add(this.plafLabel);
        this.plafLabelValue.setColumns(15);
        this.plafLabelValue.setEditable(false);
        this.inner.add(this.plafLabelValue);
        this.infoPanel.add(this.inner);
        this.setLayout(new BorderLayout());
        this.platformChooser.setAccessory(this.infoPanel);
        this.platformChooser.setControlButtonsAreShown(false);
        this.platformChooser.setFileSelectionMode(1);
        this.add((Component)this.platformChooser, "Center");
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(PlatformChooserVisualPanel.getMessage("ACS_PlatformChooserVisualPanel"));
        this.plafLabelValue.getAccessibleContext().setAccessibleDescription(PlatformChooserVisualPanel.getMessage("ACS_CTL_plafLabelValue"));
    }
}

