/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SchemaNode
extends BaseNode {
    private static final String ICONBASE = "org/netbeans/modules/db/resources/schema.png";
    private static final String FOLDER = "Schema";
    private String name = "";
    private String htmlName = null;
    private final MetadataElementHandle<Schema> schemaHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static SchemaNode create(NodeDataLookup dataLookup, NodeProvider provider) {
        SchemaNode node = new SchemaNode(dataLookup, provider);
        node.setup();
        return node;
    }

    private SchemaNode(NodeDataLookup lookup, NodeProvider provider) {
        super(new ChildNodeFactory((Lookup)lookup), lookup, FOLDER, provider);
        this.schemaHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    @Override
    protected void initialize() {
        this.setupNames();
        this.connection.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("defaultSchema")) {
                    SchemaNode.this.updateProperties();
                }
            }
        });
    }

    private void setupNames() {
        boolean connected = !this.connection.getConnector().isDisconnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Schema schema = (Schema)SchemaNode.this.schemaHandle.resolve(metaData);
                        SchemaNode.this.renderNames(schema);
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, e, true);
            }
        }
    }

    @Override
    protected void updateProperties() {
        this.setupNames();
        super.updateProperties();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.name;
    }

    private void renderNames(Schema schema) {
        this.name = schema == null ? "" : schema.getName();
        if (this.name == null) {
            this.name = schema.getParent().getName();
        }
        if (schema != null) {
            boolean isDefault = false;
            String def = this.connection.getDefaultSchema();
            isDefault = def != null ? def.equals(this.name) : schema.isDefault();
            this.htmlName = isDefault ? "<b>" + this.name + "</b>" : null;
        }
    }

    public String getHtmlDisplayName() {
        return this.htmlName;
    }

    @Override
    public String getIconBase() {
        return ICONBASE;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(SchemaNode.class, (String)"ND_Schema");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SchemaNode.class);
    }
}

