/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.explorer.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.util.DataComboBoxModel;
import org.netbeans.modules.db.util.DataComboBoxSupport;
import org.openide.util.NbBundle;

public final class DatabaseExplorerUIs {
    private DatabaseExplorerUIs() {
    }

    public static void connect(JComboBox comboBox, ConnectionManager connectionManager) {
        DataComboBoxSupport.connect(comboBox, new ConnectionDataComboBoxModel(connectionManager));
    }

    private static final class ConnectionComparator
    implements Comparator {
        private ConnectionComparator() {
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof ConnectionComparator;
        }

        public int compare(Object dbconn1, Object dbconn2) {
            if (dbconn1 == null) {
                return dbconn2 == null ? 0 : -1;
            }
            if (dbconn2 == null) {
                return 1;
            }
            String dispName1 = ((DatabaseConnection)dbconn1).getDisplayName();
            String dispName2 = ((DatabaseConnection)dbconn2).getDisplayName();
            if (dispName1 == null) {
                return dispName2 == null ? 0 : -1;
            }
            return dispName2 == null ? 1 : dispName1.compareToIgnoreCase(dispName2);
        }
    }

    private static final class ConnectionComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final ConnectionManager connectionManager;
        private final List connectionList;
        private Object selectedItem;

        public ConnectionComboBoxModel(ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            this.connectionList = new ArrayList();
            this.connectionList.addAll(Arrays.asList(connectionManager.getConnections()));
            Collections.sort(this.connectionList, new ConnectionComparator());
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedItem = anItem;
        }

        @Override
        public Object getElementAt(int index) {
            return this.connectionList.get(index);
        }

        @Override
        public int getSize() {
            return this.connectionList.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public void addSelectedConnection(DatabaseConnection dbconn) {
            this.selectedItem = dbconn;
            this.connectionList.add(dbconn);
            Collections.sort(this.connectionList, new ConnectionComparator());
            this.fireContentsChanged(this, 0, this.connectionList.size());
        }
    }

    private static final class ConnectionDataComboBoxModel
    implements DataComboBoxModel {
        private final ConnectionManager connectionManager;
        private final ConnectionComboBoxModel comboBoxModel;

        public ConnectionDataComboBoxModel(ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            this.comboBoxModel = new ConnectionComboBoxModel(connectionManager);
        }

        @Override
        public String getItemTooltipText(Object item) {
            return ((DatabaseConnection)item).toString();
        }

        @Override
        public String getItemDisplayName(Object item) {
            return ((DatabaseConnection)item).getDisplayName();
        }

        @Override
        public void newItemActionPerformed() {
            HashSet<DatabaseConnection> oldConnections = new HashSet<DatabaseConnection>(Arrays.asList(this.connectionManager.getConnections()));
            this.connectionManager.showAddConnectionDialog(null);
            DatabaseConnection[] newConnections = this.connectionManager.getConnections();
            if (newConnections.length == oldConnections.size()) {
                return;
            }
            for (int i = 0; i < newConnections.length; ++i) {
                if (oldConnections.contains(newConnections[i])) continue;
                this.comboBoxModel.addSelectedConnection(newConnections[i]);
                break;
            }
        }

        @Override
        public String getNewItemDisplayName() {
            return NbBundle.getMessage(DatabaseExplorerUIs.class, (String)"LBL_NewDbConnection");
        }

        @Override
        public ComboBoxModel getListModel() {
            return this.comboBoxModel;
        }
    }
}

