/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.rename;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlock;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.modules.editor.java.ComputeOffAWT;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.java.editor.javadoc.JavadocImports;
import org.netbeans.modules.java.editor.rename.SyncDocumentRegion;
import org.netbeans.modules.java.editor.semantic.FindLocalUsagesQuery;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class InstantRenamePerformer
implements DocumentListener,
KeyListener {
    private static final Logger LOG = Logger.getLogger(InstantRenamePerformer.class.getName());
    private SyncDocumentRegion region;
    private int span;
    private Document doc;
    private JTextComponent target;
    private AttributeSet attribs = null;
    private AttributeSet attribsLeft = null;
    private AttributeSet attribsRight = null;
    private AttributeSet attribsMiddle = null;
    private AttributeSet attribsAll = null;
    private AttributeSet attribsSlave = null;
    private AttributeSet attribsSlaveLeft = null;
    private AttributeSet attribsSlaveRight = null;
    private AttributeSet attribsSlaveMiddle = null;
    private AttributeSet attribsSlaveAll = null;
    private static final Set<ElementKind> LOCAL_CLASS_PARENTS = EnumSet.of(ElementKind.CONSTRUCTOR, ElementKind.INSTANCE_INIT, ElementKind.METHOD, ElementKind.STATIC_INIT);
    private boolean inSync;
    private static final AttributeSet defaultSyncedTextBlocksHighlight = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Foreground, Color.red});

    private InstantRenamePerformer(JTextComponent jTextComponent, Set<Token> set, int n) throws BadLocationException {
        this.target = jTextComponent;
        this.doc = jTextComponent.getDocument();
        MutablePositionRegion mutablePositionRegion = null;
        ArrayList<MutablePositionRegion> arrayList = new ArrayList<MutablePositionRegion>();
        for (Token token : set) {
            Position position;
            int n2 = token.id() == JavadocTokenId.HTML_TAG ? 1 : 0;
            Position position2 = NbDocument.createPosition((Document)this.doc, (int)(token.offset(null) + n2), (Position.Bias)Position.Bias.Backward);
            MutablePositionRegion mutablePositionRegion2 = new MutablePositionRegion(position2, position = NbDocument.createPosition((Document)this.doc, (int)(token.offset(null) + token.length() - n2), (Position.Bias)Position.Bias.Forward));
            if (this.isIn(mutablePositionRegion2, n)) {
                mutablePositionRegion = mutablePositionRegion2;
                continue;
            }
            arrayList.add(mutablePositionRegion2);
        }
        if (mutablePositionRegion == null) {
            throw new IllegalArgumentException("No highlight contains the caret.");
        }
        arrayList.add(0, mutablePositionRegion);
        this.region = new SyncDocumentRegion(this.doc, arrayList);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).setPostModificationDocumentListener((DocumentListener)this);
        }
        jTextComponent.addKeyListener(this);
        jTextComponent.putClientProperty(InstantRenamePerformer.class, this);
        this.requestRepaint();
        jTextComponent.select(mutablePositionRegion.getStartOffset(), mutablePositionRegion.getEndOffset());
        this.span = this.region.getFirstRegionLength();
    }

    public static void invokeInstantRename(JTextComponent jTextComponent) {
        try {
            JavaSource javaSource;
            final int n = jTextComponent.getCaretPosition();
            String string = Utilities.getIdentifier((BaseDocument)Utilities.getDocument((JTextComponent)jTextComponent), (int)n);
            if (string == null) {
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)NbBundle.getMessage(InstantRenamePerformer.class, (String)"WARN_CannotPerformHere"));
                return;
            }
            DataObject dataObject = (DataObject)jTextComponent.getDocument().getProperty("stream");
            JavaSource javaSource2 = javaSource = dataObject != null ? JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile()) : null;
            if (javaSource == null) {
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)NbBundle.getMessage(InstantRenamePerformer.class, (String)"WARN_CannotPerformHere"));
                return;
            }
            final boolean[] blArray = new boolean[1];
            Set<Token> set = ComputeOffAWT.computeOffAWT(new ComputeOffAWT.Worker<Set<Token>>(){

                @Override
                public Set<Token> process(CompilationInfo compilationInfo) {
                    try {
                        return InstantRenamePerformer.computeChangePoints(compilationInfo, n, blArray);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                        return null;
                    }
                }
            }, "Instant Rename", javaSource, JavaSource.Phase.RESOLVED);
            if (blArray[0]) {
                if (set != null) {
                    InstantRenamePerformer.doInstantRename(set, jTextComponent, n, string);
                } else {
                    InstantRenamePerformer.doFullRename((EditorCookie)dataObject.getCookie(EditorCookie.class), dataObject.getNodeDelegate());
                }
            } else {
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)NbBundle.getMessage(InstantRenamePerformer.class, (String)"WARN_CannotPerformHere"));
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private static void doFullRename(EditorCookie editorCookie, Node node) {
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)editorCookie);
        instanceContent.add((Object)node);
        AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
        Action action = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)abstractLookup);
        action.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
    }

    private static void doInstantRename(Set<Token> set, JTextComponent jTextComponent, int n, String string) throws BadLocationException {
        InstantRenamePerformer.performInstantRename(jTextComponent, set, n);
    }

    static Set<Token> computeChangePoints(final CompilationInfo compilationInfo, final int n, final boolean[] blArray) throws IOException {
        Tree.Kind kind;
        Object object;
        TreePath treePath;
        Document document = compilationInfo.getDocument();
        if (document == null) {
            return null;
        }
        final int[] nArray = new int[]{n};
        final boolean[] blArray2 = new boolean[]{false};
        document.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)compilationInfo.getTokenHierarchy(), (int)n);
                tokenSequence.move(n);
                if (tokenSequence.moveNext() && tokenSequence.token() != null) {
                    if (tokenSequence.token().id() == JavaTokenId.IDENTIFIER) {
                        nArray[0] = tokenSequence.offset() + tokenSequence.token().length() / 2 + 1;
                    } else if (tokenSequence.token().id() == JavaTokenId.JAVADOC_COMMENT) {
                        TokenSequence tokenSequence2 = tokenSequence.embedded(JavadocTokenId.language());
                        if (tokenSequence2 != null && JavadocImports.isInsideReference((TokenSequence<JavadocTokenId>)tokenSequence2, n)) {
                            tokenSequence2.move(n);
                            if (tokenSequence2.moveNext() && tokenSequence2.token().id() == JavadocTokenId.IDENT) {
                                nArray[0] = tokenSequence2.offset();
                                blArray2[0] = true;
                            }
                        } else if (tokenSequence2 != null && JavadocImports.isInsideParamName((TokenSequence<JavadocTokenId>)tokenSequence2, n)) {
                            tokenSequence2.move(n);
                            if (tokenSequence2.moveNext()) {
                                nArray[0] = tokenSequence2.offset();
                                blArray2[0] = true;
                            }
                        }
                    }
                }
            }
        });
        TreePath treePath2 = treePath = blArray2[0] ? null : compilationInfo.getTreeUtilities().pathFor(nArray[0]);
        if (treePath != null && treePath.getParentPath() != null) {
            long l;
            long l2;
            object = treePath.getLeaf().getKind();
            kind = treePath.getParentPath().getLeaf().getKind();
            if (object == Tree.Kind.ARRAY_TYPE && kind == Tree.Kind.VARIABLE && (l2 = compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf())) == (l = compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf()))) {
                treePath = treePath.getParentPath();
            }
        }
        Object object2 = object = blArray2[0] ? JavadocImports.findReferencedElement(compilationInfo, nArray[0]) : compilationInfo.getTrees().getElement(treePath);
        if (object == null) {
            blArray[0] = false;
            return null;
        }
        Object object3 = kind = blArray2[0] ? JavadocImports.findNameTokenOfReferencedElement(compilationInfo, nArray[0]) : org.netbeans.modules.java.editor.semantic.Utilities.getToken(compilationInfo, document, treePath);
        if (kind == null) {
            return null;
        }
        document.render(new Runnable((Token)kind, n){
            final /* synthetic */ Token val$name;
            final /* synthetic */ int val$caret;
            {
                this.val$name = token;
                this.val$caret = n;
            }

            @Override
            public void run() {
                blArray[0] = this.val$name.offset(null) <= this.val$caret && this.val$caret <= this.val$name.offset(null) + this.val$name.length();
            }
        });
        if (!blArray[0]) {
            return null;
        }
        if (object.getKind() == ElementKind.CONSTRUCTOR) {
            object = object.getEnclosingElement();
        }
        if (InstantRenamePerformer.allowInstantRename((Element)object)) {
            Object object4;
            HashSet<Token> hashSet = new HashSet<Token>(new FindLocalUsagesQuery(true).findUsages((Element)object, compilationInfo, document));
            if (object.getKind().isClass()) {
                object4 = ElementFilter.constructorsIn(object.getEnclosedElements()).iterator();
                while (object4.hasNext()) {
                    Token<JavaTokenId> token;
                    ExecutableElement executableElement = (ExecutableElement)object4.next();
                    TreePath treePath3 = compilationInfo.getTrees().getPath(executableElement);
                    if (treePath3 == null || (token = org.netbeans.modules.java.editor.semantic.Utilities.getToken(compilationInfo, document, treePath3)) == null) continue;
                    hashSet.add(token);
                }
            }
            object4 = new boolean[1];
            document.render(new Runnable((boolean[])object4, document, hashSet){
                final /* synthetic */ boolean[] val$overlapsWithGuardedBlocks;
                final /* synthetic */ Document val$doc;
                final /* synthetic */ Set val$points;
                {
                    this.val$overlapsWithGuardedBlocks = blArray;
                    this.val$doc = document;
                    this.val$points = set;
                }

                @Override
                public void run() {
                    this.val$overlapsWithGuardedBlocks[0] = InstantRenamePerformer.overlapsWithGuardedBlocks(this.val$doc, this.val$points);
                }
            });
            if (object4[0] != false) {
                return null;
            }
            return hashSet;
        }
        if (blArray2[0]) {
            blArray[0] = false;
        }
        return null;
    }

    private static boolean allowInstantRename(Element element) {
        if (org.netbeans.modules.java.editor.semantic.Utilities.isPrivateElement(element)) {
            return true;
        }
        if (InstantRenamePerformer.isInaccessibleOutsideOuterClass(element)) {
            return true;
        }
        if (element.getKind() == ElementKind.CLASS) {
            Element element2 = element.getEnclosingElement();
            ElementKind elementKind = element2.getKind();
            if (elementKind == ElementKind.CLASS) {
                EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.METHOD, ElementKind.FIELD);
                if (element2.getSimpleName().length() == 0 || enumSet.contains((Object)element2.getEnclosingElement().getKind())) {
                    return true;
                }
            }
            return LOCAL_CLASS_PARENTS.contains((Object)elementKind);
        }
        return element.getKind() == ElementKind.TYPE_PARAMETER;
    }

    private static boolean isInaccessibleOutsideOuterClass(Element element) {
        Element element2 = element.getEnclosingElement();
        boolean bl = element.getModifiers().contains((Object)Modifier.STATIC);
        ElementKind elementKind = element.getKind();
        if (bl || elementKind == ElementKind.CLASS) {
            return InstantRenamePerformer.isAnyEncloserPrivate(element);
        }
        if (element2 != null) {
            ElementKind elementKind2 = element2.getKind();
            boolean bl2 = element2.getModifiers().contains((Object)Modifier.FINAL) || elementKind2 == ElementKind.ANNOTATION_TYPE || elementKind2 == ElementKind.ENUM;
            boolean bl3 = elementKind2 == ElementKind.CLASS && (!"java.lang.Object".equals(((Object)((TypeElement)element2).getSuperclass()).toString()) || !((TypeElement)element2).getInterfaces().isEmpty());
            return bl2 && !bl3 && InstantRenamePerformer.isAnyEncloserPrivate(element);
        }
        return false;
    }

    private static boolean isAnyEncloserPrivate(Element element) {
        for (Element element2 = element.getEnclosingElement(); element2 != null && (element2.getKind().isClass() || element2.getKind().isInterface()); element2 = element2.getEnclosingElement()) {
            boolean bl = element2.getModifiers().contains((Object)Modifier.PRIVATE);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private static boolean overlapsWithGuardedBlocks(Document document, Set<Token> set) {
        if (!(document instanceof GuardedDocument)) {
            return false;
        }
        GuardedDocument guardedDocument = (GuardedDocument)document;
        for (MarkBlock markBlock = guardedDocument.getGuardedBlockChain().getChain(); markBlock != null; markBlock = markBlock.getNext()) {
            for (Token token : set) {
                if ((markBlock.compare(token.offset(null), token.offset(null) + token.length()) & 1) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void performInstantRename(JTextComponent jTextComponent, Set<Token> set, int n) throws BadLocationException {
        new InstantRenamePerformer(jTextComponent, set, n);
    }

    private boolean isIn(MutablePositionRegion mutablePositionRegion, int n) {
        return mutablePositionRegion.getStartOffset() <= n && n <= mutablePositionRegion.getEndOffset();
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent documentEvent) {
        if (this.inSync) {
            return;
        }
        if (documentEvent.getOffset() < this.region.getFirstRegionStartOffset() || documentEvent.getOffset() + documentEvent.getLength() > this.region.getFirstRegionEndOffset()) {
            this.release();
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        this.span = this.region.getFirstRegionLength();
        this.inSync = false;
        this.requestRepaint();
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent documentEvent) {
        if (this.inSync) {
            return;
        }
        if (documentEvent.getLength() == 1) {
            if (documentEvent.getOffset() < this.region.getFirstRegionStartOffset() || documentEvent.getOffset() > this.region.getFirstRegionEndOffset()) {
                this.release();
                return;
            }
            if (documentEvent.getOffset() == this.region.getFirstRegionStartOffset() && this.region.getFirstRegionLength() > 0 && this.region.getFirstRegionLength() == this.span) {
                JavaKit.JavaDeleteCharAction javaDeleteCharAction;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("e.getOffset()=" + documentEvent.getOffset());
                    LOG.fine("region.getFirstRegionStartOffset()=" + this.region.getFirstRegionStartOffset());
                    LOG.fine("region.getFirstRegionEndOffset()=" + this.region.getFirstRegionEndOffset());
                    LOG.fine("span= " + this.span);
                }
                if ((javaDeleteCharAction = (JavaKit.JavaDeleteCharAction)((Object)this.target.getClientProperty(JavaKit.JavaDeleteCharAction.class))) != null && !javaDeleteCharAction.getNextChar()) {
                    this.undo();
                } else {
                    this.release();
                }
                return;
            }
            if (documentEvent.getOffset() == this.region.getFirstRegionEndOffset() && this.region.getFirstRegionLength() > 0 && this.region.getFirstRegionLength() == this.span) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("e.getOffset()=" + documentEvent.getOffset());
                    LOG.fine("region.getFirstRegionStartOffset()=" + this.region.getFirstRegionStartOffset());
                    LOG.fine("region.getFirstRegionEndOffset()=" + this.region.getFirstRegionEndOffset());
                    LOG.fine("span= " + this.span);
                }
                this.release();
                return;
            }
            if (documentEvent.getOffset() == this.region.getFirstRegionEndOffset() && documentEvent.getOffset() == this.region.getFirstRegionStartOffset() && this.region.getFirstRegionLength() == 0 && this.region.getFirstRegionLength() == this.span) {
                JavaKit.JavaDeleteCharAction javaDeleteCharAction;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("e.getOffset()=" + documentEvent.getOffset());
                    LOG.fine("region.getFirstRegionStartOffset()=" + this.region.getFirstRegionStartOffset());
                    LOG.fine("region.getFirstRegionEndOffset()=" + this.region.getFirstRegionEndOffset());
                    LOG.fine("span= " + this.span);
                }
                if ((javaDeleteCharAction = (JavaKit.JavaDeleteCharAction)((Object)this.target.getClientProperty(JavaKit.JavaDeleteCharAction.class))) != null && !javaDeleteCharAction.getNextChar()) {
                    this.undo();
                } else {
                    this.release();
                }
                return;
            }
        } else {
            int n = documentEvent.getLength() + this.region.getFirstRegionLength();
            if (this.span < n) {
                this.release();
                return;
            }
        }
        if (this.doc.getProperty("doc-replace-selection-property") != null) {
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        this.span = this.region.getFirstRegionLength();
        this.inSync = false;
        this.requestRepaint();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void caretUpdate(CaretEvent caretEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public synchronized void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 && keyEvent.getModifiers() == 0 || keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 0) {
            this.release();
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private void release() {
        if (this.target == null) {
            return;
        }
        this.target.putClientProperty(InstantRenamePerformer.class, null);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).setPostModificationDocumentListener(null);
        }
        this.target.removeKeyListener(this);
        this.target = null;
        this.region = null;
        this.attribs = null;
        this.requestRepaint();
        this.doc = null;
    }

    private void undo() {
        if (this.doc instanceof BaseDocument && ((BaseDocument)this.doc).isAtomicLock()) {
            ((BaseDocument)this.doc).atomicUndo();
        } else {
            UndoableEdit undoableEdit = (UndoableEdit)this.doc.getProperty("undo-manager");
            if (this.target != null && undoableEdit != null) {
                try {
                    undoableEdit.undo();
                }
                catch (CannotUndoException cannotUndoException) {
                    Logger.getLogger(InstantRenamePerformer.class.getName()).log(Level.WARNING, null, cannotUndoException);
                }
            }
        }
    }

    private void requestRepaint() {
        if (this.region == null) {
            OffsetsBag offsetsBag = InstantRenamePerformer.getHighlightsBag(this.doc);
            offsetsBag.clear();
        } else {
            Object object;
            if (this.attribs == null) {
                this.attribs = InstantRenamePerformer.getSyncedTextBlocksHighlight("synchronized-text-blocks-ext");
                object = (Color)this.attribs.getAttribute(StyleConstants.Foreground);
                Color color = (Color)this.attribs.getAttribute(StyleConstants.Background);
                this.attribsLeft = InstantRenamePerformer.createAttribs(StyleConstants.Background, color, EditorStyleConstants.LeftBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                this.attribsRight = InstantRenamePerformer.createAttribs(StyleConstants.Background, color, EditorStyleConstants.RightBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                this.attribsMiddle = InstantRenamePerformer.createAttribs(StyleConstants.Background, color, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                this.attribsAll = InstantRenamePerformer.createAttribs(StyleConstants.Background, color, EditorStyleConstants.LeftBorderLineColor, object, EditorStyleConstants.RightBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                this.attribsSlave = InstantRenamePerformer.getSyncedTextBlocksHighlight("synchronized-text-blocks-ext-slave");
                Color color2 = (Color)this.attribsSlave.getAttribute(StyleConstants.Foreground);
                Color color3 = (Color)this.attribsSlave.getAttribute(StyleConstants.Background);
                this.attribsSlaveLeft = InstantRenamePerformer.createAttribs(StyleConstants.Background, color3, EditorStyleConstants.LeftBorderLineColor, color2, EditorStyleConstants.TopBorderLineColor, color2, EditorStyleConstants.BottomBorderLineColor, color2);
                this.attribsSlaveRight = InstantRenamePerformer.createAttribs(StyleConstants.Background, color3, EditorStyleConstants.RightBorderLineColor, color2, EditorStyleConstants.TopBorderLineColor, color2, EditorStyleConstants.BottomBorderLineColor, color2);
                this.attribsSlaveMiddle = InstantRenamePerformer.createAttribs(StyleConstants.Background, color3, EditorStyleConstants.TopBorderLineColor, color2, EditorStyleConstants.BottomBorderLineColor, color2);
                this.attribsSlaveAll = InstantRenamePerformer.createAttribs(StyleConstants.Background, color3, EditorStyleConstants.LeftBorderLineColor, color2, EditorStyleConstants.RightBorderLineColor, color2, EditorStyleConstants.TopBorderLineColor, color2, EditorStyleConstants.BottomBorderLineColor, color2);
            }
            object = new OffsetsBag(this.doc);
            for (int i = 0; i < this.region.getRegionCount(); ++i) {
                int n = this.region.getRegion(i).getStartOffset();
                int n2 = this.region.getRegion(i).getEndOffset();
                int n3 = this.region.getRegion(i).getLength();
                if (n3 == 1) {
                    object.addHighlight(n, n2, i == 0 ? this.attribsAll : this.attribsSlaveAll);
                    continue;
                }
                if (n3 <= 1) continue;
                object.addHighlight(n, n + 1, i == 0 ? this.attribsLeft : this.attribsSlaveLeft);
                object.addHighlight(n2 - 1, n2, i == 0 ? this.attribsRight : this.attribsSlaveRight);
                if (n3 <= 2) continue;
                object.addHighlight(n + 1, n2 - 1, i == 0 ? this.attribsMiddle : this.attribsSlaveMiddle);
            }
            OffsetsBag offsetsBag = InstantRenamePerformer.getHighlightsBag(this.doc);
            offsetsBag.setHighlights(object);
        }
    }

    private static AttributeSet getSyncedTextBlocksHighlight(String string) {
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings != null ? fontColorSettings.getFontColors(string) : null;
        return attributeSet == null ? defaultSyncedTextBlocksHighlight : attributeSet;
    }

    private static AttributeSet createAttribs(Object ... objectArray) {
        assert (objectArray.length % 2 == 0) : "There must be even number of prameters. They are key-value pairs of attributes that will be inserted into the set.";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = objectArray.length / 2 - 1; i >= 0; --i) {
            Object object = objectArray[2 * i];
            Object object2 = objectArray[2 * i + 1];
            if (object == null || object2 == null) continue;
            arrayList.add(object);
            arrayList.add(object2);
        }
        return AttributesUtilities.createImmutable((Object[])arrayList.toArray());
    }

    public static OffsetsBag getHighlightsBag(Document document) {
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(InstantRenamePerformer.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document);
            document.putProperty(InstantRenamePerformer.class, offsetsBag);
            Object object = document.getProperty("stream");
            if (object instanceof DataObject) {
                Logger.getLogger("TIMER").log(Level.FINE, "Instant Rename Highlights Bag", new Object[]{((DataObject)object).getPrimaryFile(), offsetsBag});
            }
        }
        return offsetsBag;
    }
}

