/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.GoToImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public class ComputeOverriders {
    private static final Logger LOG = Logger.getLogger(ComputeOverriders.class.getName());
    private final AtomicBoolean cancel;
    static List<URL> reverseSourceRootsInOrderOverride;
    static Map<URL, List<URL>> dependenciesOverride;

    public ComputeOverriders(AtomicBoolean atomicBoolean) {
        this.cancel = atomicBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<URL> findReverseSourceRoots(URL uRL, Map<URL, List<URL>> map, FileObject fileObject) {
        Object object;
        long l = System.currentTimeMillis();
        try {
            List l3;
            HashMap<URL, ArrayList<Object>> hashMap = new HashMap<URL, ArrayList<Object>>();
            for (Map.Entry<URL, List<URL>> object22 : map.entrySet()) {
                object = object22.getKey();
                l3 = object22.getValue();
                for (URL uRL2 : l3) {
                    ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(uRL2);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                        hashMap.put(uRL2, arrayList);
                    }
                    arrayList.add(object);
                }
            }
            HashSet hashSet = new HashSet();
            LinkedList<URL> linkedList = new LinkedList<URL>();
            linkedList.add(uRL);
            while (!linkedList.isEmpty()) {
                object = (URL)linkedList.removeFirst();
                if (hashSet.contains(object)) continue;
                hashSet.add(object);
                l3 = (List)hashMap.get(object);
                if (l3 == null) continue;
                linkedList.addAll(l3);
            }
            object = hashSet;
        }
        catch (Throwable throwable) {
            long l2 = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Find Reverse Source Roots", new Object[]{fileObject, l2 - l});
            throw throwable;
        }
        long l3 = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "Find Reverse Source Roots", new Object[]{fileObject, l3 - l});
        return object;
    }

    private static FileObject findSourceRoot(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null) {
            return classPath.findOwnerRoot(fileObject);
        }
        return null;
    }

    private Set<URL> findBinaryRootsForSourceRoot(FileObject fileObject, Map<URL, List<URL>> map) {
        HashSet<URL> hashSet = new HashSet<URL>();
        for (URL uRL : map.keySet()) {
            if (this.cancel.get()) {
                return Collections.emptySet();
            }
            for (FileObject fileObject2 : SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots()) {
                if (fileObject2 != fileObject) continue;
                hashSet.add(uRL);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<ElementHandle<? extends Element>, List<ElementDescription>> process(CompilationInfo compilationInfo, TypeElement typeElement, ExecutableElement executableElement, boolean bl) {
        Map<ElementHandle<? extends Element>, List<ElementDescription>> map;
        long l = System.currentTimeMillis();
        try {
            map = this.processImpl(compilationInfo, typeElement, executableElement, bl);
        }
        catch (Throwable throwable) {
            Logger.getLogger("TIMER").log(Level.FINE, "Overridden - Total", new Object[]{compilationInfo.getFileObject(), System.currentTimeMillis() - l});
            throw throwable;
        }
        Logger.getLogger("TIMER").log(Level.FINE, "Overridden - Total", new Object[]{compilationInfo.getFileObject(), System.currentTimeMillis() - l});
        return map;
    }

    private Map<ElementHandle<? extends Element>, List<ElementDescription>> processImpl(CompilationInfo compilationInfo, TypeElement typeElement, ExecutableElement executableElement, boolean bl) {
        Object object;
        FileObject fileObject = compilationInfo.getFileObject();
        FileObject fileObject2 = typeElement != null ? ComputeOverriders.findSourceRoot(SourceUtils.getFile((Element)typeElement, (ClasspathInfo)compilationInfo.getClasspathInfo())) : ComputeOverriders.findSourceRoot(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        HashMap<ElementHandle<TypeElement>, List<ElementHandle<ExecutableElement>>> hashMap = new HashMap<ElementHandle<TypeElement>, List<ElementHandle<ExecutableElement>>>();
        if (executableElement == null) {
            if (typeElement == null) {
                ComputeOverriders.fillInMethods(compilationInfo.getTopLevelElements(), hashMap);
            } else {
                hashMap.put((ElementHandle<TypeElement>)ElementHandle.create((Element)typeElement), Collections.emptyList());
            }
        } else {
            object = (TypeElement)executableElement.getEnclosingElement();
            hashMap.put((ElementHandle<TypeElement>)ElementHandle.create((Element)object), Collections.singletonList(ElementHandle.create((Element)executableElement)));
        }
        object = new HashMap();
        long l = System.currentTimeMillis();
        long[] lArray = new long[1];
        Map<URL, Map<ElementHandle<TypeElement>, Set<ElementHandle<TypeElement>>>> map = this.computeUsers(compilationInfo, fileObject2, hashMap.keySet(), lArray, bl);
        long l2 = System.currentTimeMillis();
        if (map == null) {
            return null;
        }
        Logger.getLogger("TIMER").log(Level.FINE, "Overridden Candidates - Class Index", new Object[]{fileObject, lArray[0]});
        Logger.getLogger("TIMER").log(Level.FINE, "Overridden Candidates - Total", new Object[]{fileObject, l2 - l});
        FileObject fileObject3 = ComputeOverriders.findSourceRoot(fileObject);
        if (fileObject3 != null) {
            try {
                URL uRL = fileObject3.getURL();
                Map<ElementHandle<TypeElement>, Set<ElementHandle<TypeElement>>> object2 = map.remove(uRL);
                if (object2 != null) {
                    this.computeOverridingForRoot(uRL, object2, hashMap, (Map<ElementHandle<? extends Element>, List<ElementDescription>>)object);
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                LOG.log(Level.INFO, null, fileStateInvalidException);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            this.computeOverridingForRoot((URL)entry.getKey(), (Map)entry.getValue(), hashMap, (Map<ElementHandle<? extends Element>, List<ElementDescription>>)object);
        }
        if (this.cancel.get()) {
            return null;
        }
        return object;
    }

    private void computeOverridingForRoot(URL uRL, Map<ElementHandle<TypeElement>, Set<ElementHandle<TypeElement>>> map, Map<ElementHandle<TypeElement>, List<ElementHandle<ExecutableElement>>> map2, Map<ElementHandle<? extends Element>, List<ElementDescription>> map3) {
        for (Map.Entry<ElementHandle<TypeElement>, Set<ElementHandle<TypeElement>>> entry : map.entrySet()) {
            if (this.cancel.get()) {
                return;
            }
            this.findOverriddenAnnotations(uRL, entry.getValue(), entry.getKey(), map2.get(entry.getKey()), map3);
        }
    }

    private static void fillInMethods(Iterable<? extends TypeElement> iterable, Map<ElementHandle<TypeElement>, List<ElementHandle<ExecutableElement>>> map) {
        for (TypeElement typeElement : iterable) {
            LinkedList<ElementHandle> linkedList = new LinkedList<ElementHandle>();
            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                linkedList.add(ElementHandle.create((Element)executableElement));
            }
            map.put((ElementHandle<TypeElement>)ElementHandle.create((Element)typeElement), linkedList);
            ComputeOverriders.fillInMethods(ElementFilter.typesIn(typeElement.getEnclosedElements()), map);
        }
    }

    private Set<ElementHandle<TypeElement>> computeUsers(URL uRL, Set<ElementHandle<TypeElement>> set, long[] lArray) {
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[]{uRL}));
        return this.computeUsers(classpathInfo, ClassIndex.SearchScope.SOURCE, set, lArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ElementHandle<TypeElement>> computeUsers(ClasspathInfo classpathInfo, ClassIndex.SearchScope searchScope, Set<ElementHandle<TypeElement>> set, long[] lArray) {
        long l = System.currentTimeMillis();
        try {
            ElementHandle elementHandle;
            LinkedList<ElementHandle<TypeElement>> linkedList = new LinkedList<ElementHandle<TypeElement>>(set);
            ElementHandle elementHandle2 = new HashSet();
            while (!linkedList.isEmpty()) {
                if (this.cancel.get()) {
                    elementHandle = null;
                    return elementHandle;
                }
                elementHandle = (ElementHandle)linkedList.remove(0);
                elementHandle2.add(elementHandle);
                Set set2 = classpathInfo.getClassIndex().getElements(elementHandle, Collections.singleton(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(searchScope));
                if (set2 == null) continue;
                linkedList.addAll(set2);
            }
            elementHandle = elementHandle2;
            return elementHandle;
        }
        finally {
            lArray[0] = lArray[0] + (System.currentTimeMillis() - l);
        }
    }

    private List<URL> reverseSourceRootsInOrder(CompilationInfo compilationInfo, URL uRL, FileObject fileObject, Map<URL, List<URL>> map, Map<URL, List<URL>> map2, boolean bl) {
        LinkedList linkedList;
        Set<Object> set;
        if (reverseSourceRootsInOrderOverride != null) {
            return reverseSourceRootsInOrderOverride;
        }
        if (map.containsKey(uRL)) {
            set = ComputeOverriders.findReverseSourceRoots(uRL, map, compilationInfo.getFileObject());
        } else {
            set = new HashSet();
            for (URL uRL2 : this.findBinaryRootsForSourceRoot(fileObject, map2)) {
                List<URL> list = map2.get(uRL2);
                if (list == null) continue;
                set.addAll(list);
            }
        }
        try {
            linkedList = new LinkedList(Utilities.topologicalSort(map.keySet(), map));
        }
        catch (TopologicalSortException topologicalSortException) {
            if (bl) {
                Exceptions.attachLocalizedMessage((Throwable)topologicalSortException, (String)NbBundle.getMessage(GoToImplementation.class, (String)"ERR_CycleInDependencies"));
                Exceptions.printStackTrace((Throwable)topologicalSortException);
            } else {
                LOG.log(Level.FINE, null, topologicalSortException);
            }
            return null;
        }
        linkedList.retainAll(set);
        Collections.reverse(linkedList);
        return linkedList;
    }

    /*
     * WARNING - void declaration
     */
    private Map<URL, Map<ElementHandle<TypeElement>, Set<ElementHandle<TypeElement>>>> computeUsers(CompilationInfo compilationInfo, FileObject fileObject, Set<ElementHandle<TypeElement>> set, long[] lArray, boolean bl) {
        Cloneable cloneable;
        URL uRL;
        Map<URL, List<URL>> map = ComputeOverriders.getDependencies(false);
        Map<URL, List<URL>> map2 = ComputeOverriders.getDependencies(true);
        if (map == null || map2 == null) {
            if (bl) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(GoToImplementation.class, (String)"ERR_NoDependencies"), 0);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
            } else {
                LOG.log(Level.FINE, NbBundle.getMessage(GoToImplementation.class, (String)"ERR_NoDependencies"));
            }
            return null;
        }
        try {
            uRL = fileObject.getURL();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            return null;
        }
        List<URL> list = this.reverseSourceRootsInOrder(compilationInfo, uRL, fileObject, map, map2, bl);
        if (list == null) {
            return null;
        }
        set = new HashSet<ElementHandle<TypeElement>>(set);
        Object object = set.iterator();
        while (object.hasNext()) {
            if (this.cancel.get()) {
                return null;
            }
            if (!((ElementHandle)object.next()).getBinaryName().contentEquals("java.lang.Object")) continue;
            object.remove();
            break;
        }
        object = new HashMap();
        if (!map.containsKey(uRL)) {
            Collection<Object> collection;
            cloneable = new HashSet();
            for (URL uRL2 : list) {
                collection = map.get(uRL2);
                if (collection == null) continue;
                cloneable.addAll(collection);
            }
            cloneable.retainAll(map2.keySet());
            for (ElementHandle elementHandle : set) {
                collection = this.computeUsers(ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPathSupport.createClassPath((URL[])cloneable.toArray(new URL[0])), (ClassPath)ClassPath.EMPTY), ClassIndex.SearchScope.DEPENDENCIES, Collections.singleton(elementHandle), lArray);
                if (collection == null || this.cancel.get()) {
                    return null;
                }
                object.put(elementHandle, collection);
            }
        }
        cloneable = new LinkedHashMap();
        for (URL uRL2 : list) {
            for (ElementHandle elementHandle : set) {
                void var19_25;
                if (this.cancel.get()) {
                    return null;
                }
                HashSet<ElementHandle<TypeElement>> hashSet = new HashSet<ElementHandle<TypeElement>>();
                hashSet.add(elementHandle);
                Set set2 = (Set)object.get(elementHandle);
                if (set2 != null) {
                    hashSet.addAll(set2);
                }
                for (URL uRL3 : map.get(uRL2)) {
                    Map map3 = (Map)cloneable.get(uRL3);
                    Set set3 = map3 != null ? (Set)map3.get(elementHandle) : null;
                    if (set3 == null) continue;
                    hashSet.addAll(set3);
                }
                Set<ElementHandle<TypeElement>> set4 = this.computeUsers(uRL2, hashSet, lArray);
                if (set4 == null || this.cancel.get()) {
                    return null;
                }
                set4.removeAll(hashSet);
                Map map4 = (Map)cloneable.get(uRL2);
                if (map4 == null) {
                    LinkedHashMap linkedHashMap = new LinkedHashMap();
                    cloneable.put(uRL2, linkedHashMap);
                }
                var19_25.put(elementHandle, set4);
            }
        }
        return cloneable;
    }

    private void findOverriddenAnnotations(URL uRL, final Set<ElementHandle<TypeElement>> set, final ElementHandle<TypeElement> elementHandle, final List<ElementHandle<ExecutableElement>> list, final Map<ElementHandle<? extends Element>, List<ElementDescription>> map) {
        if (!set.isEmpty()) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)fileObject);
            JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
                        Element element = elementHandle.resolve((CompilationInfo)compilationController);
                        if (element == null) {
                            return;
                        }
                        for (ElementHandle elementHandle3 : set) {
                            Types types;
                            if (ComputeOverriders.this.cancel.get()) {
                                return;
                            }
                            TypeElement typeElement = (TypeElement)elementHandle3.resolve((CompilationInfo)compilationController);
                            if (typeElement == null || !hashSet.add(typeElement) || !(types = compilationController.getTypes()).isSubtype(types.erasure(typeElement.asType()), types.erasure(element.asType()))) continue;
                            LinkedList<ElementDescription> linkedList = (LinkedList<ElementDescription>)map.get(elementHandle);
                            if (linkedList == null) {
                                linkedList = new LinkedList<ElementDescription>();
                                map.put(elementHandle, linkedList);
                            }
                            linkedList.add(new ElementDescription((CompilationInfo)compilationController, typeElement, true));
                            for (ElementHandle elementHandle2 : list) {
                                ExecutableElement executableElement = (ExecutableElement)elementHandle2.resolve((CompilationInfo)compilationController);
                                if (executableElement != null) {
                                    ExecutableElement executableElement2 = ComputeOverriders.getImplementationOf((CompilationInfo)compilationController, executableElement, typeElement);
                                    if (executableElement2 == null) continue;
                                    ArrayList<ElementDescription> arrayList = (ArrayList<ElementDescription>)map.get(elementHandle2);
                                    if (arrayList == null) {
                                        arrayList = new ArrayList<ElementDescription>();
                                        map.put(elementHandle2, arrayList);
                                    }
                                    arrayList.add(new ElementDescription((CompilationInfo)compilationController, executableElement2, true));
                                    continue;
                                }
                                Logger.getLogger("global").log(Level.SEVERE, "IsOverriddenAnnotationHandler: originalMethod == null!");
                            }
                        }
                    }
                }, true);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    private static ExecutableElement getImplementationOf(CompilationInfo compilationInfo, ExecutableElement executableElement, TypeElement typeElement) {
        for (ExecutableElement executableElement2 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!compilationInfo.getElements().overrides(executableElement2, executableElement, typeElement)) continue;
            return executableElement2;
        }
        return null;
    }

    private static Map<URL, List<URL>> getDependencies(boolean bl) {
        if (dependenciesOverride != null) {
            return dependenciesOverride;
        }
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            return null;
        }
        Class<?> clazz = null;
        String string = null;
        try {
            clazz = classLoader.loadClass("org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController");
            string = bl ? "getBinaryRootDependencies" : "getRootDependencies";
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(GoToImplementation.class.getName()).log(Level.FINE, null, classNotFoundException);
            try {
                clazz = classLoader.loadClass("org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater");
                string = bl ? "getDependencies" : "doesnotexist";
            }
            catch (ClassNotFoundException classNotFoundException2) {
                Logger.getLogger(GoToImplementation.class.getName()).log(Level.FINE, null, classNotFoundException2);
                return null;
            }
        }
        try {
            Method method = clazz.getDeclaredMethod("getDefault", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getDeclaredMethod(string, new Class[0]);
            return (Map)method2.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(GoToImplementation.class.getName()).log(Level.FINE, null, illegalAccessException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(GoToImplementation.class.getName()).log(Level.FINE, null, illegalArgumentException);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(GoToImplementation.class.getName()).log(Level.FINE, null, invocationTargetException);
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger(GoToImplementation.class.getName()).log(Level.FINE, null, noSuchMethodException);
            return null;
        }
        catch (SecurityException securityException) {
            Logger.getLogger(GoToImplementation.class.getName()).log(Level.FINE, null, securityException);
            return null;
        }
        catch (ClassCastException classCastException) {
            Logger.getLogger(GoToImplementation.class.getName()).log(Level.FINE, null, classCastException);
            return null;
        }
    }
}

