/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.openide.util.Exceptions;

class CamelCaseOperations {
    CamelCaseOperations() {
    }

    static int nextCamelCasePosition(JTextComponent textComponent) throws BadLocationException {
        String image;
        SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)textComponent);
        if (syntaxSupport == null) {
            return -1;
        }
        int offset = textComponent.getCaretPosition();
        TokenItem tokenItem = ((ExtSyntaxSupport)syntaxSupport).getTokenChain(offset, offset + 1);
        if (tokenItem != null && "identifier".equals(tokenItem.getTokenID().getName()) && (image = tokenItem.getImage()) != null && image.length() > 0) {
            int length = image.length();
            if (offset != tokenItem.getOffset() + length) {
                char charAtI;
                int i;
                int offsetInImage = offset - tokenItem.getOffset();
                int start = offsetInImage + 1;
                if (Character.isUpperCase(image.charAt(offsetInImage))) {
                    for (i = start; i < length && Character.isUpperCase(charAtI = image.charAt(i)); ++i) {
                        ++start;
                    }
                }
                for (i = start; i < length; ++i) {
                    charAtI = image.charAt(i);
                    if (!Character.isUpperCase(charAtI)) continue;
                    return tokenItem.getOffset() + i;
                }
            }
            return tokenItem.getOffset() + image.length();
        }
        return Utilities.getNextWord((JTextComponent)textComponent, (int)offset);
    }

    static int previousCamelCasePosition(JTextComponent textComponent) throws BadLocationException {
        SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)textComponent);
        if (syntaxSupport == null) {
            return -1;
        }
        int offset = textComponent.getCaretPosition();
        if (offset == 0) {
            return -1;
        }
        TokenItem tokenItem = ((ExtSyntaxSupport)syntaxSupport).getTokenChain(offset - 1, offset);
        if (tokenItem != null) {
            if ("identifier".equals(tokenItem.getTokenID().getName())) {
                String image = tokenItem.getImage();
                if (image != null && image.length() > 0) {
                    int length = image.length();
                    int offsetInImage = offset - 1 - tokenItem.getOffset();
                    if (Character.isUpperCase(image.charAt(offsetInImage))) {
                        for (int i = offsetInImage - 1; i >= 0; --i) {
                            char charAtI = image.charAt(i);
                            if (Character.isUpperCase(charAtI)) continue;
                            return tokenItem.getOffset() + i + 1;
                        }
                        return tokenItem.getOffset();
                    }
                    for (int i = offsetInImage - 1; i >= 0; --i) {
                        char charAtI = image.charAt(i);
                        if (!Character.isUpperCase(charAtI)) continue;
                        for (int j = i; j >= 0; --j) {
                            char charAtJ = image.charAt(j);
                            if (Character.isUpperCase(charAtJ)) continue;
                            return tokenItem.getOffset() + j + 1;
                        }
                        return tokenItem.getOffset();
                    }
                    return tokenItem.getOffset();
                }
            } else if ("whitespace".equals(tokenItem.getTokenID().getName())) {
                TokenItem whitespaceTokenItem = tokenItem;
                while (whitespaceTokenItem != null && "whitespace".equals(whitespaceTokenItem.getTokenID().getName())) {
                    int wsOffset = whitespaceTokenItem.getOffset();
                    if (wsOffset == 0) {
                        return 0;
                    }
                    whitespaceTokenItem = ((ExtSyntaxSupport)syntaxSupport).getTokenChain(wsOffset - 1, wsOffset);
                }
                if (whitespaceTokenItem != null) {
                    return whitespaceTokenItem.getOffset() + whitespaceTokenItem.getImage().length();
                }
            }
        }
        return Utilities.getPreviousWord((JTextComponent)textComponent, (int)offset);
    }

    static void replaceChar(JTextComponent textComponent, int offset, char c) {
        if (!textComponent.isEditable()) {
            return;
        }
        CamelCaseOperations.replaceText(textComponent, offset, 1, String.valueOf(c));
    }

    static void replaceText(final JTextComponent textComponent, final int offset, final int length, final String text) {
        if (!textComponent.isEditable()) {
            return;
        }
        Document document = textComponent.getDocument();
        if (document instanceof BaseDocument) {
            ((BaseDocument)document).runAtomic(new Runnable(){

                @Override
                public void run() {
                    CamelCaseOperations.replaceText2(textComponent, offset, length, text);
                }
            });
        } else {
            CamelCaseOperations.replaceText2(textComponent, offset, length, text);
        }
    }

    static void replaceText2(JTextComponent textComponent, int offset, int length, String text) {
        Document document = textComponent.getDocument();
        try {
            if (length > 0) {
                document.remove(offset, length);
            }
            document.insertString(offset, text, null);
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
    }
}

