/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.beans.ui.customizer.ConfigFilesUIs;
import org.netbeans.modules.spring.beans.ui.customizer.SelectConfigFilesPanel;
import org.netbeans.modules.spring.util.ConfigFiles;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SpringCustomizerPanel
extends JPanel
implements HelpCtx.Provider {
    private final Project project;
    private final List<File> files;
    private final List<ConfigFileGroup> groups;
    private final File basedir;
    private final ConfigFilesUIs.FileDisplayName fileDisplayName;
    private ConfigFileGroup currentGroup;
    private int currentGroupIndex;
    private List<File> detectedFiles;
    private JButton addFileButton;
    private JButton addGroupButton;
    private JButton addGroupFilesButton;
    private JPanel configFileGroupsPanel;
    private JPanel configFilesPanel;
    private JButton detectFilesButton;
    private JButton editGroupButton;
    private JLabel filesLabel;
    private JList filesList;
    private JScrollPane filesScrollPane;
    private JLabel groupFilesLabel;
    private JList groupFilesList;
    private JScrollPane groupFilesScrollPane;
    private JLabel groupsLabel;
    private JList groupsList;
    private JScrollPane groupsScrollPane;
    private JButton removeFileButton;
    private JButton removeGroupButton;
    private JButton removeGroupFileButton;
    private JTabbedPane springConfigPane;

    public SpringCustomizerPanel(Project project, List<File> files, List<ConfigFileGroup> groups) {
        this.project = project;
        this.files = files;
        this.groups = groups;
        this.basedir = FileUtil.toFile((FileObject)project.getProjectDirectory());
        if (this.basedir == null) {
            throw new IllegalStateException("The directory of project " + project + " is null");
        }
        this.fileDisplayName = new RelativeDisplayName();
        this.initComponents();
        ConfigFilesUIs.setupFilesList(this.filesList, this.fileDisplayName);
        ConfigFilesUIs.setupGroupsList(this.groupsList);
        ConfigFilesUIs.setupFilesList(this.groupFilesList, this.fileDisplayName);
        ConfigFilesUIs.connectFilesList(files, this.filesList);
        ConfigFilesUIs.connectGroupsList(groups, this.groupsList);
        this.filesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SpringCustomizerPanel.this.filesListSelectionChanged();
            }
        });
        this.groupsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SpringCustomizerPanel.this.groupsListSelectionChanged();
            }
        });
        this.groupFilesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SpringCustomizerPanel.this.groupFilesListSelectionChanged();
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SpringCustomizerPanel.class);
    }

    public List<File> getConfigFiles() {
        return this.files;
    }

    public List<ConfigFileGroup> getConfigFileGroups() {
        return this.groups;
    }

    private void filesListSelectionChanged() {
        boolean selected = this.filesList.getSelectedIndex() != -1;
        this.removeFileButton.setEnabled(selected);
    }

    private void groupsListSelectionChanged() {
        this.currentGroupIndex = this.groupsList.getSelectedIndex();
        if (this.currentGroupIndex != -1) {
            this.currentGroup = (ConfigFileGroup)this.groupsList.getModel().getElementAt(this.currentGroupIndex);
            ConfigFilesUIs.connectFilesList(this.currentGroup.getFiles(), this.groupFilesList);
            this.editGroupButton.setEnabled(true);
            this.removeGroupButton.setEnabled(true);
            this.addGroupFilesButton.setEnabled(true);
            this.detectFilesButton.setEnabled(true);
            String currentGroupName = ConfigFilesUIs.getGroupName(this.currentGroup);
            this.groupFilesLabel.setText(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFilesInGroup", (Object)currentGroupName));
            this.groupFilesList.setSelectedIndices(new int[0]);
        } else {
            this.currentGroup = null;
            ConfigFilesUIs.disconnect(this.groupFilesList);
            this.editGroupButton.setEnabled(false);
            this.removeGroupButton.setEnabled(false);
            this.addGroupFilesButton.setEnabled(false);
            this.detectFilesButton.setEnabled(false);
            this.groupFilesLabel.setText(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFiles"));
        }
    }

    private void groupFilesListSelectionChanged() {
        boolean selected = this.groupFilesList.getSelectedIndex() != -1;
        this.removeGroupFileButton.setEnabled(selected);
    }

    private void replaceCurrentGroup(ConfigFileGroup newGroup) {
        this.groups.set(this.currentGroupIndex, newGroup);
        int selIndex = this.currentGroupIndex;
        ConfigFilesUIs.connectGroupsList(this.groups, this.groupsList);
        this.groupsList.setSelectedIndex(selIndex);
    }

    private void addFiles(List<File> newFiles) {
        this.files.addAll(newFiles);
        ConfigFilesUIs.connectFilesList(this.files, this.filesList);
        this.filesList.setSelectedIndex(this.filesList.getModel().getSize() - 1);
    }

    private void removeFiles() {
        int i;
        ArrayList<File> removedFiles = new ArrayList<File>();
        int[] indices = this.filesList.getSelectedIndices();
        for (i = 0; i < indices.length; ++i) {
            removedFiles.add(this.files.remove(indices[i] - i));
        }
        for (i = 0; i < this.groups.size(); ++i) {
            ConfigFileGroup group = this.groups.get(i);
            List<File> groupFiles = group.getFiles();
            if (!groupFiles.removeAll(removedFiles)) continue;
            ConfigFileGroup newGroup = ConfigFileGroup.create(group.getName(), groupFiles);
            if (this.currentGroup == group) {
                this.replaceCurrentGroup(newGroup);
                continue;
            }
            this.groups.set(i, newGroup);
        }
        ConfigFilesUIs.connectFilesList(this.files, this.filesList);
        int selIndex = Math.min(indices[0], this.filesList.getModel().getSize() - 1);
        this.filesList.setSelectedIndex(selIndex);
    }

    private void addGroup(ConfigFileGroup group) {
        this.groups.add(group);
        ConfigFilesUIs.connectGroupsList(this.groups, this.groupsList);
        this.groupsList.setSelectedIndex(this.groupsList.getModel().getSize() - 1);
    }

    private void removeGroups() {
        int[] indices = this.groupsList.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            this.groups.remove(indices[i] - i);
        }
        ConfigFilesUIs.connectGroupsList(this.groups, this.groupsList);
        int selIndex = Math.min(indices[0], this.groupsList.getModel().getSize() - 1);
        this.groupsList.setSelectedIndex(selIndex);
    }

    private void addFilesToCurrentGroup(List<File> newFiles) {
        List<File> groupFiles = this.currentGroup.getFiles();
        groupFiles.addAll(newFiles);
        ConfigFileGroup newGroup = ConfigFileGroup.create(this.currentGroup.getName(), groupFiles);
        this.replaceCurrentGroup(newGroup);
        this.groupFilesList.setSelectedIndex(this.groupFilesList.getModel().getSize() - 1);
    }

    private void removeFilesFromCurrentGroup() {
        List<File> groupFiles = this.currentGroup.getFiles();
        int[] indices = this.groupFilesList.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            groupFiles.remove(indices[i] - i);
        }
        this.replaceCurrentGroup(ConfigFileGroup.create(this.currentGroup.getName(), groupFiles));
        int selIndex = Math.min(indices[0], this.groupFilesList.getModel().getSize() - 1);
        this.groupFilesList.setSelectedIndex(selIndex);
    }

    private void initComponents() {
        this.springConfigPane = new JTabbedPane();
        this.configFilesPanel = new JPanel();
        this.filesLabel = new JLabel();
        this.filesScrollPane = new JScrollPane();
        this.filesList = new JList();
        this.addFileButton = new JButton();
        this.removeFileButton = new JButton();
        this.detectFilesButton = new JButton();
        this.configFileGroupsPanel = new JPanel();
        this.groupsLabel = new JLabel();
        this.groupsScrollPane = new JScrollPane();
        this.groupsList = new JList();
        this.addGroupButton = new JButton();
        this.editGroupButton = new JButton();
        this.removeGroupButton = new JButton();
        this.groupFilesLabel = new JLabel();
        this.groupFilesScrollPane = new JScrollPane();
        this.groupFilesList = new JList();
        this.addGroupFilesButton = new JButton();
        this.removeGroupFileButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.filesLabel, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFiles"));
        this.filesScrollPane.setViewportView(this.filesList);
        Mnemonics.setLocalizedText((AbstractButton)this.addFileButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_AddFile"));
        this.addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpringCustomizerPanel.this.addFileButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeFileButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_RemoveFile"));
        this.removeFileButton.setEnabled(false);
        this.removeFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpringCustomizerPanel.this.removeFileButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.detectFilesButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_DetectFiles"));
        this.detectFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpringCustomizerPanel.this.detectFilesButtonActionPerformed(evt);
            }
        });
        GroupLayout configFilesPanelLayout = new GroupLayout((Container)this.configFilesPanel);
        this.configFilesPanel.setLayout((LayoutManager)configFilesPanelLayout);
        configFilesPanelLayout.setHorizontalGroup((GroupLayout.Group)configFilesPanelLayout.createParallelGroup(1).add((GroupLayout.Group)configFilesPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)configFilesPanelLayout.createParallelGroup(1).add((Component)this.filesLabel).add((Component)this.filesScrollPane, -1, 273, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)configFilesPanelLayout.createParallelGroup(2).add((Component)this.removeFileButton, -1, -1, Short.MAX_VALUE).add((Component)this.detectFilesButton, -1, -1, Short.MAX_VALUE).add((Component)this.addFileButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        configFilesPanelLayout.linkSize(new Component[]{this.addFileButton, this.detectFilesButton, this.removeFileButton}, 1);
        configFilesPanelLayout.setVerticalGroup((GroupLayout.Group)configFilesPanelLayout.createParallelGroup(1).add((GroupLayout.Group)configFilesPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.filesLabel).add(6, 6, 6).add((GroupLayout.Group)configFilesPanelLayout.createParallelGroup(1).add((GroupLayout.Group)configFilesPanelLayout.createSequentialGroup().add((Component)this.addFileButton).addPreferredGap(0).add((Component)this.detectFilesButton).addPreferredGap(0).add((Component)this.removeFileButton)).add((Component)this.filesScrollPane, -1, 334, Short.MAX_VALUE)).addContainerGap()));
        this.springConfigPane.addTab(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFilesTitle"), this.configFilesPanel);
        Mnemonics.setLocalizedText((JLabel)this.groupsLabel, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFileGroups"));
        this.groupsLabel.setFocusable(false);
        this.groupsScrollPane.setViewportView(this.groupsList);
        Mnemonics.setLocalizedText((AbstractButton)this.addGroupButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_AddGroup"));
        this.addGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpringCustomizerPanel.this.addGroupButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editGroupButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_EditGroup"));
        this.editGroupButton.setEnabled(false);
        this.editGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpringCustomizerPanel.this.editGroupButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeGroupButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_RemoveGroup"));
        this.removeGroupButton.setEnabled(false);
        this.removeGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpringCustomizerPanel.this.removeGroupButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.groupFilesLabel, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFiles"));
        this.groupFilesLabel.setFocusable(false);
        this.groupFilesScrollPane.setViewportView(this.groupFilesList);
        Mnemonics.setLocalizedText((AbstractButton)this.addGroupFilesButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_AddFiles"));
        this.addGroupFilesButton.setEnabled(false);
        this.addGroupFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpringCustomizerPanel.this.addGroupFilesButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeGroupFileButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_RemoveFile"));
        this.removeGroupFileButton.setEnabled(false);
        this.removeGroupFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpringCustomizerPanel.this.removeGroupFileButtonActionPerformed(evt);
            }
        });
        GroupLayout configFileGroupsPanelLayout = new GroupLayout((Container)this.configFileGroupsPanel);
        this.configFileGroupsPanel.setLayout((LayoutManager)configFileGroupsPanelLayout);
        configFileGroupsPanelLayout.setHorizontalGroup((GroupLayout.Group)configFileGroupsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)configFileGroupsPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)configFileGroupsPanelLayout.createParallelGroup(1).add((Component)this.groupFilesLabel).add(2, (GroupLayout.Group)configFileGroupsPanelLayout.createSequentialGroup().add((GroupLayout.Group)configFileGroupsPanelLayout.createParallelGroup(2).add(1, (Component)this.groupFilesScrollPane, -1, 267, Short.MAX_VALUE).add(1, (Component)this.groupsLabel).add(1, (Component)this.groupsScrollPane, -1, 267, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)configFileGroupsPanelLayout.createParallelGroup(1, false).add((Component)this.removeGroupButton, 0, -1, Short.MAX_VALUE).add((Component)this.editGroupButton, -1, -1, Short.MAX_VALUE).add(2, (Component)this.addGroupButton, -1, -1, Short.MAX_VALUE).add(2, (Component)this.addGroupFilesButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeGroupFileButton, -2, -1, -2)))).addContainerGap()));
        configFileGroupsPanelLayout.linkSize(new Component[]{this.addGroupButton, this.addGroupFilesButton, this.editGroupButton, this.removeGroupButton, this.removeGroupFileButton}, 1);
        configFileGroupsPanelLayout.setVerticalGroup((GroupLayout.Group)configFileGroupsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)configFileGroupsPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.groupsLabel).addPreferredGap(0).add((GroupLayout.Group)configFileGroupsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)configFileGroupsPanelLayout.createSequentialGroup().add((Component)this.addGroupButton).addPreferredGap(0).add((Component)this.editGroupButton).addPreferredGap(0).add((Component)this.removeGroupButton)).add((GroupLayout.Group)configFileGroupsPanelLayout.createSequentialGroup().add((Component)this.groupsScrollPane, -2, -1, -2).addPreferredGap(0).add((Component)this.groupFilesLabel))).addPreferredGap(0).add((GroupLayout.Group)configFileGroupsPanelLayout.createParallelGroup(1).add((Component)this.groupFilesScrollPane, -1, 176, Short.MAX_VALUE).add((GroupLayout.Group)configFileGroupsPanelLayout.createSequentialGroup().add((Component)this.addGroupFilesButton).addPreferredGap(0).add((Component)this.removeGroupFileButton))).addContainerGap()));
        this.springConfigPane.addTab(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFileGroupsTitle"), this.configFileGroupsPanel);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.springConfigPane, -1, 436, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.springConfigPane, -1, 406, Short.MAX_VALUE));
    }

    private void addFileButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ChooseFile"));
        chooser.setCurrentDirectory(this.basedir);
        int option = chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this.groupFilesList));
        if (option == 0) {
            File newFile = chooser.getSelectedFile();
            if (this.files.contains(newFile)) {
                String message = NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_FileAlreadyAdded");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            } else {
                this.addFiles(Collections.singletonList(newFile));
            }
        }
    }

    private void removeFileButtonActionPerformed(ActionEvent evt) {
        this.removeFiles();
    }

    private void detectFilesButtonActionPerformed(ActionEvent evt) {
        HashSet<File> alreadySelectedFiles = new HashSet<File>(this.files);
        SelectConfigFilesPanel panel = this.detectedFiles != null ? SelectConfigFilesPanel.create(this.detectedFiles, alreadySelectedFiles, this.fileDisplayName) : SelectConfigFilesPanel.create(this.project, alreadySelectedFiles, this.fileDisplayName);
        if (panel.open()) {
            List<File> availableFiles = panel.getAvailableFiles();
            if (availableFiles != null) {
                this.detectedFiles = availableFiles;
            }
            this.addFiles(panel.getSelectedFiles());
        }
    }

    private void addGroupButtonActionPerformed(ActionEvent evt) {
        NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_GroupName"), NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_NewConfigFileGroup"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)input);
        if (input.getValue() == NotifyDescriptor.OK_OPTION) {
            this.addGroup(ConfigFileGroup.create(input.getInputText(), Collections.<File>emptyList()));
        }
    }

    private void editGroupButtonActionPerformed(ActionEvent evt) {
        NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_GroupName"), NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_EditConfigFileGroup"));
        String currentName = this.currentGroup.getName();
        if (currentName != null) {
            input.setInputText(currentName);
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)input);
        if (input.getValue() == NotifyDescriptor.OK_OPTION) {
            this.replaceCurrentGroup(ConfigFileGroup.create(input.getInputText(), this.currentGroup.getFiles()));
        }
    }

    private void removeGroupButtonActionPerformed(ActionEvent evt) {
        this.removeGroups();
    }

    private void addGroupFilesButtonActionPerformed(ActionEvent evt) {
        if (this.files.size() == 0) {
            String message = NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_NoFilesAdded");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            return;
        }
        HashSet<File> alreadySelectedFiles = new HashSet<File>(this.groups.get(this.currentGroupIndex).getFiles());
        SelectConfigFilesPanel panel = SelectConfigFilesPanel.create(this.files, alreadySelectedFiles, this.fileDisplayName);
        if (panel.open()) {
            this.addFilesToCurrentGroup(panel.getSelectedFiles());
        }
    }

    private void removeGroupFileButtonActionPerformed(ActionEvent evt) {
        this.removeFilesFromCurrentGroup();
    }

    private final class RelativeDisplayName
    implements ConfigFilesUIs.FileDisplayName {
        private Map<File, String> abs2Rel = new HashMap<File, String>();

        private RelativeDisplayName() {
        }

        @Override
        public String getDisplayName(File absolute) {
            String relative = this.abs2Rel.get(absolute);
            if (relative == null) {
                relative = ConfigFiles.getRelativePath(SpringCustomizerPanel.this.basedir, absolute);
                this.abs2Rel.put(absolute, relative);
            }
            return relative;
        }
    }
}

