/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorFactory;
import org.netbeans.modules.spring.beans.completion.completors.AttributeValueCompletorFactory;
import org.netbeans.modules.spring.beans.completion.completors.BeanDependsOnCompletor;
import org.netbeans.modules.spring.beans.completion.completors.BeanIdCompletor;
import org.netbeans.modules.spring.beans.completion.completors.BeansRefCompletor;
import org.netbeans.modules.spring.beans.completion.completors.BeansRefCompletorFactory;
import org.netbeans.modules.spring.beans.completion.completors.FactoryMethodCompletor;
import org.netbeans.modules.spring.beans.completion.completors.GenericCompletorFactory;
import org.netbeans.modules.spring.beans.completion.completors.InitDestroyMethodCompletor;
import org.netbeans.modules.spring.beans.completion.completors.JavaClassCompletor;
import org.netbeans.modules.spring.beans.completion.completors.PNamespaceBeanRefCompletor;
import org.netbeans.modules.spring.beans.completion.completors.PNamespaceCompletor;
import org.netbeans.modules.spring.beans.completion.completors.PropertyCompletor;
import org.netbeans.modules.spring.beans.completion.completors.ResourceCompletor;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.utils.StringUtils;

public final class CompletorRegistry {
    private static Map<String, CompletorFactory> completorFactories = new HashMap<String, CompletorFactory>();
    private static CompletorRegistry INSTANCE = new CompletorRegistry();

    private CompletorRegistry() {
        this.setupCompletors();
    }

    private void setupCompletors() {
        String[] stringArray = new String[]{"true", null, "false", null};
        AttributeValueCompletorFactory attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray);
        this.registerCompletorFactory("bean", "primary", attributeValueCompletorFactory);
        String[] stringArray2 = new String[]{"true", null, "false", null};
        attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray2);
        this.registerCompletorFactory("beans", "default-lazy-init", attributeValueCompletorFactory);
        String[] stringArray3 = new String[]{"true", null, "false", null};
        attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray3);
        this.registerCompletorFactory("beans", "default-merge", attributeValueCompletorFactory);
        String[] stringArray4 = new String[]{"true", null, "false", null};
        attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray4);
        this.registerCompletorFactory("bean", "abstract", attributeValueCompletorFactory);
        this.registerCompletorFactory("import", "resource", new GenericCompletorFactory(ResourceCompletor.class));
        GenericCompletorFactory genericCompletorFactory = new GenericCompletorFactory(JavaClassCompletor.class);
        this.registerCompletorFactory("bean", "class", genericCompletorFactory);
        this.registerCompletorFactory("list", "value-type", genericCompletorFactory);
        this.registerCompletorFactory("map", "value-type", genericCompletorFactory);
        this.registerCompletorFactory("map", "key-type", genericCompletorFactory);
        this.registerCompletorFactory("set", "value-type", genericCompletorFactory);
        this.registerCompletorFactory("value", "type", genericCompletorFactory);
        this.registerCompletorFactory("constructor-arg", "type", genericCompletorFactory);
        BeansRefCompletorFactory beansRefCompletorFactory = new BeansRefCompletorFactory(true, BeansRefCompletor.class);
        this.registerCompletorFactory("alias", "name", beansRefCompletorFactory);
        this.registerCompletorFactory("bean", "parent", beansRefCompletorFactory);
        this.registerCompletorFactory("bean", "factory-bean", beansRefCompletorFactory);
        this.registerCompletorFactory("constructor-arg", "ref", beansRefCompletorFactory);
        this.registerCompletorFactory("ref", "bean", beansRefCompletorFactory);
        this.registerCompletorFactory("idref", "bean", beansRefCompletorFactory);
        this.registerCompletorFactory("entry", "key-ref", beansRefCompletorFactory);
        this.registerCompletorFactory("entry", "value-ref", beansRefCompletorFactory);
        this.registerCompletorFactory("property", "ref", beansRefCompletorFactory);
        this.registerCompletorFactory("lookup-method", "bean", beansRefCompletorFactory);
        this.registerCompletorFactory("replaced-method", "replacer", beansRefCompletorFactory);
        beansRefCompletorFactory = new BeansRefCompletorFactory(false, BeansRefCompletor.class);
        this.registerCompletorFactory("ref", "local", beansRefCompletorFactory);
        this.registerCompletorFactory("idref", "local", beansRefCompletorFactory);
        GenericCompletorFactory genericCompletorFactory2 = new GenericCompletorFactory(InitDestroyMethodCompletor.class);
        this.registerCompletorFactory("bean", "init-method", genericCompletorFactory2);
        this.registerCompletorFactory("bean", "destroy-method", genericCompletorFactory2);
        this.registerCompletorFactory("lookup-method", "name", genericCompletorFactory2);
        this.registerCompletorFactory("replaced-method", "name", genericCompletorFactory2);
        genericCompletorFactory2 = new GenericCompletorFactory(FactoryMethodCompletor.class);
        this.registerCompletorFactory("bean", "factory-method", genericCompletorFactory2);
        GenericCompletorFactory genericCompletorFactory3 = new GenericCompletorFactory(PropertyCompletor.class);
        this.registerCompletorFactory("property", "name", genericCompletorFactory3);
        GenericCompletorFactory genericCompletorFactory4 = new GenericCompletorFactory(PNamespaceBeanRefCompletor.class);
        this.registerCompletorFactory("bean", null, genericCompletorFactory4);
        GenericCompletorFactory genericCompletorFactory5 = new GenericCompletorFactory(BeanIdCompletor.class);
        this.registerCompletorFactory("bean", "id", genericCompletorFactory5);
        BeansRefCompletorFactory beansRefCompletorFactory2 = new BeansRefCompletorFactory(true, BeanDependsOnCompletor.class);
        this.registerCompletorFactory("bean", "depends-on", beansRefCompletorFactory2);
    }

    public static CompletorRegistry getDefault() {
        return INSTANCE;
    }

    public Completor getCompletor(CompletionContext completionContext) {
        switch (completionContext.getCompletionType()) {
            case ATTRIBUTE_VALUE: {
                return this.getAttributeValueCompletor(completionContext);
            }
            case ATTRIBUTE: {
                return this.getAttributeCompletor(completionContext);
            }
            case TAG: {
                return this.getElementCompletor(completionContext);
            }
        }
        return null;
    }

    private Completor getAttributeValueCompletor(CompletionContext completionContext) {
        TokenItem tokenItem;
        String string;
        String string2 = completionContext.getTag().getNodeName();
        CompletorFactory completorFactory = this.locateCompletorFactory(string2, string = (tokenItem = ContextUtilities.getAttributeToken(completionContext.getCurrentToken())) != null ? tokenItem.getImage() : null);
        if (completorFactory != null) {
            Completor completor = completorFactory.createCompletor(completionContext.getCaretOffset());
            return completor;
        }
        return null;
    }

    private Completor getAttributeCompletor(CompletionContext completionContext) {
        String string = completionContext.getTag().getNodeName();
        if (string.equals("bean") && ContextUtilities.isPNamespaceAdded(completionContext.getDocumentContext())) {
            return new PNamespaceCompletor(completionContext.getCaretOffset());
        }
        return null;
    }

    private Completor getElementCompletor(CompletionContext completionContext) {
        return null;
    }

    private void registerCompletorFactory(String string, String string2, CompletorFactory completorFactory) {
        completorFactories.put(CompletorRegistry.createRegisteredName(string, string2), completorFactory);
    }

    private static String createRegisteredName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.hasText(string)) {
            stringBuilder.append("/nodeName=");
            stringBuilder.append(string);
        } else {
            stringBuilder.append("/nodeName=");
            stringBuilder.append("*");
        }
        if (StringUtils.hasText(string2)) {
            stringBuilder.append("/attribute=");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private CompletorFactory locateCompletorFactory(String string, String string2) {
        String string3 = CompletorRegistry.createRegisteredName(string, string2);
        if (completorFactories.containsKey(string3)) {
            return completorFactories.get(string3);
        }
        string3 = CompletorRegistry.createRegisteredName(string, null);
        if (completorFactories.containsKey(string3)) {
            return completorFactories.get(string3);
        }
        string3 = CompletorRegistry.createRegisteredName("*", string2);
        if (completorFactories.containsKey(string3)) {
            return completorFactories.get(string3);
        }
        return null;
    }
}

