/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CndAbstractTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmExpandedTokenProcessor;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceContextImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;

public final class FileReferencesImpl
extends CsmFileReferences {
    public void accept(CsmScope csmScope, CsmFileReferences.Visitor visitor) {
        this.accept(csmScope, visitor, CsmReferenceKind.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(CsmScope csmScope, CsmFileReferences.Visitor visitor, Set<CsmReferenceKind> kinds) {
        FileReferencesContext fileReferencesContext = new FileReferencesContext(csmScope);
        try {
            this._accept(csmScope, visitor, kinds, fileReferencesContext);
        }
        finally {
            fileReferencesContext.clean();
        }
    }

    private void _accept(CsmScope csmScope, CsmFileReferences.Visitor visitor, Set<CsmReferenceKind> kinds, FileReferencesContext fileReferncesContext) {
        int end;
        int start;
        if (!CsmKindUtilities.isOffsetable((Object)csmScope) && !CsmKindUtilities.isFile((CsmObject)csmScope)) {
            return;
        }
        CsmFile csmFile = null;
        csmFile = CsmKindUtilities.isFile((CsmObject)csmScope) ? (CsmFile)csmScope : ((CsmOffsetable)csmScope).getContainingFile();
        BaseDocument doc = ReferencesSupport.getDocument(csmFile);
        if (doc == null || !csmFile.isValid()) {
            return;
        }
        if (CsmKindUtilities.isFile((CsmObject)csmScope)) {
            start = 0;
            end = Math.max(0, doc.getLength() - 1);
        } else {
            start = ((CsmOffsetable)csmScope).getStartOffset();
            end = ((CsmOffsetable)csmScope).getEndOffset();
        }
        List<CsmReferenceContext> refs = this.getIdentifierReferences(csmFile, doc, start, end, kinds, fileReferncesContext);
        for (CsmReferenceContext context : refs) {
            if (this.isThis(context.getReference())) continue;
            visitor.visit(context);
        }
    }

    protected boolean isThis(CsmReference ref) {
        TokenItem<CppTokenId> refToken = ReferencesSupport.getRefTokenIfPossible(ref);
        if (refToken != null) {
            return refToken.id() == CppTokenId.THIS;
        }
        return super.isThis(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Collection<CsmReference> refs, CsmFileReferences.ReferenceVisitor visitor) {
        FileReferencesContext fileReferencesContext = null;
        try {
            for (CsmReference ref : refs) {
                if (fileReferencesContext == null) {
                    fileReferencesContext = new FileReferencesContext((CsmScope)ref.getContainingFile());
                }
                if (ref instanceof ReferenceImpl) {
                    ((ReferenceImpl)ref).setFileReferencesContext(fileReferencesContext);
                }
                visitor.visit(ref);
            }
        }
        finally {
            if (fileReferencesContext != null) {
                fileReferencesContext.clean();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CsmReferenceContext> getIdentifierReferences(CsmFile csmFile, BaseDocument doc, int start, int end, Set<CsmReferenceKind> kinds, FileReferencesContext fileReferncesContext) {
        ExpandedReferencesProcessor merp = ExpandedReferencesProcessor.create(doc, csmFile, kinds, fileReferncesContext);
        doc.readLock();
        try {
            CndTokenUtilities.processTokens((CndTokenProcessor)merp, (Document)doc, (int)start, (int)end);
        }
        finally {
            doc.readUnlock();
        }
        return merp.getReferences();
    }

    private static boolean isInDeadBlock(int startOffset, Collection<CsmOffsetable> deadBlocks) {
        for (CsmOffsetable csmOffsetable : deadBlocks) {
            if (csmOffsetable.getStartOffset() > startOffset) {
                return false;
            }
            if (csmOffsetable.getEndOffset() <= startOffset) continue;
            return true;
        }
        return false;
    }

    private static class BlockConsumer {
        private final CppTokenId openBracket;
        private final CppTokenId closeBracket;
        private int depth;

        public BlockConsumer(CppTokenId openBracket, CppTokenId closeBracket) {
            this.openBracket = openBracket;
            this.closeBracket = closeBracket;
            this.depth = 0;
        }

        public boolean isLastToken(Token<CppTokenId> token) {
            boolean stop = false;
            if (token.id() == this.openBracket) {
                ++this.depth;
            } else if (token.id() == this.closeBracket) {
                --this.depth;
                stop = this.depth <= 0;
            }
            return stop;
        }
    }

    private static final class ReferenceContextBuilder {
        private static final int FULLCOPY_INTERVAL = 50;
        private ReferenceContextImpl context;
        private final List<CppTokenId> brackets;
        private final List<Integer> pushes;
        private int snapshots;

        public ReferenceContextBuilder() {
            this.context = new ReferenceContextImpl();
            this.brackets = new ArrayList<CppTokenId>();
            this.pushes = new ArrayList<Integer>();
            this.pushes.add(0);
        }

        public ReferenceContextBuilder(ReferenceContextBuilder b) {
            this.context = new ReferenceContextImpl(b.context);
            this.brackets = new ArrayList<CppTokenId>(b.brackets);
            this.pushes = new ArrayList<Integer>(b.pushes);
            this.snapshots = b.snapshots;
        }

        public void open(CppTokenId leftBracket) {
            if (ReferenceContextBuilder.peek(this.pushes) == 0 && ReferenceContextBuilder.peek(this.brackets) != null) {
                this.context.push(ReferenceContextBuilder.peek(this.brackets), null);
                ReferenceContextBuilder.pop(this.pushes);
                this.pushes.add(1);
            }
            this.brackets.add(leftBracket);
            this.pushes.add(0);
        }

        public void close(CppTokenId rightBracket) {
            if (ReferenceContextBuilder.match(ReferenceContextBuilder.peek(this.brackets), rightBracket)) {
                ReferenceContextBuilder.pop(this.brackets);
                for (int i = 0; i < ReferenceContextBuilder.peek(this.pushes); ++i) {
                    this.context.pop();
                }
                ReferenceContextBuilder.pop(this.pushes);
            }
        }

        public void other(CppTokenId token) {
            if (token == CppTokenId.SEMICOLON && ReferenceContextBuilder.peek(this.brackets) == CppTokenId.LT) {
                this.close(CppTokenId.GT);
            }
            for (int i = 0; i < ReferenceContextBuilder.peek(this.pushes); ++i) {
                this.context.pop();
            }
            ReferenceContextBuilder.pop(this.pushes);
            this.pushes.add(0);
        }

        public void reference(CsmReference ref, CppTokenId derefToken) {
            int pushCount = 0;
            if (derefToken == null) {
                this.other(CppTokenId.IDENTIFIER);
                this.context.push(ReferenceContextBuilder.peek(this.brackets), ref);
                ++pushCount;
            } else {
                if (ReferenceContextBuilder.peek(this.pushes) == 0 && ReferenceContextBuilder.peek(this.brackets) != null) {
                    this.context.push(ReferenceContextBuilder.peek(this.brackets), null);
                    ++pushCount;
                }
                this.context.push(derefToken, ref);
                ++pushCount;
            }
            this.pushes.add(ReferenceContextBuilder.pop(this.pushes) + pushCount);
        }

        private static <T> T peek(List<T> list) {
            if (list.isEmpty()) {
                return null;
            }
            return list.get(list.size() - 1);
        }

        private static <T> T pop(List<T> list) {
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.remove(list.size() - 1);
        }

        private static boolean match(CppTokenId l, CppTokenId r) {
            return l == CppTokenId.LBRACE && r == CppTokenId.RBRACE || l == CppTokenId.LBRACKET && r == CppTokenId.RBRACKET || l == CppTokenId.LPAREN && r == CppTokenId.RPAREN || l == CppTokenId.LT && r == CppTokenId.GT;
        }

        public CsmReferenceContext getContext() {
            ReferenceContextImpl snapshot;
            if (50 <= this.snapshots++) {
                snapshot = new ReferenceContextImpl(this.context, true);
                this.snapshots = 0;
            } else {
                snapshot = this.context;
            }
            this.context = new ReferenceContextImpl(snapshot, false);
            return snapshot;
        }

        public String toString() {
            return String.valueOf(this.context);
        }
    }

    private static final class ReferencesProcessor
    extends CndAbstractTokenProcessor<Token<CppTokenId>> {
        final List<CsmReferenceContext> references = new ArrayList<CsmReferenceContext>();
        private final Collection<CsmOffsetable> deadBlocks;
        private final boolean needAfterDereferenceUsages;
        private final boolean skipPreprocDirectives;
        private final CsmFile csmFile;
        private final BaseDocument doc;
        private final ReferenceContextBuilder contextBuilder;
        private final FileReferencesContext fileReferncesContext;
        private CppTokenId derefToken;
        private BlockConsumer blockConsumer;
        private boolean afterParen = false;
        private boolean skipReferences = false;

        ReferencesProcessor(CsmFile csmFile, BaseDocument doc, boolean skipPreprocDirectives, boolean needAfterDereferenceUsages, Collection<CsmOffsetable> deadBlocks, FileReferencesContext fileReferncesContext) {
            this.deadBlocks = deadBlocks;
            this.needAfterDereferenceUsages = needAfterDereferenceUsages;
            this.skipPreprocDirectives = skipPreprocDirectives;
            this.csmFile = csmFile;
            this.doc = doc;
            this.contextBuilder = new ReferenceContextBuilder();
            this.fileReferncesContext = fileReferncesContext;
        }

        private ReferencesProcessor(ReferencesProcessor p) {
            this.deadBlocks = p.deadBlocks;
            this.needAfterDereferenceUsages = p.needAfterDereferenceUsages;
            this.skipPreprocDirectives = p.skipPreprocDirectives;
            this.csmFile = p.csmFile;
            this.doc = p.doc;
            this.fileReferncesContext = p.fileReferncesContext;
            this.contextBuilder = new ReferenceContextBuilder(p.contextBuilder);
            this.derefToken = p.derefToken;
            this.afterParen = p.afterParen;
            this.skipReferences = p.skipReferences;
        }

        private void skipReferences(boolean skip) {
            this.skipReferences = skip;
        }

        public boolean token(Token<CppTokenId> token, int tokenOffset) {
            if (this.blockConsumer != null) {
                if (this.blockConsumer.isLastToken(token)) {
                    this.blockConsumer = null;
                }
                return false;
            }
            boolean skip = false;
            boolean needEmbedding = false;
            switch ((CppTokenId)token.id()) {
                case PREPROCESSOR_DIRECTIVE: {
                    needEmbedding = !this.skipPreprocDirectives;
                    break;
                }
                case IDENTIFIER: 
                case PREPROCESSOR_IDENTIFIER: 
                case THIS: {
                    boolean bl = skip = !this.needAfterDereferenceUsages && this.derefToken != null;
                    if (!skip && !this.deadBlocks.isEmpty()) {
                        skip = FileReferencesImpl.isInDeadBlock(tokenOffset, this.deadBlocks);
                    }
                    ReferenceImpl ref = ReferencesSupport.createReferenceImpl(this.csmFile, this.doc, tokenOffset, (TokenItem<CppTokenId>)CndTokenUtilities.createTokenItem(token, (int)tokenOffset), this.derefToken == null ? null : null);
                    this.contextBuilder.reference(ref, this.derefToken);
                    ref.setFileReferencesContext(this.fileReferncesContext);
                    this.derefToken = null;
                    if (skip || this.skipReferences) break;
                    this.references.add(this.contextBuilder.getContext());
                    break;
                }
                case DOT: 
                case DOTMBR: 
                case ARROW: 
                case ARROWMBR: 
                case SCOPE: {
                    this.derefToken = (CppTokenId)token.id();
                    break;
                }
                case LBRACE: {
                    if (this.afterParen) {
                        this.blockConsumer = new BlockConsumer(CppTokenId.LBRACE, CppTokenId.RBRACE);
                    } else {
                        this.contextBuilder.open((CppTokenId)token.id());
                    }
                    this.derefToken = null;
                    break;
                }
                case LBRACKET: 
                case LPAREN: 
                case LT: {
                    this.contextBuilder.open((CppTokenId)token.id());
                    this.derefToken = null;
                    break;
                }
                case RBRACE: 
                case RBRACKET: 
                case RPAREN: 
                case GT: {
                    this.contextBuilder.close((CppTokenId)token.id());
                    this.derefToken = null;
                    break;
                }
                case __ATTRIBUTE__: 
                case __ATTRIBUTE: 
                case _DECLSPEC: 
                case __DECLSPEC: 
                case ASM: 
                case __ASM: 
                case __ASM__: {
                    this.blockConsumer = new BlockConsumer(CppTokenId.LPAREN, CppTokenId.RPAREN);
                    this.derefToken = null;
                    break;
                }
                case _ASM: {
                    this.blockConsumer = new BlockConsumer(CppTokenId.LBRACE, CppTokenId.RBRACE);
                    this.derefToken = null;
                    break;
                }
                case WHITESPACE: 
                case NEW_LINE: 
                case BLOCK_COMMENT: 
                case LINE_COMMENT: 
                case DOXYGEN_LINE_COMMENT: 
                case TEMPLATE: {
                    break;
                }
                default: {
                    this.contextBuilder.other((CppTokenId)token.id());
                    this.derefToken = null;
                }
            }
            switch ((CppTokenId)token.id()) {
                case LPAREN: {
                    this.afterParen = true;
                    break;
                }
                case WHITESPACE: 
                case NEW_LINE: 
                case BLOCK_COMMENT: 
                case LINE_COMMENT: 
                case DOXYGEN_LINE_COMMENT: {
                    break;
                }
                default: {
                    this.afterParen = false;
                }
            }
            return needEmbedding;
        }
    }

    private static final class ExpandedReferencesProcessor
    extends CndAbstractTokenProcessor<Token<CppTokenId>> {
        private CsmExpandedTokenProcessor expandedTokenProcessor;
        private ReferencesProcessor originalReferencesProcessor;
        private ReferencesProcessor macroReferencesProcessor;
        private boolean inMacro = false;

        public static ExpandedReferencesProcessor create(BaseDocument doc, CsmFile file, Set<CsmReferenceKind> kinds, FileReferencesContext fileReferncesContext) {
            boolean needAfterDereferenceUsages = kinds.contains(CsmReferenceKind.AFTER_DEREFERENCE_USAGE);
            boolean skipPreprocDirectives = !kinds.contains(CsmReferenceKind.IN_PREPROCESSOR_DIRECTIVE);
            List deadBlocks = !kinds.contains(CsmReferenceKind.IN_DEAD_BLOCK) ? CsmFileInfoQuery.getDefault().getUnusedCodeBlocks(file) : Collections.emptyList();
            ReferencesProcessor rp = new ReferencesProcessor(file, doc, skipPreprocDirectives, needAfterDereferenceUsages, deadBlocks, fileReferncesContext);
            return new ExpandedReferencesProcessor(rp, null);
        }

        public List<CsmReferenceContext> getReferences() {
            return this.originalReferencesProcessor.references;
        }

        private ExpandedReferencesProcessor(ReferencesProcessor rp, CsmExpandedTokenProcessor etp) {
            this.originalReferencesProcessor = rp;
            this.expandedTokenProcessor = etp;
        }

        public boolean token(Token<CppTokenId> token, int tokenOffset) {
            boolean res;
            if (this.expandedTokenProcessor == null) {
                return this.originalReferencesProcessor.token(token, tokenOffset);
            }
            if (this.expandedTokenProcessor.isMacro(token, tokenOffset)) {
                if (this.inMacro) {
                    this.originalReferencesProcessor.references.addAll(this.macroReferencesProcessor.references);
                }
                this.macroReferencesProcessor = new ReferencesProcessor(this.originalReferencesProcessor);
                this.originalReferencesProcessor.skipReferences(true);
                res = this.expandedTokenProcessor.token(token, tokenOffset);
                this.originalReferencesProcessor.skipReferences(false);
                this.inMacro = true;
            } else {
                res = this.expandedTokenProcessor.token(token, tokenOffset);
            }
            if (this.inMacro && !this.expandedTokenProcessor.isMacroExpansion()) {
                this.originalReferencesProcessor.references.addAll(this.macroReferencesProcessor.references);
                this.inMacro = false;
            }
            if (this.inMacro) {
                this.macroReferencesProcessor.token(token, tokenOffset);
            }
            return res;
        }
    }
}

