/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.applet;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AppletSupport {
    private static final SpecificationVersion JDK_15 = new SpecificationVersion("1.5");
    private static final String HTML_EXT = "html";
    private static final String CLASS_EXT = "class";
    private static final String POLICY_FILE_NAME = "applet";
    private static final String POLICY_FILE_EXT = "policy";
    public static Boolean unitTestingSupport_isApplet = null;

    private AppletSupport() {
    }

    public static boolean isApplet(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        if (unitTestingSupport_isApplet != null) {
            return unitTestingSupport_isApplet;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return false;
        }
        final boolean[] blArray = new boolean[]{false};
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    if (JavaSource.Phase.ELEMENTS_RESOLVED.compareTo((Enum)compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED)) <= 0) {
                        Elements elements = compilationController.getElements();
                        Trees trees = compilationController.getTrees();
                        Types types = compilationController.getTypes();
                        TypeElement typeElement = elements.getTypeElement("java.applet.Applet");
                        TypeElement typeElement2 = elements.getTypeElement("javax.swing.JApplet");
                        CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                        List<? extends Tree> list = compilationUnitTree.getTypeDecls();
                        for (Tree tree : list) {
                            Set<Modifier> set;
                            TypeElement typeElement3;
                            if (tree.getKind() != Tree.Kind.CLASS || (typeElement3 = (TypeElement)trees.getElement(TreePath.getPath(compilationUnitTree, tree))) == null || !(set = typeElement3.getModifiers()).contains((Object)Modifier.PUBLIC) || (typeElement == null || !types.isSubtype(typeElement3.asType(), typeElement.asType())) && (typeElement2 == null || !types.isSubtype(typeElement3.asType(), typeElement2.asType()))) continue;
                            blArray[0] = true;
                            break;
                        }
                    }
                }

                public void cancel() {
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return blArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileObject generateHtml(FileObject fileObject, FileObject fileObject2, FileObject fileObject3) throws IOException {
        FileObject fileObject4 = fileObject2.getFileObject(fileObject.getName(), HTML_EXT);
        if (fileObject4 == null) {
            fileObject4 = fileObject2.createData(fileObject.getName(), HTML_EXT);
        }
        FileLock fileLock = fileObject4.lock();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(fileObject4.getOutputStream(fileLock));
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            String string = FileUtil.getRelativePath((FileObject)classPath2.findOwnerRoot(fileObject), (FileObject)fileObject);
            string = string.substring(0, string.length() - 5);
            String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject3);
            if (string2 == null) {
                string2 = fileObject3.getURL().toString();
            }
            AppletSupport.fillInFile(printWriter, string + "." + CLASS_EXT, "codebase=\"" + string2 + "\"");
        }
        finally {
            fileLock.releaseLock();
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return fileObject4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject generateSecurityPolicy(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getFileObject(POLICY_FILE_NAME, POLICY_FILE_EXT);
        try {
            if (fileObject2 == null) {
                fileObject2 = fileObject.createData(POLICY_FILE_NAME, POLICY_FILE_EXT);
            }
            FileLock fileLock = fileObject2.lock();
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(fileObject2.getOutputStream(fileLock));
                AppletSupport.fillInPolicyFile(printWriter);
            }
            finally {
                fileLock.releaseLock();
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().log(1, "Problem when generating applet policy file: " + iOException);
        }
        return fileObject2;
    }

    public static URL generateHtmlFileURL(FileObject fileObject, FileObject fileObject2, FileObject fileObject3, String string) throws FileStateInvalidException {
        FileObject fileObject4 = null;
        Object var5_5 = null;
        if (fileObject == null || fileObject2 == null || fileObject3 == null) {
            return null;
        }
        try {
            fileObject4 = AppletSupport.generateHtml(fileObject, fileObject2, fileObject3);
            if (fileObject4 != null) {
                return AppletSupport.getHTMLPageURL(fileObject4, string);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static URL getHTMLPageURL(FileObject fileObject, String string) {
        assert (fileObject != null) : "htmlFile cannot be null";
        JavaPlatform javaPlatform = J2SEProjectUtil.getActivePlatform(string);
        boolean bl = javaPlatform != null && javaPlatform.getSpecification().getVersion().compareTo((Object)JDK_15) >= 0;
        URL uRL = null;
        if (bl) {
            File file = FileUtil.toFile((FileObject)fileObject);
            try {
                String string2 = file.getAbsolutePath();
                if (File.separatorChar != '/') {
                    string2 = string2.replace(File.separatorChar, '/');
                }
                uRL = new URL("file", null, string2);
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
        } else {
            try {
                uRL = fileObject.getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
        return uRL;
    }

    private static void fillInFile(PrintWriter printWriter, String string, String string2) {
        ResourceBundle resourceBundle = NbBundle.getBundle(AppletSupport.class);
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.print("   <TITLE>");
        printWriter.print(resourceBundle.getString("GEN_title"));
        printWriter.println("</TITLE>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY>\n");
        printWriter.print(resourceBundle.getString("GEN_warning"));
        printWriter.print("<H3><HR WIDTH=\"100%\">");
        printWriter.print(resourceBundle.getString("GEN_header"));
        printWriter.println("<HR WIDTH=\"100%\"></H3>\n");
        printWriter.println("<P>");
        if (string2 == null) {
            printWriter.print("<APPLET code=");
        } else {
            printWriter.print("<APPLET " + string2 + " code=");
        }
        printWriter.print("\"");
        printWriter.print(string);
        printWriter.print("\"");
        printWriter.println(" width=350 height=200></APPLET>");
        printWriter.println("</P>\n");
        printWriter.print("<HR WIDTH=\"100%\"><FONT SIZE=-1><I>");
        printWriter.print(resourceBundle.getString("GEN_copy"));
        printWriter.println("</I></FONT>");
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.flush();
    }

    private static void fillInPolicyFile(PrintWriter printWriter) {
        printWriter.println("grant {");
        printWriter.println("permission java.security.AllPermission;");
        printWriter.println("};");
        printWriter.flush();
    }
}

