/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.RubyTestingSettings;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.rubyproject.spi.RakeTaskCustomizer;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.RubyTestRunnerNodeFactory;
import org.netbeans.modules.ruby.testrunner.TestExecutionManager;
import org.netbeans.modules.ruby.testrunner.TestRunnerUtilities;
import org.netbeans.modules.ruby.testrunner.ui.RspecHandlerFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerLineConvertor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RspecRunner
implements TestRunner,
RakeTaskCustomizer {
    private static final String PLUGIN_SPEC_PATH = "vendor/plugins/rspec/bin/spec";
    private static final String SCRIPT_SPEC_PATH = "script/spec";
    private static final String SPEC_BIN = "spec";
    private static final TestRunner INSTANCE = new RspecRunner();
    private static final String SPEC_OPTS = "spec/spec.opts";
    private static final String NETBEANS_SPEC_OPTS_SUFFIX = "netbeans";
    private static final String NETBEANS_SPEC_OPTS = "spec/spec.opts.netbeans";
    public static final String RSPEC_MEDIATOR_SCRIPT = "nb_rspec_mediator.rb";
    private static final String SPEC_OPTS_WARN_PROP = "ruby.rspec.specopts.warn";

    public TestRunner getInstance() {
        return INSTANCE;
    }

    public boolean supports(TestRunner.TestType type) {
        return TestRunner.TestType.RSPEC == type;
    }

    private static boolean warnWhenUsingSpecOpts() {
        return Boolean.valueOf(System.getProperty(SPEC_OPTS_WARN_PROP, "true"));
    }

    public void runTest(FileObject testFile, boolean debug) {
        ArrayList<String> specFile = new ArrayList<String>();
        specFile.add(FileUtil.toFile((FileObject)testFile).getAbsolutePath());
        ArrayList<String> additionalArgs = new ArrayList<String>();
        additionalArgs.add(FileUtil.toFile((FileObject)testFile).getAbsolutePath());
        this.run(FileOwnerQuery.getOwner((FileObject)testFile), additionalArgs, testFile.getName(), debug);
    }

    public void runSingleTest(FileObject testFile, String testMethod, boolean debug) {
        ArrayList<String> additionalArgs = new ArrayList<String>();
        additionalArgs.add("--line");
        additionalArgs.add(testMethod);
        additionalArgs.add(FileUtil.toFile((FileObject)testFile).getAbsolutePath());
        this.run(FileOwnerQuery.getOwner((FileObject)testFile), additionalArgs, testFile.getName(), debug);
    }

    public void runAllTests(Project project, boolean debug) {
        RubyBaseProject baseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
        FileObject[] testDirs = baseProject.getTestSourceRootFiles();
        ArrayList<String> specs = new ArrayList<String>();
        for (FileObject dir : testDirs) {
            Enumeration children = dir.getChildren(true);
            while (children.hasMoreElements()) {
                FileObject each = (FileObject)children.nextElement();
                if (each.isFolder() || !"rb".equals(each.getExt()) || !each.getName().endsWith(SPEC_BIN)) continue;
                specs.add(FileUtil.toFile((FileObject)each).getAbsolutePath());
            }
        }
        this.run(project, specs, ProjectUtils.getInformation((Project)project).getDisplayName(), debug);
    }

    private void run(Project project, List<String> additionalArgs, String name, boolean debug) {
        LineConvertors.FileLocator locator = (LineConvertors.FileLocator)project.getLookup().lookup(LineConvertors.FileLocator.class);
        RubyPlatform platform = RubyPlatform.platformFor((Project)project);
        if (additionalArgs.isEmpty()) {
            TestSession empty = new TestSession(name, project, debug ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST, (TestRunnerNodeFactory)new RubyTestRunnerNodeFactory());
            Manager.getInstance().emptyTestRun(empty);
            return;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--require");
        arguments.add(RspecRunner.getMediatorScript().getAbsolutePath());
        arguments.add("--runner");
        arguments.add("NbRspecMediator");
        FileObject opts = RspecRunner.addSpecOpts(project, additionalArgs);
        arguments.addAll(additionalArgs);
        RubyExecutionDescriptor desc = null;
        Object charsetName = null;
        File spec = this.getSpec(project);
        if (spec == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RspecRunner.class, (String)"MSG_SpecNotFound"), 0));
            return;
        }
        desc = new RubyExecutionDescriptor(platform, name, FileUtil.toFile((FileObject)project.getProjectDirectory()), this.getSpec(project).getAbsolutePath());
        desc.additionalArgs(arguments.toArray(new String[arguments.size()]));
        TestRunnerUtilities.addProperties(desc, project);
        desc.addInitialArgs(RubyProjectUtil.getLoadPath((Project)project));
        desc.debug(debug);
        desc.allowInput();
        desc.fileLocator(locator);
        desc.addStandardRecognizers();
        RubyCoverageProvider coverageProvider = RubyCoverageProvider.get((Project)project);
        if (coverageProvider != null && coverageProvider.isEnabled()) {
            desc = coverageProvider.wrapWithCoverage(desc, false, null);
        }
        TestSession session = new TestSession(name, project, debug ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST, (TestRunnerNodeFactory)new RubyTestRunnerNodeFactory());
        RspecRunner.addSpecOptsWarningIfNeeded(session, opts);
        TestExecutionManager.getInstance().start(desc, new RspecHandlerFactory(), session);
    }

    private File getSpec(Project project) {
        FileObject pluginSpec;
        FileObject projectDir = project.getProjectDirectory();
        FileObject specScript = projectDir.getFileObject(SCRIPT_SPEC_PATH);
        if (specScript != null) {
            return FileUtil.toFile((FileObject)specScript);
        }
        if (projectDir != null && (pluginSpec = projectDir.getFileObject(PLUGIN_SPEC_PATH)) != null) {
            return FileUtil.toFile((FileObject)pluginSpec);
        }
        RubyPlatform platform = RubyPlatform.platformFor((Project)project);
        String spec = platform.findExecutable(SPEC_BIN);
        if (spec != null) {
            return new File(spec);
        }
        return null;
    }

    static File getMediatorScript() {
        File mediatorScript = InstalledFileLocator.getDefault().locate(RSPEC_MEDIATOR_SCRIPT, "org.netbeans.modules.ruby.testrunner", false);
        if (mediatorScript == null) {
            throw new IllegalStateException("Could not locate nb_rspec_mediator.rb");
        }
        return mediatorScript;
    }

    private static FileObject addSpecOpts(Project project, List<String> additionalArgs) {
        FileObject specOpts = RspecRunner.getSpecOpts(project);
        if (specOpts != null) {
            additionalArgs.add("--options");
            additionalArgs.add(FileUtil.toFile((FileObject)specOpts).getAbsolutePath());
        }
        return specOpts;
    }

    private static FileObject getSpecOpts(Project project) {
        FileObject projectDir = project.getProjectDirectory();
        FileObject specOpts = projectDir.getFileObject(NETBEANS_SPEC_OPTS);
        if (specOpts == null) {
            specOpts = projectDir.getFileObject(SPEC_OPTS);
        }
        return specOpts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSpecOptsContent(FileObject specOpts) {
        StringBuilder result = new StringBuilder();
        BufferedReader from = null;
        try {
            String line;
            from = new BufferedReader(new InputStreamReader(specOpts.getInputStream()));
            while ((line = from.readLine()) != null) {
                result.append(line);
                result.append(" ");
            }
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        finally {
            try {
                from.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return result.toString();
    }

    private static void addSpecOptsWarningIfNeeded(TestSession session, FileObject specOpts) {
        if (specOpts == null || !RspecRunner.warnWhenUsingSpecOpts()) {
            return;
        }
        if (!NETBEANS_SPEC_OPTS_SUFFIX.equals(specOpts.getExt())) {
            session.setStartingMsg(NbBundle.getMessage(RspecRunner.class, (String)"MSG_SpecOptsWarning", (Object)SPEC_OPTS, (Object)NETBEANS_SPEC_OPTS, (Object)SPEC_OPTS_WARN_PROP));
        }
    }

    public void customize(Project project, RakeTask task, RubyExecutionDescriptor taskDescriptor, boolean debug) {
        RubyPlatform platform;
        boolean useRunner;
        boolean bl = useRunner = RubyTestingSettings.getDefault().useRunner(TestRunner.TestType.RSPEC) && TestRunnerUtilities.useTestRunner(project, "spec.tasks", task, RSpecTaskEvaluator.INSTANCE);
        if (!useRunner) {
            return;
        }
        TestExecutionManager.getInstance().reset();
        String path = RspecRunner.getMediatorScript().getAbsolutePath();
        if (Utilities.isWindows() && (platform = RubyPlatform.platformFor((Project)project)) != null && platform.isJRuby()) {
            path = path.replace('\\', '/');
        }
        String options = "--require '" + path + "' --runner NbRspecMediator";
        FileObject specOpts = RspecRunner.getSpecOpts(project);
        if (specOpts != null) {
            options = options + " " + this.getSpecOptsContent(specOpts);
        }
        task.addTaskParameters(new String[]{"SPEC_OPTS=" + options});
        TestSession session = new TestSession(task.getDisplayName(), project, debug ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST, (TestRunnerNodeFactory)new RubyTestRunnerNodeFactory());
        RspecRunner.addSpecOptsWarningIfNeeded(session, specOpts);
        Manager manager = Manager.getInstance();
        TestRunnerLineConvertor convertor = new TestRunnerLineConvertor(manager, session, new RspecHandlerFactory());
        TestRunnerUtilities.setUpConvertors(session, taskDescriptor, manager, convertor);
        TestRunnerUtilities.addProperties(taskDescriptor, project);
        TestExecutionManager.getInstance().init(taskDescriptor);
        session.setRerunHandler((RerunHandler)TestExecutionManager.getInstance());
    }

    private static class RSpecTaskEvaluator
    implements TestRunnerUtilities.DefaultTaskEvaluator {
        static final RSpecTaskEvaluator INSTANCE = new RSpecTaskEvaluator();

        private RSpecTaskEvaluator() {
        }

        @Override
        public boolean isDefault(RakeTask task) {
            return RspecRunner.SPEC_BIN.equals(task.getTask());
        }
    }
}

