/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.debugcomponent.ClassDebugInfo;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcPackage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class DebugComponent
extends Component {
    private int package_index;
    private JcPackage jc_package;
    ClassDebugInfo[] classes;
    Vector<String> utf8_strings;

    public DebugComponent(JcPackage jcPackage) {
        super(12, "debug");
        this.jc_package = jcPackage;
        this.build();
    }

    private void build() {
        this.utf8_strings = new Vector(20, 10);
        this.package_index = this.addString(this.jc_package.getPackageName());
        JcClass[] jcClassArray = this.jc_package.getClasses();
        this.classes = new ClassDebugInfo[jcClassArray.length];
        for (int i = 0; i < jcClassArray.length; ++i) {
            this.classes[i] = jcClassArray[i].isAnnotation() ? null : new ClassDebugInfo(jcClassArray[i], this);
        }
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.size());
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            int n;
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeShort(this.utf8_strings.size());
            for (n = 0; n < this.utf8_strings.size(); ++n) {
                ClassDebugInfo[] classDebugInfoArray = this.utf8_strings.elementAt(n);
                byte[] byArray2 = classDebugInfoArray.getBytes("UTF8");
                dataOutputStream.writeShort(byArray2.length);
                dataOutputStream.write(byArray2, 0, byArray2.length);
            }
            dataOutputStream.writeShort(this.package_index);
            n = 0;
            for (ClassDebugInfo classDebugInfo : this.classes) {
                if (classDebugInfo == null) continue;
                ++n;
            }
            dataOutputStream.writeShort(n);
            for (ClassDebugInfo classDebugInfo : this.classes) {
                if (classDebugInfo == null) continue;
                classDebugInfo.toBinary(dataOutputStream);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        assert (this.size() == byteArrayOutputStream.size()) : "size() != bos.size()";
        return byteArrayOutputStream.toByteArray();
    }

    public int addString(String string) {
        for (int i = 0; i < this.utf8_strings.size(); ++i) {
            String string2 = this.utf8_strings.elementAt(i);
            if (!string2.equals(string)) continue;
            return i;
        }
        this.utf8_strings.addElement(string);
        return this.utf8_strings.size() - 1;
    }

    @Override
    public int dataSize() {
        int n = 0;
        for (ClassDebugInfo classDebugInfo : this.classes) {
            if (classDebugInfo == null) continue;
            n += classDebugInfo.getSize();
        }
        for (int i = 0; i < this.utf8_strings.size(); ++i) {
            String string = this.utf8_strings.elementAt(i);
            try {
                byte[] byArray = string.getBytes("UTF8");
                n = n + 2 + byArray.length;
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ConverterInternalError(unsupportedEncodingException.getMessage());
            }
        }
        return n + 6;
    }
}

