/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.TermStream;

public class LineDiscipline
extends TermStream {
    private static final char[] bs_sequence = new char[]{'\b', ' ', '\b'};
    private StringBuffer line = new StringBuffer();
    private int send_buf_sz = 2;
    private char[] send_buf = new char[this.send_buf_sz];
    private int put_capacity = 16;
    private int put_length = 0;
    private char[] put_buf = new char[this.put_capacity];

    char[] send_buf(int n) {
        if (n >= this.send_buf_sz) {
            this.send_buf_sz = n + 1;
            this.send_buf = new char[this.send_buf_sz];
        }
        return this.send_buf;
    }

    @Override
    public void flush() {
        this.toDTE.flush();
    }

    @Override
    public void putChar(char c) {
        this.put_length = 0;
        this.processChar(c);
        this.toDTE.putChars(this.put_buf, 0, this.put_length);
    }

    @Override
    public void putChars(char[] buf, int offset, int count) {
        this.put_length = 0;
        for (int bx = 0; bx < count; ++bx) {
            this.processChar(buf[offset + bx]);
        }
        this.toDTE.putChars(this.put_buf, 0, this.put_length);
    }

    private void processChar(char c) {
        this.appendChar(c);
        if (c == '\n') {
            this.appendChar('\r');
        }
    }

    private void appendChar(char c) {
        if (this.put_length >= this.put_capacity) {
            int new_capacity = this.put_capacity * 2;
            if (new_capacity < 0) {
                new_capacity = Integer.MAX_VALUE;
            }
            char[] new_buf = new char[new_capacity];
            System.arraycopy(this.put_buf, 0, new_buf, 0, this.put_length);
            this.put_buf = new_buf;
            this.put_capacity = new_capacity;
        }
        this.put_buf[this.put_length++] = c;
    }

    @Override
    public void sendChar(char c) {
        if (c == '\r') {
            this.toDTE.putChar(c);
            this.toDTE.flush();
            c = (char)10;
            this.toDTE.putChar(c);
            this.toDTE.flush();
            this.line.append(c);
            int nchars = this.line.length();
            char[] tmp = this.send_buf(nchars);
            this.line.getChars(0, nchars, tmp, 0);
            this.toDCE.sendChars(tmp, 0, nchars);
            this.line.delete(0, 99999);
        } else if (c == '\n') {
            this.toDTE.putChar('\r');
            this.toDTE.flush();
            this.toDTE.putChar(c);
            this.toDTE.flush();
            this.line.append(c);
            int nchars = this.line.length();
            char[] tmp = this.send_buf(nchars);
            this.line.getChars(0, nchars, tmp, 0);
            this.toDCE.sendChars(tmp, 0, nchars);
            this.line.delete(0, 99999);
        } else if (c == '\b') {
            int nchars = this.line.length();
            if (nchars == 0) {
                return;
            }
            char erased_char = ' ';
            try {
                erased_char = this.line.charAt(nchars - 1);
            }
            catch (Exception x) {
                return;
            }
            int cwidth = this.getTerm().charWidth(erased_char);
            this.line.delete(nchars - 1, nchars);
            while (--cwidth > 0) {
                this.line.append(' ');
            }
            this.toDTE.putChars(bs_sequence, 0, 3);
            this.toDTE.flush();
        } else {
            this.toDTE.putChar(c);
            this.toDTE.flush();
            this.line.append(c);
        }
    }

    @Override
    public void sendChars(char[] c, int offset, int count) {
        for (int cx = 0; cx < count; ++cx) {
            this.sendChar(c[offset + cx]);
        }
    }
}

