/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.simpleunit.utils;

import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;

public class CodeGenerationUtils {
    private CodeGenerationUtils() {
    }

    public static String generateFunctionDeclaration(CsmFunction fun) {
        String returnType = ((Object)fun.getReturnType().getText()).toString();
        StringBuilder functionDecl = new StringBuilder("");
        functionDecl.append(returnType).append(" ").append(fun.getQualifiedName()).append("(");
        Collection params = fun.getParameters();
        int i = 0;
        for (CsmParameter param : params) {
            String paramName = ((Object)param.getName()).toString();
            String paramType = ((Object)param.getType().getText()).toString();
            if (i != 0) {
                functionDecl.append(", ");
            }
            functionDecl.append(paramType).append(paramName != null && !paramName.isEmpty() ? " " + paramName : "");
            ++i;
        }
        functionDecl.append(");");
        return functionDecl.toString();
    }

    public static String generateParameterDeclaration(CsmParameter param, int paramNumber) {
        String paramName = ((Object)param.getName()).toString();
        String paramType = ((Object)param.getType().getText()).toString();
        StringBuilder paramDecl = new StringBuilder("");
        paramDecl.append(paramType).append(" ").append(paramName != null && !paramName.isEmpty() ? paramName : "p" + paramNumber).append(";");
        return paramDecl.toString();
    }

    public static String generateFunctionCall(CsmFunction fun) {
        StringBuilder functionCall = new StringBuilder("");
        String returnType = ((Object)fun.getReturnType().getText()).toString();
        if (CsmKindUtilities.isMethod((CsmObject)fun)) {
            CsmMethod method = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)fun);
            CsmClass cls = method.getContainingClass();
            if (cls != null) {
                String clsName = ((Object)cls.getName()).toString();
                String clsVarName = Character.toLowerCase(clsName.charAt(0)) + clsName.substring(1);
                clsVarName = clsVarName.equals(clsName) ? '_' + clsVarName : clsVarName;
                functionCall.append("    ").append(cls.getQualifiedName()).append(" ").append(clsVarName);
                if (!CsmKindUtilities.isConstructor((CsmObject)method)) {
                    functionCall.append(";\n");
                    functionCall.append("    ").append(!"void".equals(returnType) ? returnType + " result = " : "").append(clsVarName).append(".").append(method.getName());
                }
            }
        } else {
            functionCall.append("    ").append(!"void".equals(returnType) ? returnType + " result = " : "").append(fun.getName());
        }
        int i = 0;
        functionCall.append("(");
        Collection params = fun.getParameters();
        for (CsmParameter param : params) {
            String paramName;
            if (i != 0) {
                functionCall.append(", ");
            }
            functionCall.append((paramName = ((Object)param.getName()).toString()) != null && !paramName.isEmpty() ? paramName : "p" + i);
            ++i;
        }
        functionCall.append(");\n");
        return functionCall.toString();
    }
}

