/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.properties.GroupValue;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.PropertySupport;

public abstract class DesignPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor,
InplaceEditor.Factory {
    private List<String> propertyNames;
    private WeakReference<DesignComponent> component;
    private Object tempValue;
    private PropertyValue propertyValue;
    private PropertySupport propertySupport;
    private InplaceEditor inplaceEditor;
    private String propertyDisplayName;
    private String customEditorTitle;

    public void cleanUp(DesignComponent component) {
        this.propertyNames = null;
        this.tempValue = null;
        this.propertyValue = null;
        this.propertySupport = null;
        this.inplaceEditor = null;
    }

    public Boolean canEditAsText() {
        return null;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean isDefaultValue() {
        if (this.propertyNames == null || this.propertyNames.isEmpty()) {
            return true;
        }
        final boolean[] isDefaultValue = new boolean[]{true};
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                for (String propertyName : DesignPropertyEditor.this.propertyNames) {
                    if (((DesignComponent)DesignPropertyEditor.this.component.get()).isDefaultValue(propertyName)) continue;
                    isDefaultValue[0] = false;
                    break;
                }
            }
        });
        return isDefaultValue[0];
    }

    @Override
    public boolean supportsCustomEditor() {
        Collection components = ActiveDocumentSupport.getDefault().getActiveComponents();
        return components != null && components.size() == 1;
    }

    public boolean supportsDefaultValue() {
        if (this.propertyNames == null || this.propertyNames.isEmpty()) {
            return false;
        }
        final boolean[] supportsDefaultValue = new boolean[]{true};
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                for (String propertyName : DesignPropertyEditor.this.propertyNames) {
                    PropertyDescriptor propertyDescriptor = ((DesignComponent)DesignPropertyEditor.this.component.get()).getComponentDescriptor().getPropertyDescriptor(propertyName);
                    if (propertyDescriptor.getDefaultValue().getKind() != PropertyValue.Kind.NULL || propertyDescriptor.isAllowNull()) continue;
                    supportsDefaultValue[0] = false;
                    break;
                }
            }
        });
        return supportsDefaultValue[0];
    }

    public Object getDefaultValue() {
        if (this.propertyNames == null || this.propertyNames.isEmpty()) {
            throw new IllegalStateException("Unable to obtain default value for this property without property name");
        }
        if (!(this.tempValue instanceof GroupValue)) {
            return this.readDefaultPropertyValue(this.propertyNames.iterator().next());
        }
        GroupValue newAdvancedValue = (GroupValue)this.tempValue;
        for (String propertyName : newAdvancedValue.getPropertyNames()) {
            ((GroupValue)this.tempValue).putValue(propertyName, this.readDefaultPropertyValue(propertyName));
        }
        return newAdvancedValue;
    }

    public void attachEnv(PropertyEnv env) {
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                DesignPropertyEditor.this.customEditorOKButtonPressed();
            }
        });
    }

    public final void resolve(DesignComponent component, List<String> propertyNames, Object value, PropertySupport propertySupport, String propertyDisplayName) {
        this.component = new WeakReference<DesignComponent>(component);
        this.propertyNames = propertyNames;
        this.tempValue = value;
        super.setValue(value);
        this.propertySupport = propertySupport;
        this.propertyDisplayName = propertyDisplayName;
    }

    public final void resolveInplaceEditor(InplaceEditor inplaceEditor) {
        this.inplaceEditor = inplaceEditor;
    }

    public InplaceEditor getInplaceEditor() {
        return this.inplaceEditor;
    }

    public String getCustomEditorTitle() {
        if (this.component == null) {
            return null;
        }
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DesignDocument document = ((DesignComponent)DesignPropertyEditor.this.component.get()).getDocument();
                if (((DesignComponent)DesignPropertyEditor.this.component.get()).getParentComponent() == null && document.getRootComponent() != DesignPropertyEditor.this.component.get()) {
                    DesignPropertyEditor.this.customEditorTitle = null;
                    return;
                }
                DesignPropertyEditor.this.customEditorTitle = InfoPresenter.getDisplayName((DesignComponent)((DesignComponent)DesignPropertyEditor.this.component.get())) + " - " + DesignPropertyEditor.this.propertyDisplayName;
            }
        });
        return this.customEditorTitle;
    }

    public void init(DesignComponent component) {
    }

    public void notifyDesignChanged(DesignEvent event) {
    }

    public boolean isExecuteInsideWriteTransactionUsed() {
        return true;
    }

    public boolean executeInsideWriteTransaction() {
        return true;
    }

    public void customEditorOKButtonPressed() {
    }

    public boolean isResetToDefaultAutomatically() {
        return true;
    }

    public void customEditorResetToDefaultButtonPressed() {
    }

    public final void invokeSaveToModel() {
        try {
            this.propertySupport.setValue(this.getValue());
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    private PropertyValue readDefaultPropertyValue(final String propertyName) {
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DesignPropertyEditor.this.propertyValue = ((DesignComponent)DesignPropertyEditor.this.component.get()).getComponentDescriptor().getPropertyDescriptor(propertyName).getDefaultValue();
            }
        });
        return this.propertyValue;
    }

    public String getPropertyDisplayName() {
        return this.propertyDisplayName;
    }

    public List<String> getPropertyNames() {
        return this.propertyNames;
    }
}

