/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.templates;

import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.refactoring.WebXMLRefactoringSupport;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.modules.javacard.templates.ErrorPanel;
import org.netbeans.modules.javacard.templates.ServletDeploymentWizardPanel;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;

public final class ServletWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private boolean needsToCancel;

    private WizardDescriptor.Panel createJavaSourcePanel(WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        assert (groups != null) : "Cannot return null from Sources.getSourceGroups: " + sources;
        if (groups.length == 0) {
            groups = sources.getSourceGroups("generic");
            return Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])groups);
        }
        return JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])groups);
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        if (this.needsToCancel) {
            return new WizardDescriptor.Panel[]{new ErrorPanel("Web Applications")};
        }
        if (this.panels == null) {
            WizardDescriptor.Panel javaSourcePanel = this.createJavaSourcePanel(this.wizard);
            ServletDeploymentWizardPanel servletPanel = new ServletDeploymentWizardPanel(this.wizard);
            this.panels = new WizardDescriptor.Panel[]{javaSourcePanel, servletPanel};
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        FileObject fo = Templates.getTemplate((WizardDescriptor)this.wizard);
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wizard);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        FileObject createdFile = null;
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, targetName);
        createdFile = dobj.getPrimaryFile();
        this.addInfoToWebDescriptor(createdFile);
        return Collections.singleton(createdFile);
    }

    private void addInfoToWebDescriptor(final FileObject createdFile) {
        Project p = Templates.getProject((WizardDescriptor)this.wizard);
        final JCProject jcProject = (JCProject)p.getLookup().lookup(JCProject.class);
        if (jcProject == null || jcProject.kind() != ProjectKind.WEB) {
            return;
        }
        final String servletName = (String)this.wizard.getProperty("servletName");
        if (servletName != null) {
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        String urlPattern = (String)ServletWizardIterator.this.wizard.getProperty("urlPattern");
                        ClassPathProvider cpProvider = (ClassPathProvider)jcProject.getLookup().lookup(ClassPathProvider.class);
                        String className = createdFile.getName();
                        if (cpProvider != null) {
                            className = cpProvider.findClassPath(createdFile, "classpath/source").getResourceName(createdFile, '.', false);
                        }
                        FileObject webObj = jcProject.getProjectDirectory().getFileObject("WEB-INF/web.xml");
                        WebXMLRefactoringSupport web = WebXMLRefactoringSupport.fromFile(FileUtil.toFile((FileObject)webObj));
                        web.addServletInfo(servletName, className, urlPattern);
                        OutputStream out = webObj.getOutputStream();
                        try {
                            XMLUtil.write((Document)web.getDocument(), (OutputStream)out, (String)"UTF-8");
                        }
                        finally {
                            out.close();
                        }
                    }
                    catch (FileAlreadyLockedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        Project p = Templates.getProject((WizardDescriptor)wizard);
        if (p.getLookup().lookup(ProjectKind.class) != ProjectKind.WEB) {
            this.needsToCancel = true;
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (this.index == 0) {
            this.panels[0].storeSettings((Object)this.wizard);
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] beforeSteps = null;
        Object prop = this.wizard.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        if (beforeSteps == null) {
            beforeSteps = new String[]{};
        }
        String[] res = new String[beforeSteps.length - 1 + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeSteps.length - 1 ? beforeSteps[i] : this.panels[i - beforeSteps.length + 1].getComponent().getName();
        }
        return res;
    }
}

