/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.spi.commands;

import java.util.Arrays;
import org.netbeans.modules.php.api.util.StringUtils;

public abstract class FrameworkCommand
implements Comparable<FrameworkCommand> {
    private final String[] commands;
    private final String description;
    private final String displayName;
    private volatile String help;

    protected FrameworkCommand(String command, String description, String displayName) {
        this(new String[]{command}, description, displayName);
    }

    protected FrameworkCommand(String[] commands, String description, String displayName) {
        this.commands = commands;
        this.description = description;
        this.displayName = displayName;
    }

    protected abstract String getHelpInternal();

    public String getPreview() {
        return StringUtils.implode(Arrays.asList(this.commands), " ");
    }

    public String[] getCommands() {
        String[] copy = new String[this.commands.length];
        System.arraycopy(this.commands, 0, copy, 0, this.commands.length);
        return copy;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getHelp() {
        if (this.help == null) {
            this.help = this.getHelpInternal();
        }
        return this.help;
    }

    public boolean hasHelp() {
        return this.help != null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FrameworkCommand other = (FrameworkCommand)obj;
        return Arrays.deepEquals(this.commands, other.commands);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Arrays.deepHashCode(this.commands);
        return hash;
    }

    @Override
    public int compareTo(FrameworkCommand o) {
        if (this.commands.length == 0 || o.commands.length == 0) {
            assert (this.displayName != null) : "displayName not null";
            assert (o.getDisplayName() != null) : "other displayName not null";
            return this.displayName.compareTo(o.getDisplayName());
        }
        return this.getPreview().compareTo(o.getPreview());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(this.getClass().getName());
        buffer.append(" [displayName: ");
        buffer.append(this.displayName);
        buffer.append(", commands: ");
        buffer.append(this.commands);
        buffer.append(", description: ");
        buffer.append(this.description);
        buffer.append(", help: ");
        buffer.append(this.help);
        buffer.append("]");
        return buffer.toString();
    }
}

