/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class SmallSwatchChooserPanel
extends AbstractColorChooserPanel {
    SwatchPanel swatchPanel;
    MouseListener mainSwatchListener;

    @Override
    public String getDisplayName() {
        return UIManager.getString("ColorChooser.swatchesNameText");
    }

    @Override
    public int getMnemonic() {
        return 0;
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return 0;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    protected void buildChooser() {
        JPanel superHolder = new JPanel(new BorderLayout());
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.getAccessibleContext().setAccessibleName(this.getDisplayName());
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        JPanel mainHolder = new JPanel(new BorderLayout());
        CompoundBorder border = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        mainHolder.setBorder(border);
        mainHolder.add((Component)this.swatchPanel, "Center");
        superHolder.add((Component)mainHolder, "Center");
        this.add(superHolder);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.swatchPanel = null;
        this.mainSwatchListener = null;
        this.removeAll();
    }

    @Override
    public void updateChooser() {
    }

    class MainSwatchPanel
    extends SwatchPanel {
        static final int width = 5;
        static final int height = 3;

        MainSwatchPanel() {
        }

        @Override
        protected void initValues() {
            this.swatchSize = UIManager.getDimension("ColorChooser.swatchesSwatchSize");
            this.numSwatches = new Dimension(5, 3);
            this.gap = new Dimension(1, 1);
        }

        @Override
        protected void initColors() {
            int[] rawValues = this.initRawValues();
            int numColors = rawValues.length / 3;
            this.colors = new Color[numColors];
            for (int i = 0; i < numColors; ++i) {
                this.colors[i] = new Color(rawValues[i * 3], rawValues[i * 3 + 1], rawValues[i * 3 + 2]);
            }
        }

        private int[] initRawValues() {
            int[] rawValues = new int[]{255, 255, 255, 204, 255, 255, 204, 204, 255, 255, 204, 204, 204, 255, 204, 204, 204, 204, 153, 153, 255, 255, 153, 153, 255, 153, 153, 153, 255, 153, 102, 102, 255, 255, 102, 204, 255, 255, 102, 102, 255, 102, 102, 255, 204};
            return rawValues;
        }
    }

    class SwatchPanel
    extends JPanel {
        protected Color[] colors;
        protected Dimension swatchSize;
        protected Dimension numSwatches;
        protected Dimension gap;

        public SwatchPanel() {
            this.initValues();
            this.initColors();
            this.setToolTipText("");
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setRequestFocusEnabled(false);
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        protected void initValues() {
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int row = 0; row < this.numSwatches.height; ++row) {
                for (int column = 0; column < this.numSwatches.width; ++column) {
                    g.setColor(this.getColorForCell(column, row));
                    int x = column * (this.swatchSize.width + this.gap.width);
                    int y = row * (this.swatchSize.height + this.gap.height);
                    g.fillRect(x, y, this.swatchSize.width, this.swatchSize.height);
                    g.setColor(Color.black);
                    g.drawLine(x + this.swatchSize.width - 1, y, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                    g.drawLine(x, y + this.swatchSize.height - 1, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                }
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int x = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
            int y = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
            return new Dimension(x, y);
        }

        protected void initColors() {
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Color color = this.getColorForLocation(e.getX(), e.getY());
            return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
        }

        public Color getColorForLocation(int x, int y) {
            int column = x / (this.swatchSize.width + this.gap.width);
            int row = y / (this.swatchSize.height + this.gap.height);
            return this.getColorForCell(column, row);
        }

        private Color getColorForCell(int column, int row) {
            return this.colors[row * this.numSwatches.width + column];
        }
    }

    class MainSwatchListener
    extends MouseAdapter {
        MainSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = SmallSwatchChooserPanel.this.swatchPanel.getColorForLocation(e.getX(), e.getY());
            SmallSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

