/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.wizard.ConfigurationsSelectionPanelGUI;
import org.netbeans.spi.mobility.cfgfactory.ProjectConfigurationFactory;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class NewConfigurationPanel
extends JPanel
implements DocumentListener,
PropertyChangeListener,
VetoableChangeListener,
ExplorerManager.Provider {
    private DialogDescriptor dialogDescriptor;
    private final Collection<String> allNames;
    private final ExplorerManager manager = new ExplorerManager();
    private final BeanTreeView treeView;
    private String oldName;
    public static final Image CLOSED_ICON = NewConfigurationPanel.findIcon("Nb.Explorer.Folder.icon", "Tree.closedIcon");
    public static final Image OPENED_ICON = NewConfigurationPanel.findIcon("Nb.Explorer.Folder.openedIcon", "Tree.openIcon");
    private ErrorPanel errorPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JTextField jTextFieldName;

    public NewConfigurationPanel(Collection<String> allNames) {
        this.allNames = allNames;
        this.initComponents();
        this.initAccessibility();
        this.treeView = new BeanTreeView();
        this.jLabel2.setLabelFor((Component)this.treeView);
        this.treeView.setPopupAllowed(false);
        this.treeView.setRootVisible(false);
        this.treeView.setDefaultActionAllowed(false);
        this.treeView.setSelectionMode(1);
        this.jPanel1.add((Component)this.treeView, "Center");
        AbstractNode root = new AbstractNode((Children)new Children.Keys<ProjectConfigurationFactory>(){
            {
                this.setKeys(Lookup.getDefault().lookupAll(ProjectConfigurationFactory.class));
            }

            protected Node[] createNodes(ProjectConfigurationFactory key) {
                return new Node[]{key instanceof ProjectConfigurationFactory.ConfigurationTemplateDescriptor ? new TemplateNode((ProjectConfigurationFactory.ConfigurationTemplateDescriptor)key) : new CategoryNode(key.getRootCategory())};
            }
        });
        root.setName(NbBundle.getMessage(ConfigurationsSelectionPanelGUI.class, (String)"LBL_CfgSelectionPanel_Templates"));
        this.manager.setRootContext((Node)root);
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        try {
            this.manager.setSelectedNodes(new Node[]{(Node)root.getChildren().nodes().nextElement()});
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private static Image findIcon(String key1, String key2) {
        Image i = NewConfigurationPanel.icon2image(key1);
        return i == null ? NewConfigurationPanel.icon2image(key2) : i;
    }

    private static Image icon2image(String key) {
        Object obj = UIManager.get(key);
        if (obj instanceof Image) {
            return (Image)obj;
        }
        if (obj instanceof Icon) {
            Icon icon = (Icon)obj;
            return ImageUtilities.icon2Image((Icon)icon);
        }
        return null;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public String getName() {
        return this.jTextFieldName == null ? "" : this.jTextFieldName.getText();
    }

    public ProjectConfigurationFactory.ConfigurationTemplateDescriptor getTemplate() {
        Node[] nodes = this.manager.getSelectedNodes();
        if (nodes.length != 1) {
            return null;
        }
        return (ProjectConfigurationFactory.ConfigurationTemplateDescriptor)nodes[0].getLookup().lookup(ProjectConfigurationFactory.ConfigurationTemplateDescriptor.class);
    }

    public void setDialogDescriptor(DialogDescriptor dd) {
        assert (this.dialogDescriptor == null) : "Set the dialog descriptor only once!";
        this.dialogDescriptor = dd;
        dd.setHelpCtx(new HelpCtx(NewConfigurationPanel.class));
        this.jTextFieldName.getDocument().addDocumentListener(this);
        this.changedUpdate(null);
        this.oldName = "";
    }

    public boolean isStateValid() {
        String name = this.jTextFieldName.getText();
        if (J2MEProjectUtils.ILEGAL_CONFIGURATION_NAMES.contains(name)) {
            this.errorPanel.setErrorBundleMessage("ERR_AddCfg_ReservedWord");
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)name)) {
            this.errorPanel.setErrorBundleMessage("ERR_AddCfg_MustBeJavaIdentifier");
            return false;
        }
        if (this.allNames.contains(name)) {
            this.errorPanel.setErrorBundleMessage("ERR_AddCfg_NameExists");
            return false;
        }
        if (this.getTemplate() == null) {
            this.errorPanel.setErrorBundleMessage("ERR_AddCfg_SelectTmp");
            return false;
        }
        this.errorPanel.setErrorBundleMessage(null);
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.dialogDescriptor != null) {
            this.dialogDescriptor.setValid(this.isStateValid());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.changedUpdate(null);
        String s = this.jTextFieldName.getText();
        if (s.length() == 0 || s.equals(this.oldName)) {
            Node[] nodes = this.manager.getSelectedNodes();
            if (nodes.length != 1) {
                return;
            }
            ProjectConfigurationFactory.ConfigurationTemplateDescriptor desc = (ProjectConfigurationFactory.ConfigurationTemplateDescriptor)nodes[0].getLookup().lookup(ProjectConfigurationFactory.ConfigurationTemplateDescriptor.class);
            if (desc == null) {
                return;
            }
            this.jTextFieldName.setText(desc.getCfgName());
            this.oldName = this.jTextFieldName.getText();
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getNewValue() instanceof Node[]) {
            Node[] n = (Node[])evt.getNewValue();
            if (n.length > 1) {
                throw new PropertyVetoException("Mutiselection is not alloved", evt);
            }
            if (n.length == 0) {
                return;
            }
            if (n[0].getLookup().lookup(ProjectConfigurationFactory.ConfigurationTemplateDescriptor.class) == null) {
                throw new PropertyVetoException("Only configuration templates selection allowed", evt);
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.jTextFieldName.requestFocus();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.errorPanel = new ErrorPanel();
        this.setMinimumSize(new Dimension(450, 200));
        this.setPreferredSize(new Dimension(480, 350));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(NewConfigurationPanel.class, (String)"LBL_NewConfigPanel_ConfigTemplate"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 5, 12);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel1.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setLabelFor(this.jTextFieldName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(NewConfigurationPanel.class, (String)"LBL_NewConfigPanel_ConfigurationName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 12);
        this.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jTextFieldName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConfigurationPanel.class, (String)"ACSD_NewCfg_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.errorPanel, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConfigurationPanel.class, (String)"ACSN_NewConfigPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConfigurationPanel.class, (String)"ACSD_NewConfigPanel"));
    }

    private class TemplateNode
    extends AbstractNode {
        private ProjectConfigurationFactory.ConfigurationTemplateDescriptor cfgTmp;

        public TemplateNode(ProjectConfigurationFactory.ConfigurationTemplateDescriptor cfgTmp) {
            super(Children.LEAF, Lookups.singleton((Object)cfgTmp));
            this.cfgTmp = cfgTmp;
            this.setDisplayName(cfgTmp.getDisplayName().equals(cfgTmp.getCfgName()) || cfgTmp.getCfgName().length() == 0 ? cfgTmp.getDisplayName() : NbBundle.getMessage(ConfigurationsSelectionPanelGUI.class, (String)"LBL_CfgSlePanel_TemplateNodePattern", (Object)cfgTmp.getDisplayName(), (Object)cfgTmp.getCfgName()));
        }
    }

    private class CategoryNode
    extends AbstractNode {
        public CategoryNode(final ProjectConfigurationFactory.CategoryDescriptor cat) {
            super((Children)new Children.Keys<ProjectConfigurationFactory.Descriptor>(){
                {
                    this.setKeys(cat.getChildren());
                }

                protected Node[] createNodes(ProjectConfigurationFactory.Descriptor key) {
                    Node[] nodeArray;
                    AbstractNode n;
                    AbstractNode abstractNode = key instanceof ProjectConfigurationFactory.CategoryDescriptor ? new CategoryNode((ProjectConfigurationFactory.CategoryDescriptor)key) : (n = key instanceof ProjectConfigurationFactory.ConfigurationTemplateDescriptor ? new TemplateNode((ProjectConfigurationFactory.ConfigurationTemplateDescriptor)key) : null);
                    if (n == null) {
                        nodeArray = null;
                    } else {
                        Node[] nodeArray2 = new Node[1];
                        nodeArray = nodeArray2;
                        nodeArray2[0] = n;
                    }
                    return nodeArray;
                }
            });
            this.setDisplayName(cat.getDisplayName());
        }

        public Image getIcon(int type) {
            return CLOSED_ICON == null ? super.getIcon(type) : CLOSED_ICON;
        }

        public Image getOpenedIcon(int type) {
            return OPENED_ICON == null ? super.getOpenedIcon(type) : OPENED_ICON;
        }
    }
}

