/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.indicators.ClockIndicatorConfiguration;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.openide.util.Lookup;

public class ClockIndicator
extends Indicator<ClockIndicatorConfiguration> {
    private static final int SECOND_IN_MILLISECONDS = 1000;
    private ClockPanel panel = new ClockPanel();
    private long currentTime;

    public ClockIndicator(ClockIndicatorConfiguration configuration) {
        super((IndicatorConfiguration)configuration);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void updated(List<DataRow> data) {
        if (data.isEmpty()) {
            return;
        }
        DataRow lastRow = data.get(data.size() - 1);
        this.currentTime = lastRow.getLongValue(this.getMetadataColumnName(0));
        this.panel.update();
    }

    protected void tick() {
    }

    protected void repairNeeded(boolean needed) {
    }

    public void reset() {
    }

    public void setIndicatorActionsProviderContext(Lookup context) {
    }

    private class ClockPanel
    extends JPanel {
        private JLabel timeLabel = new JLabel("00:00:00");

        public ClockPanel() {
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)this.timeLabel, "Center");
        }

        private void update() {
            int seconds = (int)ClockIndicator.this.currentTime / 1000;
            int hours = seconds / 3600;
            int minutes = (seconds - hours * 60 * 60) / 60;
            int real_seconds = seconds - hours * 60 * 60 - minutes * 60;
            String timerStr = (hours < 10 ? "0" : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes + ":" + (real_seconds < 10 ? "0" : "") + real_seconds;
            this.timeLabel.setText(timerStr);
        }
    }
}

