/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.weaving;

import oracle.toplink.essentials.mappings.OneToOneMapping;

public class AttributeDetails {
    protected String attributeName;
    protected String referenceClass;
    protected boolean weaveValueHolders = false;
    protected OneToOneMapping mapping = null;
    protected String getterMethodName = null;
    protected String setterMethodName = null;
    protected boolean collectionMapping = false;
    protected boolean isMappedWithAttributeAccess = false;
    protected boolean attributeOnSuperClass = false;

    public AttributeDetails(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public OneToOneMapping getMapping() {
        return this.mapping;
    }

    public String getGetterMethodName() {
        return this.getterMethodName;
    }

    public String getSetterMethodName() {
        return this.setterMethodName;
    }

    public String getReferenceClass() {
        return this.referenceClass;
    }

    public void setAttributeOnSuperClass(boolean onSuperClass) {
        this.attributeOnSuperClass = onSuperClass;
    }

    public boolean isAttributeOnSuperClass() {
        return this.attributeOnSuperClass;
    }

    public boolean weaveValueHolders() {
        return this.weaveValueHolders;
    }

    public void weaveVH(boolean weaveValueHolders, OneToOneMapping mapping) {
        this.weaveValueHolders = weaveValueHolders;
        this.mapping = mapping;
        this.getterMethodName = mapping.getGetMethodName();
        this.setterMethodName = mapping.getSetMethodName();
    }

    public boolean isCollectionMapping() {
        return this.collectionMapping;
    }

    public void setCollectionMapping(boolean collectionMapping) {
        this.collectionMapping = collectionMapping;
    }

    public void setIsMappedWithAttributeAccess(boolean isMappedWithAttributeAccess) {
        this.isMappedWithAttributeAccess = isMappedWithAttributeAccess;
    }

    public boolean isMappedWithAttributeAccess() {
        return this.isMappedWithAttributeAccess;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.attributeName);
        if (this.referenceClass != null) {
            sb.append("[");
            sb.append(this.referenceClass);
            sb.append("]");
        }
        sb.append(" weaveVH: ");
        if (this.weaveValueHolders()) {
            sb.append("true");
        } else {
            sb.append("false");
        }
        sb.append(" CM: ");
        if (this.isCollectionMapping()) {
            sb.append("true");
        } else {
            sb.append("false");
        }
        return sb.toString();
    }
}

