/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

public final class ComponentSupport {
    private static final String MARK_DELETED = "com.sun.faces.facelets.MARK_DELETED";
    public static final String MARK_CREATED = "com.sun.faces.facelets.MARK_ID";
    private static final String IMPLICIT_PANEL = "com.sun.faces.facelets.IMPLICIT_PANEL";

    public static final void finalizeForDeletion(UIComponent c) {
        c.getAttributes().remove(MARK_DELETED);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List cl = c.getChildren();
            while (--sz >= 0) {
                cc = (UIComponent)cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_DELETED)) continue;
                cl.remove(sz);
            }
        }
        if (c.getFacets().size() > 0) {
            Collection col = c.getFacets().values();
            Iterator itr = col.iterator();
            while (itr.hasNext()) {
                UIComponent fc = (UIComponent)itr.next();
                if (!fc.getAttributes().containsKey(MARK_DELETED)) continue;
                itr.remove();
            }
        }
    }

    public static final UIComponent findChild(UIComponent parent, String id) {
        int sz = parent.getChildCount();
        if (sz > 0) {
            UIComponent c = null;
            List cl = parent.getChildren();
            while (--sz >= 0) {
                c = (UIComponent)cl.get(sz);
                if (!id.equals(c.getId())) continue;
                return c;
            }
        }
        return null;
    }

    public static final UIComponent findChildByTagId(UIComponent parent, String id) {
        Iterator itr = parent.getFacetsAndChildren();
        UIComponent c = null;
        String cid = null;
        while (itr.hasNext()) {
            c = (UIComponent)itr.next();
            cid = (String)c.getAttributes().get(MARK_CREATED);
            if (id.equals(cid)) {
                return c;
            }
            if (!(c instanceof UIPanel) || !c.getAttributes().containsKey(IMPLICIT_PANEL)) continue;
            for (UIComponent c2 : c.getChildren()) {
                cid = (String)c2.getAttributes().get(MARK_CREATED);
                if (!id.equals(cid)) continue;
                return c2;
            }
        }
        return null;
    }

    public static final Locale getLocale(FaceletContext ctx, TagAttribute attr) throws TagAttributeException {
        Object obj = attr.getObject(ctx);
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.length() == 2) {
                return new Locale(s);
            }
            if (s.length() == 5) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase());
            }
            if (s.length() >= 7) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase(), s.substring(6, s.length()));
            }
            throw new TagAttributeException(attr, "Invalid Locale Specified: " + s);
        }
        throw new TagAttributeException(attr, "Attribute did not evaluate to a String or Locale: " + obj);
    }

    public static final UIViewRoot getViewRoot(FaceletContext ctx, UIComponent parent) {
        UIComponent c = parent;
        do {
            if (!(c instanceof UIViewRoot)) continue;
            return (UIViewRoot)c;
        } while ((c = c.getParent()) != null);
        return ctx.getFacesContext().getViewRoot();
    }

    public static final void markForDeletion(UIComponent c) {
        c.getAttributes().put(MARK_DELETED, Boolean.TRUE);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List cl = c.getChildren();
            while (--sz >= 0) {
                cc = (UIComponent)cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_CREATED)) continue;
                cc.getAttributes().put(MARK_DELETED, Boolean.TRUE);
            }
        }
        if (c.getFacets().size() > 0) {
            Collection col = c.getFacets().values();
            for (UIComponent fc : col) {
                if (!fc.getAttributes().containsKey(MARK_CREATED)) continue;
                fc.getAttributes().put(MARK_DELETED, Boolean.TRUE);
            }
        }
    }

    public static final void encodeRecursive(FacesContext context, UIComponent viewToRender) throws IOException, FacesException {
        if (viewToRender.isRendered()) {
            viewToRender.encodeBegin(context);
            if (viewToRender.getRendersChildren()) {
                viewToRender.encodeChildren(context);
            } else if (viewToRender.getChildCount() > 0) {
                for (UIComponent kid : viewToRender.getChildren()) {
                    ComponentSupport.encodeRecursive(context, kid);
                }
            }
            viewToRender.encodeEnd(context);
        }
    }

    public static void removeTransient(UIComponent c) {
        UIComponent d;
        Iterator<Object> itr;
        if (c.getChildCount() > 0) {
            itr = c.getChildren().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.getFacets().size() > 0) {
                    Iterator jtr = d.getFacets().values().iterator();
                    while (jtr.hasNext()) {
                        UIComponent e = (UIComponent)jtr.next();
                        if (e.isTransient()) {
                            jtr.remove();
                            continue;
                        }
                        ComponentSupport.removeTransient(e);
                    }
                }
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(d);
            }
        }
        if (c.getFacets().size() > 0) {
            itr = c.getFacets().values().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(d);
            }
        }
    }

    public static final void addComponent(FaceletContext ctx, UIComponent parent, UIComponent child) {
        String facetName = ComponentSupport.getFacetName(parent);
        if (facetName == null) {
            parent.getChildren().add(child);
        } else {
            UIComponent existing = (UIComponent)parent.getFacets().get(facetName);
            if (existing != null) {
                if (!(existing instanceof UIPanel)) {
                    UIComponent panelGroup = ctx.getFacesContext().getApplication().createComponent("javax.faces.Panel");
                    panelGroup.setId(ComponentSupport.getViewRoot(ctx.getFacesContext(), parent).createUniqueId());
                    panelGroup.getAttributes().put(IMPLICIT_PANEL, true);
                    panelGroup.getChildren().add(existing);
                    parent.getFacets().put(facetName, panelGroup);
                    existing = panelGroup;
                }
                if (existing.getAttributes().get(IMPLICIT_PANEL) != null) {
                    existing.getChildren().add(child);
                } else {
                    parent.getFacets().put(facetName, child);
                }
            } else {
                parent.getFacets().put(facetName, child);
            }
        }
    }

    public static final String getFacetName(UIComponent parent) {
        return (String)parent.getAttributes().get("facelets.FACET_NAME");
    }

    private static UIViewRoot getViewRoot(FacesContext ctx, UIComponent parent) {
        if (parent instanceof UIViewRoot) {
            return (UIViewRoot)parent;
        }
        UIViewRoot root = ctx.getViewRoot();
        if (root != null) {
            return root;
        }
        for (UIComponent c = parent.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof UIViewRoot)) continue;
            root = (UIViewRoot)c;
            break;
        }
        return root;
    }
}

