/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.el.lexer.api;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.el.lexer.ELLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum ELTokenId implements TokenId
{
    LT("<", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    GT(">", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    DOT(".", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    COMMA(",", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    QUESTION("?", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    PLUS("+", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    MINUS("-", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    MUL("*", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    DIV("/", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    MOD("%", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    EQ_EQ("==", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    LT_EQ("<=", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    GT_EQ(">=", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    NOT_EQ("!=", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    AND_AND("&&", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    OR_OR("||", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    COLON(":", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    NOT("!", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    LPAREN("(", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    RPAREN(")", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    LBRACKET("[", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    RBRACKET("]", ELTokenCategories.access$000(ELTokenCategories.OPERATORS)),
    AND_KEYWORD("and", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    DIV_KEYWORD("div", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    EMPTY_KEYWORD("empty", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    EQ_KEYWORD("eq", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    FALSE_KEYWORD("false", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    GE_KEYWORD("ge", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    GT_KEYWORD("gt", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    INSTANCEOF_KEYWORD("instanceof", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    LE_KEYWORD("le", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    LT_KEYWORD("lt", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    MOD_KEYWORD("mod", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    NE_KEYWORD("ne", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    NOT_KEYWORD("not", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    NULL_KEYWORD("null", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    OR_KEYWORD("or", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    TRUE_KEYWORD("true", ELTokenCategories.access$000(ELTokenCategories.KEYWORDS)),
    WHITESPACE(null, "whitespace"),
    EOL("\n", "eol"),
    STRING_LITERAL(null, "string"),
    TAG_LIB_PREFIX(null, "tag-lib-prefix"),
    IDENTIFIER(null, "identifier"),
    CHAR_LITERAL(null, "char-literal"),
    INT_LITERAL(null, "int-literal"),
    LONG_LITERAL(null, "long-literal"),
    HEX_LITERAL(null, "hex-literal"),
    OCTAL_LITERAL(null, "octal-literal"),
    FLOAT_LITERAL(null, "float-literal"),
    DOUBLE_LITERAL(null, "double-literal"),
    INVALID_OCTAL_LITERAL(null, "invalid-octal-literal"),
    INVALID_CHAR(null, "invalid-char");

    private final String fixedText;
    private final String primaryCategory;
    private static final Language<ELTokenId> language;

    private ELTokenId(String fixedText, String primaryCategory) {
        this.fixedText = fixedText;
        this.primaryCategory = primaryCategory;
    }

    public String fixedText() {
        return this.fixedText;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<ELTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<ELTokenId>(){

            protected Collection<ELTokenId> createTokenIds() {
                return EnumSet.allOf(ELTokenId.class);
            }

            protected Map<String, Collection<ELTokenId>> createTokenCategories() {
                HashMap<String, Collection<ELTokenId>> cats = new HashMap<String, Collection<ELTokenId>>();
                cats.put(ELTokenCategories.NUMERIC_LITERALS.categoryName, EnumSet.of(INT_LITERAL, new ELTokenId[]{LONG_LITERAL, HEX_LITERAL, OCTAL_LITERAL, FLOAT_LITERAL, DOUBLE_LITERAL}));
                cats.put(ELTokenCategories.ERRORS.categoryName, EnumSet.of(INVALID_OCTAL_LITERAL, INVALID_CHAR));
                return cats;
            }

            protected Lexer<ELTokenId> createLexer(LexerRestartInfo<ELTokenId> info) {
                return new ELLexer(info);
            }

            public LanguageEmbedding<?> embedding(Token<ELTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                return null;
            }

            protected String mimeType() {
                return "text/x-el";
            }
        }.language();
    }

    public static enum ELTokenCategories {
        KEYWORDS("keyword"),
        OPERATORS("operators"),
        NUMERIC_LITERALS("numeric-literals"),
        ERRORS("error");

        private final String categoryName;

        private ELTokenCategories(String categoryName) {
            this.categoryName = categoryName;
        }

        public boolean hasCategory(TokenId id) {
            return id.primaryCategory().equals(this.categoryName);
        }
    }
}

