/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.hints;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.java.hints.infrastructure.JavaHintsPositionRefresher;
import org.netbeans.modules.java.hints.jackpot.impl.hints.HintsInvoker;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;

public class HintsTask
implements CancellableTask<CompilationInfo> {
    public static final String KEY_HINTS = HintsInvoker.class.getName() + "-hints";
    public static final String KEY_SUGGESTIONS = HintsInvoker.class.getName() + "-suggestions";
    private static final Logger TIMER = Logger.getLogger("TIMER");
    private static final Logger TIMER_EDITOR = Logger.getLogger("TIMER.editor");
    private static final Logger TIMER_CARET = Logger.getLogger("TIMER.caret");
    private final AtomicBoolean cancel = new AtomicBoolean();
    private final boolean caretAware;

    public HintsTask(boolean bl) {
        this.caretAware = bl;
    }

    public void run(CompilationInfo compilationInfo) {
        this.cancel.set(false);
        Document document = compilationInfo.getSnapshot().getSource().getDocument(false);
        long l = document != null ? DocumentUtilities.getDocumentVersion((Document)document) : 0L;
        long l2 = System.currentTimeMillis();
        int n = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)compilationInfo.getFileObject());
        HintsInvoker hintsInvoker = this.caretAware ? new HintsInvoker(compilationInfo, n, this.cancel) : new HintsInvoker(compilationInfo, this.cancel);
        List<ErrorDescription> list = hintsInvoker.computeHints(compilationInfo);
        if (this.cancel.get()) {
            return;
        }
        HintsController.setErrors((FileObject)compilationInfo.getFileObject(), (String)(this.caretAware ? KEY_SUGGESTIONS : KEY_HINTS), list);
        if (this.caretAware) {
            JavaHintsPositionRefresher.suggestionsUpdated(document, l, n);
        } else {
            JavaHintsPositionRefresher.hintsUpdated(document, l);
        }
        long l3 = System.currentTimeMillis();
        TIMER.log(Level.FINE, "Jackpot 3.0 Hints Task" + (this.caretAware ? " - Caret Aware" : ""), new Object[]{compilationInfo.getFileObject(), l3 - l2});
        Logger logger = this.caretAware ? TIMER_CARET : TIMER_EDITOR;
        for (Map.Entry<String, Long> entry : hintsInvoker.getTimeLog().entrySet()) {
            logger.log(Level.FINE, entry.getKey(), new Object[]{compilationInfo.getFileObject(), entry.getValue()});
        }
    }

    public void cancel() {
        this.cancel.set(true);
    }

    public static final class CaretFactoryImpl
    extends CaretAwareJavaSourceTaskFactory
    implements ChangeListener {
        public CaretFactoryImpl() {
            super(JavaSource.Phase.RESOLVED, JavaSource.Priority.LOW);
            HintsSettings.addChangeListener(WeakListeners.change((ChangeListener)this, HintsSettings.class));
        }

        protected CancellableTask<CompilationInfo> createTask(FileObject fileObject) {
            return new HintsTask(true);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            for (FileObject fileObject : this.getFileObjects()) {
                this.reschedule(fileObject);
            }
        }
    }

    public static final class FactoryImpl
    extends EditorAwareJavaSourceTaskFactory
    implements ChangeListener {
        public FactoryImpl() {
            super(JavaSource.Phase.RESOLVED, JavaSource.Priority.LOW);
            HintsSettings.addChangeListener(WeakListeners.change((ChangeListener)this, HintsSettings.class));
        }

        protected CancellableTask<CompilationInfo> createTask(FileObject fileObject) {
            return new HintsTask(false);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            for (FileObject fileObject : this.getFileObjects()) {
                this.reschedule(fileObject);
            }
        }
    }
}

