/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MakeVariableFinal
implements ErrorRule<Void> {
    private static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.err.local.var.accessed.from.icls.needs.final"));

    @Override
    public Set<String> getCodes() {
        return CODES;
    }

    @Override
    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<Void> data) {
        Tree tree = treePath.getLeaf();
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            Element element = compilationInfo.getTrees().getElement(treePath);
            TreePath treePath2 = compilationInfo.getTrees().getPath(element);
            if (treePath2 != null) {
                return Collections.singletonList(new FixImpl(compilationInfo.getFileObject(), element.getSimpleName().toString(), TreePathHandle.create((TreePath)treePath2, (CompilationInfo)compilationInfo)));
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return MakeVariableFinal.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(MakeVariableFinal.class, (String)"DN_MakeVariableFinal");
    }

    public String getDescription() {
        return NbBundle.getMessage(MakeVariableFinal.class, (String)"DESC_MakeVariableFinal");
    }

    private static final class FixImpl
    implements Fix {
        private String variableName;
        private TreePathHandle variable;
        private FileObject file;

        public FixImpl(FileObject fileObject, String string, TreePathHandle treePathHandle) {
            this.file = fileObject;
            this.variableName = string;
            this.variable = treePathHandle;
        }

        public String getText() {
            return NbBundle.getMessage(MakeVariableFinal.class, (String)"FIX_MakeVariableFinal", (Object[])new Object[]{String.valueOf(this.variableName)});
        }

        public ChangeInfo implement() throws IOException {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath treePath = FixImpl.this.variable.resolve((CompilationInfo)workingCopy);
                    if (treePath == null) {
                        return;
                    }
                    VariableTree variableTree = (VariableTree)treePath.getLeaf();
                    ModifiersTree modifiersTree = variableTree.getModifiers();
                    EnumSet<Modifier> enumSet = EnumSet.noneOf(Modifier.class);
                    enumSet.addAll(modifiersTree.getFlags());
                    enumSet.add(Modifier.FINAL);
                    ModifiersTree modifiersTree2 = workingCopy.getTreeMaker().Modifiers(enumSet, modifiersTree.getAnnotations());
                    workingCopy.rewrite((Tree)modifiersTree, (Tree)modifiersTree2);
                }
            }).commit();
            return null;
        }
    }
}

