/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Map;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class LeakingThisInConstructor {
    private static final String THIS_KEYWORD = "this";

    public static ErrorDescription hint(HintContext hintContext) {
        IdentifierTree identifierTree = (IdentifierTree)hintContext.getPath().getLeaf();
        CompilationInfo compilationInfo = hintContext.getInfo();
        if (!Utilities.isInConstructor(hintContext)) {
            return null;
        }
        Element element = compilationInfo.getTrees().getElement(hintContext.getPath());
        if (element == null || !element.getSimpleName().contentEquals(THIS_KEYWORD)) {
            return null;
        }
        if (hintContext.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        return ErrorDescriptionFactory.forName(hintContext, identifierTree, NbBundle.getMessage(LeakingThisInConstructor.class, (String)"MSG_org.netbeans.modules.java.hints.LeakingThisInConstructor"), new Fix[0]);
    }

    public static ErrorDescription hintOnAssignment(HintContext hintContext) {
        Map<String, TreePath> map = hintContext.getVariables();
        TreePath treePath = map.get("$this");
        if (treePath.getLeaf().getKind() != Tree.Kind.IDENTIFIER || !((IdentifierTree)treePath.getLeaf()).getName().contentEquals(THIS_KEYWORD)) {
            return null;
        }
        if (!Utilities.isInConstructor(hintContext)) {
            return null;
        }
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), NbBundle.getMessage(LeakingThisInConstructor.class, (String)"MSG_org.netbeans.modules.java.hints.LeakingThisInConstructor"), new Fix[0]);
    }
}

