/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.modules.php.project.ui.logicalview.PhpLogicalViewProvider;
import org.netbeans.modules.php.project.ui.logicalview.PhpSourcesFilter;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class IncludePathNodeFactory
implements NodeFactory {
    public NodeList<Node> createNodes(Project p) {
        final PhpProject project = (PhpProject)p.getLookup().lookup(PhpProject.class);
        return NodeFactorySupport.fixedNodeList((Node[])new Node[]{new DummyNode((Node)new IncludePathRootNode(project)){

            @Override
            public Action[] getActions(boolean context) {
                return new Action[]{new PhpLogicalViewProvider.CustomizeProjectAction(project, "PhpIncludePath")};
            }
        }});
    }

    private static class DummyChildren
    extends FilterNode.Children {
        private DataFilter filter;

        DummyChildren(Node originalNode, DataFilter filter) {
            super(originalNode);
            this.filter = filter;
        }

        protected Node[] createNodes(Node key) {
            DataObject dobj = (DataObject)key.getLookup().lookup(DataObject.class);
            return dobj != null && this.filter.acceptDataObject(dobj) ? super.createNodes(key) : new Node[]{};
        }

        protected Node copyNode(Node originalNode) {
            DataObject dobj = (DataObject)originalNode.getLookup().lookup(DataObject.class);
            return dobj instanceof DataFolder ? new DummyNode(dobj.getNodeDelegate(), (Children)new DummyChildren(originalNode, this.filter)) : new DummyNode(dobj.getNodeDelegate());
        }
    }

    private static class DummyNode
    extends FilterNode {
        public DummyNode(Node original) {
            super(original);
        }

        public DummyNode(Node original, Children children) {
            super(original, children);
        }

        public boolean canCopy() {
            return true;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }

        public boolean hasCustomizer() {
            return false;
        }
    }

    private static class IncludePathNode
    extends DummyNode {
        private static final String ICON_PATH = "org/netbeans/modules/php/project/ui/resources/libraries.gif";
        private static final ImageIcon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/libraries.gif", (boolean)false);

        public IncludePathNode(DataObject dobj, PhpProject project) {
            super(dobj.getNodeDelegate(), (Children)(dobj instanceof DataFolder ? new DummyChildren((Node)new DummyNode(dobj.getNodeDelegate()), (DataFilter)new PhpSourcesFilter(project)) : FilterNode.Children.LEAF));
        }

        public String getDisplayName() {
            FileObject fo = (FileObject)this.getOriginal().getLookup().lookup(FileObject.class);
            return fo != null ? FileUtil.getFileDisplayName((FileObject)fo) : super.getDisplayName();
        }

        public Image getIcon(int type) {
            return ICON.getImage();
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    }

    private static class IncludePathChildFactory
    extends ChildFactory<Node> {
        private final PhpProject project;

        public IncludePathChildFactory(PhpProject project) {
            this.project = project;
            assert (project != null);
        }

        protected boolean createKeys(List<Node> toPopulate) {
            toPopulate.addAll(this.createNodeList().keys());
            return true;
        }

        protected Node createNodeForKey(Node key) {
            return key;
        }

        NodeList<Node> createNodeList() {
            ArrayList<IncludePathNode> list = new ArrayList<IncludePathNode>();
            assert (this.project != null);
            List includePath = (List)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<List<FileObject>>(){

                public List<FileObject> run() {
                    return PhpSourcePath.getIncludePath(IncludePathChildFactory.this.project.getProjectDirectory());
                }
            });
            for (FileObject fileObject : includePath) {
                if (fileObject == null || !fileObject.isFolder()) continue;
                DataFolder df = DataFolder.findFolder((FileObject)fileObject);
                list.add(new IncludePathNode((DataObject)df, this.project));
            }
            Node[] nodes = list.toArray(new Node[list.size()]);
            return NodeFactorySupport.fixedNodeList((Node[])nodes);
        }
    }

    private static class IncludePathRootNode
    extends AbstractNode
    implements PropertyChangeListener {
        private PhpProject project;
        private static final String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/php/project/ui/resources/referencedClasspath.gif";
        private static final ImageIcon ICON_CLASSPATH = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/referencedClasspath.gif", (boolean)false);

        public IncludePathRootNode(PhpProject project) {
            super(IncludePathRootNode.createChildren(project));
            this.project = project;
            ProjectPropertiesSupport.addWeakPropertyEvaluatorListener(project, this);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(IncludePathNodeFactory.class, (String)"LBL_IncludePath");
        }

        public Image getIcon(int type) {
            return ICON_CLASSPATH.getImage();
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IncludePathRootNode.this.setChildren(IncludePathRootNode.createChildren(IncludePathRootNode.this.project));
                }
            });
        }

        private static Children createChildren(PhpProject project) {
            return Children.create((ChildFactory)new IncludePathChildFactory(project), (boolean)false);
        }
    }
}

