/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.workspace;

import java.io.File;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.build.model.ModelAndFile;
import org.apache.maven.project.workspace.ProjectWorkspace;
import org.apache.maven.workspace.MavenWorkspaceStore;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

public class DefaultProjectWorkspace
implements ProjectWorkspace,
LogEnabled {
    private MavenWorkspaceStore workspaceStore;
    private Logger logger;

    public DefaultProjectWorkspace() {
    }

    protected DefaultProjectWorkspace(MavenWorkspaceStore workspaceStore, Logger logger) {
        this.workspaceStore = workspaceStore;
        this.logger = logger;
    }

    public ModelAndFile getModelAndFile(String groupId, String artifactId, String version) {
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:modelAndFile:GAV");
        String key = this.createCacheKey(groupId, artifactId, version);
        return (ModelAndFile)cache.get(key);
    }

    public ModelAndFile getModelAndFile(File modelFile) {
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:modelAndFile:file");
        Object pathKey = this.resolvePathKey(modelFile);
        return (ModelAndFile)cache.get(pathKey);
    }

    private Object resolvePathKey(File file) {
        if (file == null) {
            return null;
        }
        return file.toURI().normalize().toString();
    }

    public MavenProject getProject(File projectFile) {
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:project:file");
        Object pathKey = this.resolvePathKey(projectFile);
        return (MavenProject)cache.get(pathKey);
    }

    public MavenProject getProject(String groupId, String artifactId, String version) {
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:project:GAV");
        String key = this.createCacheKey(groupId, artifactId, version);
        return (MavenProject)cache.get(key);
    }

    public void storeModelAndFile(ModelAndFile modelAndFile) {
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:modelAndFile:file");
        Object pathKey = this.resolvePathKey(modelAndFile.getFile());
        cache.put(pathKey, modelAndFile);
        cache = this.workspaceStore.getWorkspaceCache("maven:project:modelAndFile:GAV");
        Model model = modelAndFile.getModel();
        String key = this.createCacheKey(model.getGroupId(), model.getArtifactId(), model.getVersion());
        String keyWithParent = this.createCacheKeyUsingParent(model);
        cache.put(key, modelAndFile);
        if (!key.equals(keyWithParent)) {
            cache.put(keyWithParent, modelAndFile);
        }
    }

    private String createCacheKeyUsingParent(Model model) {
        String groupId = model.getGroupId();
        String version = model.getVersion();
        Parent parent = model.getParent();
        if (parent != null) {
            if (groupId == null) {
                groupId = parent.getGroupId();
            }
            if (version == null) {
                version = parent.getVersion();
            }
        }
        return this.createCacheKey(groupId, model.getArtifactId(), version);
    }

    public void storeProjectByFile(MavenProject project) {
        if (project.getFile() == null) {
            return;
        }
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:project:file");
        Object pathKey = this.resolvePathKey(project.getFile());
        cache.put(pathKey, project);
    }

    public void storeProjectByCoordinate(MavenProject project) {
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:project:GAV");
        String key = this.createCacheKey(project.getGroupId(), project.getArtifactId(), project.getVersion());
        cache.put(key, project);
    }

    private String createCacheKey(String groupId, String artifactId, String version) {
        return String.valueOf(groupId) + ":" + artifactId + ":" + version;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

