/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.manager;

import hidden.org.codehaus.plexus.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.ChecksumFailedException;
import org.apache.maven.artifact.manager.CredentialsChangeRequest;
import org.apache.maven.artifact.manager.CredentialsDataSource;
import org.apache.maven.artifact.manager.CredentialsDataSourceException;
import org.apache.maven.artifact.manager.UpdateCheckManager;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWagonManager
extends AbstractLogEnabled
implements WagonManager,
Contextualizable {
    private static final String WILDCARD = "*";
    private static final String EXTERNAL_WILDCARD = "external:*";
    private static final String[] CHECKSUM_IDS = new String[]{"md5", "sha1"};
    private static final String[] CHECKSUM_ALGORITHMS = new String[]{"MD5", "SHA-1"};
    private PlexusContainer container;
    private Map<String, ProxyInfo> proxies = new HashMap<String, ProxyInfo>();
    private Map<String, AuthenticationInfo> authenticationInfoMap = new HashMap<String, AuthenticationInfo>();
    private Map<String, RepositoryPermissions> serverPermissionsMap = new HashMap<String, RepositoryPermissions>();
    private Map<String, ArtifactRepository> mirrors = new LinkedHashMap<String, ArtifactRepository>();
    private Map<String, XmlPlexusConfiguration> serverConfigurationMap = new HashMap<String, XmlPlexusConfiguration>();
    private TransferListener downloadMonitor;
    private boolean online = true;
    private boolean interactive = true;
    private RepositoryPermissions defaultRepositoryPermissions;
    private ArtifactRepositoryFactory repositoryFactory;
    private Map wagons;
    private CredentialsDataSource credentialsDataSource;
    private UpdateCheckManager updateCheckManager;

    @Override
    public Wagon getWagon(Repository repository) throws UnsupportedProtocolException, WagonConfigurationException {
        String protocol = repository.getProtocol();
        if (protocol == null) {
            throw new UnsupportedProtocolException("The repository " + repository + " does not specify a protocol");
        }
        Wagon wagon = this.getWagon(protocol);
        this.configureWagon(wagon, repository.getId());
        return wagon;
    }

    @Override
    public Wagon getWagon(String protocol) throws UnsupportedProtocolException {
        if (protocol == null) {
            throw new UnsupportedProtocolException("Unspecified protocol");
        }
        String hint = protocol.toLowerCase(Locale.ENGLISH);
        Wagon wagon = (Wagon)this.wagons.get(hint);
        if (wagon == null) {
            throw new UnsupportedProtocolException("Cannot find wagon which supports the requested protocol: " + protocol);
        }
        wagon.setInteractive(this.interactive);
        return wagon;
    }

    @Override
    public void putArtifact(File source, Artifact artifact, ArtifactRepository deploymentRepository) throws TransferFailedException {
        this.putRemoteFile(deploymentRepository, source, deploymentRepository.pathOf(artifact), this.downloadMonitor);
    }

    @Override
    public void putArtifactMetadata(File source, ArtifactMetadata artifactMetadata, ArtifactRepository repository) throws TransferFailedException {
        this.getLogger().info("Uploading " + artifactMetadata);
        this.putRemoteFile(repository, source, repository.pathOfRemoteRepositoryMetadata(artifactMetadata), null);
    }

    private void putRemoteFile(ArtifactRepository repository, File source, String remotePath, TransferListener downloadMonitor) throws TransferFailedException {
        Wagon wagon;
        this.failIfNotOnline();
        String protocol = repository.getProtocol();
        try {
            wagon = this.getWagon(protocol);
            this.configureWagon(wagon, repository);
        }
        catch (UnsupportedProtocolException e) {
            throw new TransferFailedException("Unsupported Protocol: '" + protocol + "': " + e.getMessage(), e);
        }
        if (downloadMonitor != null) {
            wagon.addTransferListener(downloadMonitor);
        }
        HashMap<String, ChecksumObserver> checksums = new HashMap<String, ChecksumObserver>(2);
        HashMap<String, String> sums = new HashMap<String, String>(2);
        for (int i = 0; i < CHECKSUM_IDS.length; ++i) {
            checksums.put(CHECKSUM_IDS[i], this.addChecksumObserver(wagon, CHECKSUM_ALGORITHMS[i]));
        }
        try {
            try {
                Repository artifactRepository = new Repository(repository.getId(), repository.getUrl());
                if (this.serverPermissionsMap.containsKey(repository.getId())) {
                    RepositoryPermissions perms = this.serverPermissionsMap.get(repository.getId());
                    this.getLogger().debug("adding permissions to wagon connection: " + perms.getFileMode() + " " + perms.getDirectoryMode());
                    artifactRepository.setPermissions(perms);
                } else {
                    this.getLogger().debug("not adding permissions to wagon connection");
                }
                wagon.connect(artifactRepository, this.getAuthenticationInfo(repository.getId()), this.getProxy(protocol));
                wagon.put(source, remotePath);
            }
            catch (CredentialsDataSourceException e) {
                String err = "Problem with server credentials: " + e.getMessage();
                this.getLogger().error(err);
                throw new TransferFailedException(err);
            }
            finally {
                if (downloadMonitor != null) {
                    wagon.removeTransferListener(downloadMonitor);
                }
            }
            for (String extension : checksums.keySet()) {
                ChecksumObserver observer = (ChecksumObserver)checksums.get(extension);
                sums.put(extension, observer.getActualChecksum());
            }
            for (String extension : checksums.keySet()) {
                File temp = File.createTempFile("maven-artifact", null);
                temp.deleteOnExit();
                FileUtils.fileWrite(temp.getAbsolutePath(), "UTF-8", (String)sums.get(extension));
                wagon.put(temp, remotePath + "." + extension);
            }
        }
        catch (ConnectionException e) {
            throw new TransferFailedException("Connection failed: " + e.getMessage(), e);
        }
        catch (AuthenticationException e) {
            throw new TransferFailedException("Authentication failed: " + e.getMessage(), e);
        }
        catch (AuthorizationException e) {
            throw new TransferFailedException("Authorization failed: " + e.getMessage(), e);
        }
        catch (ResourceDoesNotExistException e) {
            throw new TransferFailedException("Resource to deploy not found: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error creating temporary file for deployment: " + e.getMessage(), e);
        }
        finally {
            for (String aCHECKSUM_IDS : CHECKSUM_IDS) {
                TransferListener checksumListener = (TransferListener)checksums.get(aCHECKSUM_IDS);
                if (checksumListener == null) continue;
                wagon.removeTransferListener(checksumListener);
            }
            this.disconnectWagon(wagon);
            this.releaseWagon(protocol, wagon);
        }
    }

    private ChecksumObserver addChecksumObserver(Wagon wagon, String algorithm) throws TransferFailedException {
        try {
            ChecksumObserver checksumObserver = new ChecksumObserver(algorithm);
            wagon.addTransferListener(checksumObserver);
            return checksumObserver;
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransferFailedException("Unable to add checksum for unsupported algorithm " + algorithm, e);
        }
    }

    @Override
    public void getArtifact(Artifact artifact, List<ArtifactRepository> remoteRepositories) throws TransferFailedException, ResourceDoesNotExistException {
        this.getArtifact(artifact, remoteRepositories, true);
    }

    @Override
    public void getArtifact(Artifact artifact, List<ArtifactRepository> remoteRepositories, boolean force) throws TransferFailedException, ResourceDoesNotExistException {
        boolean successful = false;
        for (ArtifactRepository repository : remoteRepositories) {
            try {
                this.getArtifact(artifact, repository, force);
                successful = artifact.isResolved();
            }
            catch (ResourceDoesNotExistException e) {
                this.getLogger().debug("Unable to get resource '" + artifact.getId() + "' from repository " + repository.getId() + " (" + repository.getUrl() + ")", e);
            }
            catch (TransferFailedException e) {
                this.getLogger().debug("Unable to get resource '" + artifact.getId() + "' from repository " + repository.getId() + " (" + repository.getUrl() + ")", e);
            }
        }
        if (!successful && !artifact.getFile().exists()) {
            throw new ResourceDoesNotExistException("Unable to download the artifact from any repository");
        }
    }

    @Override
    public void getArtifact(Artifact artifact, ArtifactRepository repository) throws TransferFailedException, ResourceDoesNotExistException {
        this.getArtifact(artifact, repository, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getArtifact(Artifact artifact, ArtifactRepository repository, boolean force) throws TransferFailedException, ResourceDoesNotExistException {
        ArtifactRepositoryPolicy policy;
        String remotePath = repository.pathOf(artifact);
        ArtifactRepositoryPolicy artifactRepositoryPolicy = policy = artifact.isSnapshot() ? repository.getSnapshots() : repository.getReleases();
        if (!policy.isEnabled()) {
            this.getLogger().debug("Skipping disabled repository " + repository.getId());
        } else if (repository.isBlacklisted()) {
            this.getLogger().debug("Skipping blacklisted repository " + repository.getId());
        } else if (artifact.isSnapshot() && (force || this.updateCheckManager.isUpdateRequired(artifact, repository))) {
            this.getLogger().debug("Trying repository " + repository.getId());
            try {
                this.getRemoteFile(this.getMirrorRepository(repository), artifact.getFile(), remotePath, this.downloadMonitor, policy.getChecksumPolicy(), false);
            }
            finally {
                this.updateCheckManager.touch(artifact, repository);
            }
            this.getLogger().debug("  Artifact resolved");
            artifact.setResolved(true);
        } else if (!artifact.isSnapshot()) {
            this.getLogger().debug("Trying repository " + repository.getId());
            this.getRemoteFile(this.getMirrorRepository(repository), artifact.getFile(), remotePath, this.downloadMonitor, policy.getChecksumPolicy(), false);
            this.getLogger().debug("  Artifact resolved");
            artifact.setResolved(true);
        }
    }

    @Override
    public void getArtifactMetadata(ArtifactMetadata metadata, ArtifactRepository repository, File destination, String checksumPolicy) throws TransferFailedException, ResourceDoesNotExistException {
        String remotePath = repository.pathOfRemoteRepositoryMetadata(metadata);
        this.getRemoteFile(this.getMirrorRepository(repository), destination, remotePath, null, checksumPolicy, true);
    }

    @Override
    public void getArtifactMetadataFromDeploymentRepository(ArtifactMetadata metadata, ArtifactRepository repository, File destination, String checksumPolicy) throws TransferFailedException, ResourceDoesNotExistException {
        String remotePath = repository.pathOfRemoteRepositoryMetadata(metadata);
        this.getRemoteFile(repository, destination, remotePath, null, checksumPolicy, true);
    }

    private void getRemoteFile(ArtifactRepository repository, File destination, String remotePath, TransferListener downloadMonitor, String checksumPolicy, boolean force) throws TransferFailedException, ResourceDoesNotExistException {
        Wagon wagon;
        this.failIfNotOnline();
        String protocol = repository.getProtocol();
        try {
            wagon = this.getWagon(protocol);
            this.configureWagon(wagon, repository);
        }
        catch (UnsupportedProtocolException e) {
            throw new TransferFailedException("Unsupported Protocol: '" + protocol + "': " + e.getMessage(), e);
        }
        if (downloadMonitor != null) {
            wagon.addTransferListener(downloadMonitor);
        }
        int i = 0;
        ChecksumObserver md5ChecksumObserver = this.addChecksumObserver(wagon, CHECKSUM_ALGORITHMS[i++]);
        ChecksumObserver sha1ChecksumObserver = this.addChecksumObserver(wagon, CHECKSUM_ALGORITHMS[i++]);
        File temp = new File(destination + ".tmp");
        temp.deleteOnExit();
        boolean downloaded = false;
        try {
            wagon.connect(new Repository(repository.getId(), repository.getUrl()), this.getAuthenticationInfo(repository.getId()), this.getProxy(protocol));
            boolean firstRun = true;
            boolean retry = true;
            while (firstRun || retry) {
                retry = false;
                if (destination.exists() && !force) {
                    try {
                        downloaded = wagon.getIfNewer(remotePath, temp, destination.lastModified());
                        if (!downloaded) {
                            destination.setLastModified(System.currentTimeMillis());
                        }
                    }
                    catch (UnsupportedOperationException e) {
                        wagon.get(remotePath, temp);
                        downloaded = true;
                    }
                } else {
                    wagon.get(remotePath, temp);
                    downloaded = true;
                }
                if (downloaded) {
                    if (downloadMonitor != null) {
                        wagon.removeTransferListener(downloadMonitor);
                    }
                    try {
                        this.verifyChecksum(sha1ChecksumObserver, destination, temp, remotePath, ".sha1", wagon);
                    }
                    catch (ChecksumFailedException e) {
                        if (firstRun) {
                            this.getLogger().warn("*** CHECKSUM FAILED - " + e.getMessage() + " - RETRYING");
                            retry = true;
                        } else {
                            this.handleChecksumFailure(checksumPolicy, e.getMessage(), e.getCause());
                        }
                    }
                    catch (ResourceDoesNotExistException sha1TryException) {
                        this.getLogger().debug("SHA1 not found, trying MD5", sha1TryException);
                        try {
                            this.verifyChecksum(md5ChecksumObserver, destination, temp, remotePath, ".md5", wagon);
                        }
                        catch (ChecksumFailedException e) {
                            if (firstRun) {
                                retry = true;
                            } else {
                                this.handleChecksumFailure(checksumPolicy, e.getMessage(), e.getCause());
                            }
                        }
                        catch (ResourceDoesNotExistException md5TryException) {
                            this.handleChecksumFailure(checksumPolicy, "Error retrieving checksum file for " + remotePath, md5TryException);
                        }
                    }
                    if (downloadMonitor != null) {
                        wagon.addTransferListener(downloadMonitor);
                    }
                }
                firstRun = false;
            }
        }
        catch (ConnectionException e) {
            throw new TransferFailedException("Connection failed: " + e.getMessage(), e);
        }
        catch (AuthenticationException e) {
            throw new TransferFailedException("Authentication failed: " + e.getMessage(), e);
        }
        catch (AuthorizationException e) {
            throw new TransferFailedException("Authorization failed: " + e.getMessage(), e);
        }
        catch (CredentialsDataSourceException e) {
            throw new TransferFailedException("Retrieving credentials failed: " + e.getMessage(), e);
        }
        finally {
            wagon.removeTransferListener(md5ChecksumObserver);
            wagon.removeTransferListener(sha1ChecksumObserver);
            if (downloadMonitor != null) {
                wagon.removeTransferListener(downloadMonitor);
            }
            this.disconnectWagon(wagon);
            this.releaseWagon(protocol, wagon);
        }
        if (downloaded) {
            if (!temp.exists()) {
                throw new ResourceDoesNotExistException("Downloaded file does not exist: " + temp);
            }
            if (!temp.renameTo(destination)) {
                try {
                    FileUtils.copyFile(temp, destination);
                    temp.delete();
                }
                catch (IOException e) {
                    throw new TransferFailedException("Error copying temporary file to the final destination: " + e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public ArtifactRepository getMirrorRepository(ArtifactRepository repository) {
        ArtifactRepository mirror = this.getMirror(repository);
        if (mirror != null) {
            String id = mirror.getId();
            if (id == null) {
                id = repository.getId();
            }
            this.getLogger().info("Using mirror: " + mirror.getId() + " for repository: " + repository.getId() + "\n(mirror url: " + mirror.getUrl() + ")");
            repository = this.repositoryFactory.createArtifactRepository(id, mirror.getUrl(), repository.getLayout(), repository.getSnapshots(), repository.getReleases());
        }
        return repository;
    }

    private void failIfNotOnline() throws TransferFailedException {
        if (!this.isOnline()) {
            throw new TransferFailedException("System is offline.");
        }
    }

    private void handleChecksumFailure(String checksumPolicy, String message, Throwable cause) throws ChecksumFailedException {
        if ("fail".equals(checksumPolicy)) {
            throw new ChecksumFailedException(message, cause);
        }
        if (!"ignore".equals(checksumPolicy)) {
            this.getLogger().warn("*** CHECKSUM FAILED - " + message + " - IGNORING");
        }
    }

    private void verifyChecksum(ChecksumObserver checksumObserver, File destination, File tempDestination, String remotePath, String checksumFileExtension, Wagon wagon) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        try {
            File checksumFile;
            String actualChecksum = checksumObserver.getActualChecksum();
            File tempChecksumFile = new File(tempDestination + checksumFileExtension + ".tmp");
            tempChecksumFile.deleteOnExit();
            wagon.get(remotePath + checksumFileExtension, tempChecksumFile);
            String expectedChecksum = FileUtils.fileRead(tempChecksumFile, "UTF-8");
            expectedChecksum = expectedChecksum.trim();
            if (expectedChecksum.startsWith("MD5")) {
                int lastSpacePos = expectedChecksum.lastIndexOf(32);
                expectedChecksum = expectedChecksum.substring(lastSpacePos + 1);
            } else {
                int spacePos = expectedChecksum.indexOf(32);
                if (spacePos != -1) {
                    expectedChecksum = expectedChecksum.substring(0, spacePos);
                }
            }
            if (expectedChecksum.equalsIgnoreCase(actualChecksum)) {
                checksumFile = new File(destination + checksumFileExtension);
                if (checksumFile.exists()) {
                    checksumFile.delete();
                }
            } else {
                throw new ChecksumFailedException("Checksum failed on download: local = '" + actualChecksum + "'; remote = '" + expectedChecksum + "'");
            }
            FileUtils.copyFile(tempChecksumFile, checksumFile);
            tempChecksumFile.delete();
        }
        catch (IOException e) {
            throw new ChecksumFailedException("Invalid checksum file", e);
        }
    }

    private void disconnectWagon(Wagon wagon) {
        try {
            wagon.disconnect();
        }
        catch (ConnectionException e) {
            this.getLogger().error("Problem disconnecting from wagon - ignoring: " + e.getMessage());
        }
    }

    private void releaseWagon(String protocol, Wagon wagon) {
        try {
            this.container.release(wagon);
        }
        catch (ComponentLifecycleException e) {
            this.getLogger().error("Problem releasing wagon - ignoring: " + e.getMessage());
            this.getLogger().debug("", e);
        }
    }

    @Override
    public ProxyInfo getProxy(String protocol) {
        return this.proxies.get(protocol);
    }

    @Override
    public AuthenticationInfo getAuthenticationInfo(String id) throws CredentialsDataSourceException {
        return this.credentialsDataSource == null ? this.authenticationInfoMap.get(id) : this.credentialsDataSource.get(id);
    }

    public ArtifactRepository getMirror(ArtifactRepository originalRepository) {
        Set<String> keySet;
        ArtifactRepository selectedMirror = this.mirrors.get(originalRepository.getId());
        if (null == selectedMirror && (keySet = this.mirrors.keySet()) != null) {
            for (String pattern : keySet) {
                if (!this.matchPattern(originalRepository, pattern)) continue;
                selectedMirror = this.mirrors.get(pattern);
            }
        }
        return selectedMirror;
    }

    public boolean matchPattern(ArtifactRepository originalRepository, String pattern) {
        boolean result = false;
        String originalId = originalRepository.getId();
        if (pattern == null) {
            return false;
        }
        if (WILDCARD.equals(pattern) || pattern.equals(originalId)) {
            result = true;
        } else {
            String[] repos;
            for (String repo : repos = pattern.split(",")) {
                if (repo.length() > 1 && repo.startsWith("!")) {
                    if (!originalId.equals(repo.substring(1))) continue;
                    result = false;
                    break;
                }
                if (originalId.equals(repo)) {
                    result = true;
                    break;
                }
                if (EXTERNAL_WILDCARD.equals(repo) && this.isExternalRepo(originalRepository)) {
                    result = true;
                    continue;
                }
                if (!WILDCARD.equals(repo)) continue;
                result = true;
            }
        }
        return result;
    }

    public boolean isExternalRepo(ArtifactRepository originalRepository) {
        try {
            URL url = new URL(originalRepository.getUrl());
            return !url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1") && !url.getProtocol().equals("file");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @Override
    public void addProxy(String protocol, String host, int port, String username, String password, String nonProxyHosts) {
        ProxyInfo proxyInfo = new ProxyInfo();
        proxyInfo.setHost(host);
        proxyInfo.setType(protocol);
        proxyInfo.setPort(port);
        proxyInfo.setNonProxyHosts(nonProxyHosts);
        proxyInfo.setUserName(username);
        proxyInfo.setPassword(password);
        this.proxies.put(protocol, proxyInfo);
    }

    @Override
    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }

    @Override
    public void setDownloadMonitor(TransferListener downloadMonitor) {
        this.downloadMonitor = downloadMonitor;
    }

    @Override
    public void addAuthenticationInfo(String repositoryId, String username, String password, String privateKey, String passphrase) {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName(username);
        authInfo.setPassword(password);
        authInfo.setPrivateKey(privateKey);
        authInfo.setPassphrase(passphrase);
        this.authenticationInfoMap.put(repositoryId, authInfo);
    }

    @Override
    public void addAuthenticationCredentials(String repositoryId, String username, String password, String privateKey, String passphrase) throws CredentialsDataSourceException {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName(username);
        authInfo.setPassword(password);
        authInfo.setPrivateKey(privateKey);
        authInfo.setPassphrase(passphrase);
        if (this.credentialsDataSource == null) {
            this.authenticationInfoMap.put(repositoryId, authInfo);
        } else {
            this.credentialsDataSource.set(new CredentialsChangeRequest(repositoryId, authInfo, null));
        }
    }

    @Override
    public void addPermissionInfo(String repositoryId, String filePermissions, String directoryPermissions) {
        RepositoryPermissions permissions = new RepositoryPermissions();
        boolean addPermissions = false;
        if (filePermissions != null) {
            permissions.setFileMode(filePermissions);
            addPermissions = true;
        }
        if (directoryPermissions != null) {
            permissions.setDirectoryMode(directoryPermissions);
            addPermissions = true;
        }
        if (addPermissions) {
            this.serverPermissionsMap.put(repositoryId, permissions);
        }
    }

    @Override
    public void addMirror(String id, String mirrorOf, String url) {
        DefaultArtifactRepository mirror = new DefaultArtifactRepository(id, url, null);
        this.mirrors.put(mirrorOf, mirror);
    }

    @Override
    public void setOnline(boolean online) {
        this.online = online;
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    @Override
    public void findAndRegisterWagons(PlexusContainer container) {
        try {
            Map wagons = container.lookupMap(Wagon.ROLE);
            this.registerWagons(wagons.keySet(), container);
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
    }

    @Override
    @Deprecated
    public void registerWagons(Collection wagons, PlexusContainer extensionContainer) {
    }

    private void configureWagon(Wagon wagon, ArtifactRepository repository) throws WagonConfigurationException {
        this.configureWagon(wagon, repository.getId());
    }

    private void configureWagon(Wagon wagon, String repositoryId) throws WagonConfigurationException {
        if (this.serverConfigurationMap.containsKey(repositoryId)) {
            BasicComponentConfigurator componentConfigurator = null;
            try {
                componentConfigurator = new BasicComponentConfigurator();
                componentConfigurator.configureComponent(wagon, this.serverConfigurationMap.get(repositoryId), this.container.getContainerRealm());
            }
            catch (ComponentConfigurationException e) {
                throw new WagonConfigurationException(repositoryId, "Unable to apply wagon configuration.", e);
            }
            finally {
                if (componentConfigurator != null) {
                    try {
                        this.container.release(componentConfigurator);
                    }
                    catch (ComponentLifecycleException e) {
                        this.getLogger().error("Problem releasing configurator - ignoring: " + e.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public void addConfiguration(String repositoryId, Xpp3Dom configuration) {
        if (repositoryId == null || configuration == null) {
            throw new IllegalArgumentException("arguments can't be null");
        }
        XmlPlexusConfiguration xmlConf = new XmlPlexusConfiguration(configuration);
        this.serverConfigurationMap.put(repositoryId, xmlConf);
    }

    @Override
    public void setDefaultRepositoryPermissions(RepositoryPermissions defaultRepositoryPermissions) {
        this.defaultRepositoryPermissions = defaultRepositoryPermissions;
    }

    @Override
    public void registerCredentialsDataSource(CredentialsDataSource cds) {
        this.credentialsDataSource = cds;
    }
}

