/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AbstractDICookie;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ActionsProviderListener;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;

public class StartActionProvider
extends ActionsProvider
implements Cancellable {
    private static final Logger logger = Logger.getLogger(StartActionProvider.class.getName());
    private static int jdiTrace;
    private JPDADebuggerImpl debuggerImpl;
    private ContextProvider lookupProvider;
    private Thread startingThread;
    private final Object startingThreadLock = new Object();

    public StartActionProvider(ContextProvider contextProvider) {
        this.debuggerImpl = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
        this.lookupProvider = contextProvider;
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_START);
    }

    public void doAction(Object object) {
        logger.fine("S StartActionProvider.doAction ()");
        JPDADebuggerImpl jPDADebuggerImpl = (JPDADebuggerImpl)((Object)this.lookupProvider.lookupFirst(null, JPDADebugger.class));
        if (jPDADebuggerImpl != null && jPDADebuggerImpl.getVirtualMachine() != null) {
            return;
        }
        logger.fine("S StartActionProvider.doAction () setStarting");
        this.debuggerImpl.setStarting();
        AbstractDICookie abstractDICookie = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
        this.doStartDebugger(abstractDICookie);
        logger.fine("S StartActionProvider.doAction () end");
    }

    public void postAction(Object object, final Runnable runnable) {
        logger.fine("S StartActionProvider.postAction ()");
        JPDADebuggerImpl jPDADebuggerImpl = (JPDADebuggerImpl)((Object)this.lookupProvider.lookupFirst(null, JPDADebugger.class));
        if (jPDADebuggerImpl != null && jPDADebuggerImpl.getVirtualMachine() != null) {
            runnable.run();
            return;
        }
        final AbstractDICookie abstractDICookie = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
        logger.fine("S StartActionProvider.postAction () setStarting");
        this.debuggerImpl.setStarting();
        logger.fine("S StartActionProvider.postAction () setStarting end");
        this.debuggerImpl.getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = StartActionProvider.this.startingThreadLock;
                synchronized (object) {
                    StartActionProvider.this.startingThread = Thread.currentThread();
                }
                try {
                    StartActionProvider.this.doStartDebugger(abstractDICookie);
                }
                finally {
                    object = StartActionProvider.this.startingThreadLock;
                    synchronized (object) {
                        StartActionProvider.this.startingThread = null;
                        StartActionProvider.this.startingThreadLock.notifyAll();
                    }
                    runnable.run();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartDebugger(AbstractDICookie abstractDICookie) {
        VirtualMachine virtualMachine;
        logger.fine("S StartActionProvider.doStartDebugger");
        Exception exception = null;
        try {
            this.debuggerImpl.setAttaching(abstractDICookie);
            virtualMachine = abstractDICookie.getVirtualMachine();
            this.debuggerImpl.setAttaching(null);
            VirtualMachineWrapper.setDebugTraceMode(virtualMachine, jdiTrace);
            Object object = new Object();
            Operator operator = this.createOperator(virtualMachine, object);
            Object object2 = object;
            synchronized (object2) {
                logger.fine("S StartActionProvider.doAction () - starting operator thread");
                operator.start();
                if (abstractDICookie instanceof ListeningDICookie) {
                    object.wait(1500L);
                }
            }
            this.debuggerImpl.setRunning(virtualMachine, operator);
            logger.fine("S StartActionProvider.doStartDebugger end: success");
        }
        catch (InterruptedException interruptedException) {
            exception = interruptedException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (Exception exception2) {
            exception = exception2;
            ErrorManager.getDefault().notify((Throwable)exception2);
        }
        if (exception != null) {
            logger.fine("S StartActionProvider.doAction ().thread end: exception " + exception);
            this.debuggerImpl.setException(exception);
            virtualMachine = (Session)this.lookupProvider.lookupFirst(null, Session.class);
            this.debuggerImpl.getRequestProcessor().post(new Runnable((Session)virtualMachine){
                final /* synthetic */ Session val$session;
                {
                    this.val$session = session;
                }

                @Override
                public void run() {
                    this.val$session.kill();
                }
            });
        }
    }

    public boolean isEnabled(Object object) {
        return true;
    }

    public void addActionsProviderListener(ActionsProviderListener actionsProviderListener) {
    }

    public void removeActionsProviderListener(ActionsProviderListener actionsProviderListener) {
    }

    private Operator createOperator(VirtualMachine virtualMachine, final Object object) {
        return new Operator(virtualMachine, this.debuggerImpl, new Executor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean exec(Event event) {
                Object object2 = object;
                synchronized (object2) {
                    object.notify();
                }
                return false;
            }

            @Override
            public void removed(EventRequest eventRequest) {
            }
        }, new Runnable(){

            @Override
            public void run() {
                StartActionProvider.this.debuggerImpl.finish();
            }
        }, this.debuggerImpl.accessLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        Object object = this.startingThreadLock;
        synchronized (object) {
            logger.fine("StartActionProvider.cancel(): startingThread = " + this.startingThread);
            for (int i = 0; i < 10; ++i) {
                if (this.startingThread != null) {
                    logger.fine("Interrupting " + this.startingThread);
                    this.startingThread.interrupt();
                    boolean bl = false;
                    try {
                        this.startingThreadLock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                    AbstractDICookie abstractDICookie = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
                    logger.fine("Listening cookie = " + abstractDICookie + ", is listening = " + (abstractDICookie instanceof ListeningDICookie));
                    if (abstractDICookie instanceof ListeningDICookie) {
                        ListeningDICookie listeningDICookie = (ListeningDICookie)abstractDICookie;
                        try {
                            listeningDICookie.getListeningConnector().stopListening(listeningDICookie.getArgs());
                        }
                        catch (IOException iOException) {
                        }
                        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
                            // empty catch block
                        }
                    }
                    if (!bl) continue;
                    return false;
                }
                return true;
            }
            return this.startingThread == null;
        }
    }

    static {
        if (System.getProperty("netbeans.debugger.jditrace") != null) {
            try {
                jdiTrace = Integer.parseInt(System.getProperty("netbeans.debugger.jditrace"));
            }
            catch (NumberFormatException numberFormatException) {
                jdiTrace = 0;
            }
        } else {
            jdiTrace = 0;
        }
    }
}

