# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.graph.image import Image

from elisa.plugins.poblesec.widgets.loadable_mixin import LoadableMixin

import pgm
from pgm.utils.image import cairo_gradient


# we must inherit from LoadableMixin first because of
# http://bugzilla.gnome.org/show_bug.cgi?id=554443
class ImageWithReflection(LoadableMixin, Widget):

    loading_attribute = 'image'

    def __init__(self):
        super(ImageWithReflection, self).__init__()

        self.image = Image()
        self.add(self.image)
        self.image.bg_a = 0
        self.image.layout = pgm.IMAGE_SCALED
        self.image.alignment = pgm.IMAGE_BOTTOM
        self.image.x, self.image.y = (0.0, 0.0)
        self.image.width, self.image.height = (1.0, 0.5)
        self.image.visible = True

        # reflection
        self.reflection = Image()
        self.add(self.reflection)
        flip_matrix = pgm.mat4x4_new_predefined(pgm.MAT4X4_FLIP_VERTICAL)
        self.reflection.mapping_matrix = flip_matrix
        self.reflection.bg_a = 0
        self.reflection.layout = pgm.IMAGE_SCALED
        self.reflection.alignment = pgm.IMAGE_TOP
        self.reflection.x, self.reflection.y = (0.0, 0.5)
        self.reflection.width, self.reflection.height = (1.0, 0.2)
        self.reflection.opacity = 50
        self.reflection.visible = True

    def set_from_file(self, image_path):
        self.image.set_from_file(image_path)
        # FIXME: deactivated because of Python Cairo bindings not releasing
        # the GIL thus locking Pigment's rendering thread when the viewport
        # update-pass signal is emitted
        #cairo_gradient(image_path, self.reflection, 0.4)

    def clear(self):
        self.image.clear()
        self.reflection.clear()
