/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyAnySerializer
extends StdSerializer<RubyObject> {
    public static final RubyAnySerializer instance = new RubyAnySerializer();
    private static final HashMap<Class, Class> class_maps = new HashMap();

    public RubyAnySerializer() {
        super(RubyObject.class);
    }

    private Class<?> rubyJavaClassLookup(Class target) {
        Class val = class_maps.get(target);
        if (val == null) {
            return Object.class;
        }
        return val;
    }

    private void serializeUnknownRubyObject(RubyObject rubyObject, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        ThreadContext ctx = rubyObject.getRuntime().getCurrentContext();
        RubyClass meta = rubyObject.getMetaClass();
        DynamicMethod method = meta.searchMethod("to_time");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, (IRubyObject)rubyObject, (RubyModule)meta, "to_time");
            provider.defaultSerializeValue(obj, jgen);
            return;
        }
        method = meta.searchMethod("to_h");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, (IRubyObject)rubyObject, (RubyModule)meta, "to_h");
            provider.findTypedValueSerializer(Map.class, true, null).serialize(obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_hash");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, (IRubyObject)rubyObject, (RubyModule)meta, "to_hash");
            provider.findTypedValueSerializer(Map.class, true, null).serialize(obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_a");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, (IRubyObject)rubyObject, (RubyModule)meta, "to_a");
            provider.findTypedValueSerializer(List.class, true, null).serialize(obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_json");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, (IRubyObject)rubyObject, (RubyModule)meta, "to_json");
            if (obj instanceof RubyString) {
                jgen.writeRawValue(obj.toString());
            } else {
                provider.defaultSerializeValue(obj, jgen);
            }
            return;
        }
        throw new JsonGenerationException("Cannot find Serializer for class: " + rubyObject.getClass().getName());
    }

    @Override
    public void serialize(RubyObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (value instanceof RubySymbol || value instanceof RubyString) {
            jgen.writeString(value.toString());
        } else if (value instanceof RubyHash) {
            provider.findTypedValueSerializer(Map.class, true, null).serialize(value, jgen, provider);
        } else if (value instanceof RubyArray) {
            provider.findTypedValueSerializer(List.class, true, null).serialize(value, jgen, provider);
        } else {
            Object val = value.toJava(this.rubyJavaClassLookup(value.getClass()));
            if (val instanceof RubyObject) {
                this.serializeUnknownRubyObject((RubyObject)val, jgen, provider);
            } else {
                provider.defaultSerializeValue(val, jgen);
            }
        }
    }

    @Override
    public void serializeWithType(RubyObject value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForScalar(value, jgen);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar(value, jgen);
    }

    static {
        class_maps.put(RubyBoolean.class, Boolean.class);
    }
}

