/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.asm.ClassWriter;
import com.fasterxml.jackson.module.afterburner.asm.Label;
import com.fasterxml.jackson.module.afterburner.asm.MethodVisitor;
import com.fasterxml.jackson.module.afterburner.asm.Type;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.IntFieldPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.IntMethodPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.LongFieldPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.LongMethodPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.ObjectFieldPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.ObjectMethodPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.StringFieldPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.StringMethodPropertyWriter;
import com.fasterxml.jackson.module.afterburner.util.DynamicPropertyAccessorBase;
import com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class PropertyAccessorCollector
extends DynamicPropertyAccessorBase {
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private final ArrayList<IntMethodPropertyWriter> _intGetters = new ArrayList();
    private final ArrayList<LongMethodPropertyWriter> _longGetters = new ArrayList();
    private final ArrayList<StringMethodPropertyWriter> _stringGetters = new ArrayList();
    private final ArrayList<ObjectMethodPropertyWriter> _objectGetters = new ArrayList();
    private final ArrayList<IntFieldPropertyWriter> _intFields = new ArrayList();
    private final ArrayList<LongFieldPropertyWriter> _longFields = new ArrayList();
    private final ArrayList<StringFieldPropertyWriter> _stringFields = new ArrayList();
    private final ArrayList<ObjectFieldPropertyWriter> _objectFields = new ArrayList();
    private final Class<?> beanClass;
    private final String beanClassName;

    public PropertyAccessorCollector(Class<?> clazz) {
        this.beanClass = clazz;
        this.beanClassName = Type.getInternalName(clazz);
    }

    public IntMethodPropertyWriter addIntGetter(BeanPropertyWriter beanPropertyWriter) {
        return this._add(this._intGetters, new IntMethodPropertyWriter(beanPropertyWriter, null, this._intGetters.size(), null));
    }

    public LongMethodPropertyWriter addLongGetter(BeanPropertyWriter beanPropertyWriter) {
        return this._add(this._longGetters, new LongMethodPropertyWriter(beanPropertyWriter, null, this._longGetters.size(), null));
    }

    public StringMethodPropertyWriter addStringGetter(BeanPropertyWriter beanPropertyWriter) {
        return this._add(this._stringGetters, new StringMethodPropertyWriter(beanPropertyWriter, null, this._stringGetters.size(), null));
    }

    public ObjectMethodPropertyWriter addObjectGetter(BeanPropertyWriter beanPropertyWriter) {
        return this._add(this._objectGetters, new ObjectMethodPropertyWriter(beanPropertyWriter, null, this._objectGetters.size(), null));
    }

    public IntFieldPropertyWriter addIntField(BeanPropertyWriter beanPropertyWriter) {
        return this._add(this._intFields, new IntFieldPropertyWriter(beanPropertyWriter, null, this._intFields.size(), null));
    }

    public LongFieldPropertyWriter addLongField(BeanPropertyWriter beanPropertyWriter) {
        return this._add(this._longFields, new LongFieldPropertyWriter(beanPropertyWriter, null, this._longFields.size(), null));
    }

    public StringFieldPropertyWriter addStringField(BeanPropertyWriter beanPropertyWriter) {
        return this._add(this._stringFields, new StringFieldPropertyWriter(beanPropertyWriter, null, this._stringFields.size(), null));
    }

    public ObjectFieldPropertyWriter addObjectField(BeanPropertyWriter beanPropertyWriter) {
        return this._add(this._objectFields, new ObjectFieldPropertyWriter(beanPropertyWriter, null, this._objectFields.size(), null));
    }

    public boolean isEmpty() {
        return this._intGetters.isEmpty() && this._longGetters.isEmpty() && this._stringGetters.isEmpty() && this._objectGetters.isEmpty() && this._intFields.isEmpty() && this._longFields.isEmpty() && this._stringFields.isEmpty() && this._objectFields.isEmpty();
    }

    public BeanPropertyAccessor findAccessor(MyClassLoader myClassLoader) {
        if (myClassLoader == null) {
            myClassLoader = new MyClassLoader(this.beanClass.getClassLoader(), true);
        }
        String string = this.beanClass.getName() + "$Access4JacksonSerializer";
        String string2 = PropertyAccessorCollector.internalClassName(string);
        Class<?> clazz = null;
        try {
            clazz = myClassLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = this.generateAccessorClass(myClassLoader, string, string2);
        }
        try {
            return (BeanPropertyAccessor)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to generate accessor class '" + string + "': " + exception.getMessage(), exception);
        }
    }

    public Class<?> generateAccessorClass(MyClassLoader myClassLoader, String string, String string2) {
        ClassWriter classWriter = new ClassWriter(1);
        String string3 = PropertyAccessorCollector.internalClassName(BeanPropertyAccessor.class.getName());
        classWriter.visit(49, 33, string2, null, string3, null);
        classWriter.visitSource(string + ".java", null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, string3, "<init>", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        if (!this._intFields.isEmpty()) {
            this._addFields(classWriter, this._intFields, "intField", Type.INT_TYPE, 172);
        }
        if (!this._longFields.isEmpty()) {
            this._addFields(classWriter, this._longFields, "longField", Type.LONG_TYPE, 173);
        }
        if (!this._stringFields.isEmpty()) {
            this._addFields(classWriter, this._stringFields, "stringField", STRING_TYPE, 176);
        }
        if (!this._objectFields.isEmpty()) {
            this._addFields(classWriter, this._objectFields, "objectField", OBJECT_TYPE, 176);
        }
        if (!this._intGetters.isEmpty()) {
            this._addGetters(classWriter, this._intGetters, "intGetter", Type.INT_TYPE, 172);
        }
        if (!this._longGetters.isEmpty()) {
            this._addGetters(classWriter, this._longGetters, "longGetter", Type.LONG_TYPE, 173);
        }
        if (!this._stringGetters.isEmpty()) {
            this._addGetters(classWriter, this._stringGetters, "stringGetter", STRING_TYPE, 176);
        }
        if (!this._objectGetters.isEmpty()) {
            this._addGetters(classWriter, this._objectGetters, "objectGetter", OBJECT_TYPE, 176);
        }
        classWriter.visitEnd();
        byte[] byArray = classWriter.toByteArray();
        return myClassLoader.loadAndResolve(string, byArray);
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addGetters(ClassWriter classWriter, List<T> list, String string, Type type, int n) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string, "(Ljava/lang/Object;I)" + type, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, this.beanClassName);
        methodVisitor.visitVarInsn(58, 3);
        if (list.size() <= 4) {
            this._addGettersUsingIf(methodVisitor, list, n, ALL_INT_CONSTS);
        } else {
            this._addGettersUsingSwitch(methodVisitor, list, n);
        }
        PropertyAccessorCollector.generateException(methodVisitor, this.beanClassName, list.size());
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addFields(ClassWriter classWriter, List<T> list, String string, Type type, int n) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string, "(Ljava/lang/Object;I)" + type, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, this.beanClassName);
        methodVisitor.visitVarInsn(58, 3);
        if (list.size() < 4) {
            this._addFieldsUsingIf(methodVisitor, list, n, ALL_INT_CONSTS);
        } else {
            this._addFieldsUsingSwitch(methodVisitor, list, n);
        }
        PropertyAccessorCollector.generateException(methodVisitor, this.beanClassName, list.size());
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addGettersUsingIf(MethodVisitor methodVisitor, List<T> list, int n, int[] nArray) {
        methodVisitor.visitVarInsn(21, 2);
        Label label = new Label();
        methodVisitor.visitJumpInsn(154, label);
        methodVisitor.visitVarInsn(25, 3);
        int n2 = this.beanClass.isInterface() ? 185 : 182;
        Method method = (Method)((OptimizedBeanPropertyWriter)list.get(0)).getMember().getMember();
        methodVisitor.visitMethodInsn(n2, this.beanClassName, method.getName(), Type.getMethodDescriptor(method));
        methodVisitor.visitInsn(n);
        int n3 = list.size();
        for (int i = 1; i < n3; ++i) {
            methodVisitor.visitLabel(label);
            label = new Label();
            methodVisitor.visitVarInsn(21, 2);
            methodVisitor.visitInsn(nArray[i]);
            methodVisitor.visitJumpInsn(160, label);
            methodVisitor.visitVarInsn(25, 3);
            method = (Method)((OptimizedBeanPropertyWriter)list.get(i)).getMember().getMember();
            methodVisitor.visitMethodInsn(n2, this.beanClassName, method.getName(), Type.getMethodDescriptor(method));
            methodVisitor.visitInsn(n);
        }
        methodVisitor.visitLabel(label);
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addGettersUsingSwitch(MethodVisitor methodVisitor, List<T> list, int n) {
        methodVisitor.visitVarInsn(21, 2);
        Label[] labelArray = new Label[list.size()];
        int n2 = labelArray.length;
        for (int i = 0; i < n2; ++i) {
            labelArray[i] = new Label();
        }
        Label label = new Label();
        methodVisitor.visitTableSwitchInsn(0, labelArray.length - 1, label, labelArray);
        n2 = this.beanClass.isInterface() ? 185 : 182;
        int n3 = labelArray.length;
        for (int i = 0; i < n3; ++i) {
            methodVisitor.visitLabel(labelArray[i]);
            methodVisitor.visitVarInsn(25, 3);
            Method method = (Method)((OptimizedBeanPropertyWriter)list.get(i)).getMember().getMember();
            methodVisitor.visitMethodInsn(n2, this.beanClassName, method.getName(), Type.getMethodDescriptor(method));
            methodVisitor.visitInsn(n);
        }
        methodVisitor.visitLabel(label);
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addFieldsUsingIf(MethodVisitor methodVisitor, List<T> list, int n, int[] nArray) {
        methodVisitor.visitVarInsn(21, 2);
        Label label = new Label();
        methodVisitor.visitJumpInsn(154, label);
        methodVisitor.visitVarInsn(25, 3);
        AnnotatedField annotatedField = (AnnotatedField)((OptimizedBeanPropertyWriter)list.get(0)).getMember();
        methodVisitor.visitFieldInsn(180, this.beanClassName, annotatedField.getName(), Type.getDescriptor(annotatedField.getRawType()));
        methodVisitor.visitInsn(n);
        int n2 = list.size();
        for (int i = 1; i < n2; ++i) {
            methodVisitor.visitLabel(label);
            label = new Label();
            methodVisitor.visitVarInsn(21, 2);
            methodVisitor.visitInsn(nArray[i]);
            methodVisitor.visitJumpInsn(160, label);
            methodVisitor.visitVarInsn(25, 3);
            annotatedField = (AnnotatedField)((OptimizedBeanPropertyWriter)list.get(i)).getMember();
            methodVisitor.visitFieldInsn(180, this.beanClassName, annotatedField.getName(), Type.getDescriptor(annotatedField.getRawType()));
            methodVisitor.visitInsn(n);
        }
        methodVisitor.visitLabel(label);
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addFieldsUsingSwitch(MethodVisitor methodVisitor, List<T> list, int n) {
        methodVisitor.visitVarInsn(21, 2);
        Label[] labelArray = new Label[list.size()];
        int n2 = labelArray.length;
        for (int i = 0; i < n2; ++i) {
            labelArray[i] = new Label();
        }
        Label label = new Label();
        methodVisitor.visitTableSwitchInsn(0, labelArray.length - 1, label, labelArray);
        int n3 = labelArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            methodVisitor.visitLabel(labelArray[n2]);
            methodVisitor.visitVarInsn(25, 3);
            AnnotatedField annotatedField = (AnnotatedField)((OptimizedBeanPropertyWriter)list.get(n2)).getMember();
            methodVisitor.visitFieldInsn(180, this.beanClassName, annotatedField.getName(), Type.getDescriptor(annotatedField.getRawType()));
            methodVisitor.visitInsn(n);
        }
        methodVisitor.visitLabel(label);
    }
}

