/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public class ObjectFieldPropertyWriter
extends OptimizedBeanPropertyWriter<ObjectFieldPropertyWriter> {
    public ObjectFieldPropertyWriter(BeanPropertyWriter beanPropertyWriter, BeanPropertyAccessor beanPropertyAccessor, int n, JsonSerializer<Object> jsonSerializer) {
        super(beanPropertyWriter, beanPropertyAccessor, n, jsonSerializer);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> jsonSerializer) {
        return new ObjectFieldPropertyWriter(this, this._propertyAccessor, this._propertyIndex, jsonSerializer);
    }

    @Override
    public ObjectFieldPropertyWriter withAccessor(BeanPropertyAccessor beanPropertyAccessor) {
        if (beanPropertyAccessor == null) {
            throw new IllegalArgumentException();
        }
        return new ObjectFieldPropertyWriter(this, beanPropertyAccessor, this._propertyIndex, this._serializer);
    }

    @Override
    public final void unsafeSerializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        Class<?> clazz;
        PropertySerializerMap propertySerializerMap;
        Object object2 = this._propertyAccessor.objectField(object, this._propertyIndex);
        if (object2 == null) {
            if (!this._suppressNulls) {
                jsonGenerator.writeFieldName(this._name);
                serializerProvider.defaultSerializeNull(jsonGenerator);
            }
            return;
        }
        if (this._suppressableValue != null && this._suppressableValue.equals(object2)) {
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._serializer;
        if (jsonSerializer == null && (jsonSerializer = (propertySerializerMap = this._dynamicSerializers).serializerFor(clazz = object2.getClass())) == null) {
            jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
        }
        jsonGenerator.writeFieldName(this._name);
        if (this._typeSerializer == null) {
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
        } else {
            jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, this._typeSerializer);
        }
    }
}

