/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SuperSonicBeanDeserializer
extends BeanDeserializer {
    private static final long serialVersionUID = -8468272764223072933L;
    protected final SerializedString[] _orderedPropertyNames;
    protected SettableBeanProperty[] _orderedProperties;

    public SuperSonicBeanDeserializer(BeanDeserializer beanDeserializer, List<SettableBeanProperty> list) {
        super(beanDeserializer);
        int n = list.size();
        this._orderedPropertyNames = new SerializedString[n];
        for (int i = 0; i < n; ++i) {
            this._orderedPropertyNames[i] = new SerializedString(list.get(i).getName());
        }
    }

    protected SuperSonicBeanDeserializer(SuperSonicBeanDeserializer superSonicBeanDeserializer, NameTransformer nameTransformer) {
        super((BeanDeserializerBase)superSonicBeanDeserializer, nameTransformer);
        this._orderedProperties = superSonicBeanDeserializer._orderedProperties;
        this._orderedPropertyNames = superSonicBeanDeserializer._orderedPropertyNames;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        return new SuperSonicBeanDeserializer(this, nameTransformer);
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        SettableBeanProperty settableBeanProperty;
        int n;
        super.resolve(deserializationContext);
        int n2 = this._orderedPropertyNames.length;
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(n2);
        for (n = 0; n < n2 && (settableBeanProperty = this._beanProperties.find(this._orderedPropertyNames[n].toString())) != null; ++n) {
            arrayList.add(settableBeanProperty);
        }
        if (n == 0) {
            throw new IllegalStateException("Afterburner internal error: BeanDeserializer for " + this._beanType + " has no properties that match expected ordering -- can not create optimized deserializer");
        }
        this._orderedProperties = arrayList.toArray(new SettableBeanProperty[arrayList.size()]);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (!this._vanillaProcessing || this._objectIdReader != null) {
            return super.deserialize(jsonParser, deserializationContext);
        }
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken != JsonToken.START_OBJECT) {
            return this._deserializeOther(jsonParser, deserializationContext, jsonToken);
        }
        jsonToken = jsonParser.nextToken();
        return this.deserializeFromObject(jsonParser, deserializationContext);
    }

    @Override
    public final Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        if (this._unwrappedPropertyHandler != null) {
            return this.deserializeWithUnwrapped(jsonParser, deserializationContext, object);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(jsonParser, deserializationContext, object);
        }
        JsonToken jsonToken = jsonParser.getCurrentToken();
        SettableBeanProperty settableBeanProperty = this._orderedProperties[0];
        if (jsonToken == JsonToken.START_OBJECT) {
            if (!jsonParser.nextFieldName(this._orderedPropertyNames[0])) {
                return super.deserialize(jsonParser, deserializationContext, object);
            }
            jsonToken = jsonParser.nextToken();
        } else if (jsonToken != JsonToken.FIELD_NAME || !settableBeanProperty.getName().equals(jsonParser.getCurrentName())) {
            return super.deserialize(jsonParser, deserializationContext, object);
        }
        jsonParser.nextToken();
        try {
            settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
        }
        catch (Exception exception) {
            this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
        }
        int n = this._orderedProperties.length;
        for (int i = 1; i < n; ++i) {
            settableBeanProperty = this._orderedProperties[i];
            if (!jsonParser.nextFieldName(this._orderedPropertyNames[i])) {
                if (jsonParser.getCurrentToken() == JsonToken.END_OBJECT) {
                    return object;
                }
                return super.deserialize(jsonParser, deserializationContext, object);
            }
            jsonParser.nextToken();
            try {
                settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                continue;
            }
            catch (Exception exception) {
                this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
            }
        }
        if (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            return super.deserialize(jsonParser, deserializationContext, object);
        }
        return object;
    }

    @Override
    public final Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(jsonParser, deserializationContext);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(jsonParser, deserializationContext);
            }
            return this.deserializeFromObjectUsingNonDefault(jsonParser, deserializationContext);
        }
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        JsonToken jsonToken = jsonParser.getCurrentToken();
        SettableBeanProperty settableBeanProperty = this._orderedProperties[0];
        if (jsonToken == JsonToken.START_OBJECT) {
            if (!jsonParser.nextFieldName(this._orderedPropertyNames[0])) {
                return super.deserialize(jsonParser, deserializationContext, object);
            }
            jsonToken = jsonParser.nextToken();
        } else if (jsonToken != JsonToken.FIELD_NAME || !settableBeanProperty.getName().equals(jsonParser.getCurrentName())) {
            return super.deserialize(jsonParser, deserializationContext, object);
        }
        jsonParser.nextToken();
        try {
            settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
        }
        catch (Exception exception) {
            this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
        }
        int n = this._orderedProperties.length;
        for (int i = 1; i < n; ++i) {
            settableBeanProperty = this._orderedProperties[i];
            if (!jsonParser.nextFieldName(this._orderedPropertyNames[i])) {
                if (jsonParser.getCurrentToken() == JsonToken.END_OBJECT) {
                    return object;
                }
                return super.deserialize(jsonParser, deserializationContext, object);
            }
            jsonParser.nextToken();
            try {
                settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                continue;
            }
            catch (Exception exception) {
                this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
            }
        }
        if (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            return super.deserialize(jsonParser, deserializationContext, object);
        }
        return object;
    }
}

