/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormat;
import org.elasticsearch.search.internal.SearchContext;

public class ValuesSourceParser<VS extends ValuesSource> {
    private final String aggName;
    private final InternalAggregation.Type aggType;
    private final SearchContext context;
    private final Class<VS> valuesSourceType;
    private boolean scriptable = true;
    private boolean formattable = false;
    private ValueType targetValueType = null;
    private boolean requiresSortedValues = false;
    private boolean requiresUniqueValues = false;
    private Input input = new Input();

    public static Builder any(String aggName, InternalAggregation.Type aggType, SearchContext context) {
        return new Builder(aggName, aggType, context, ValuesSource.class);
    }

    public static Builder<ValuesSource.Numeric> numeric(String aggName, InternalAggregation.Type aggType, SearchContext context) {
        return new Builder(aggName, aggType, context, ValuesSource.Numeric.class).targetValueType(ValueType.NUMERIC);
    }

    public static Builder<ValuesSource.Bytes> bytes(String aggName, InternalAggregation.Type aggType, SearchContext context) {
        return new Builder(aggName, aggType, context, ValuesSource.Bytes.class).targetValueType(ValueType.STRING);
    }

    public static Builder<ValuesSource.GeoPoint> geoPoint(String aggName, InternalAggregation.Type aggType, SearchContext context) {
        return new Builder(aggName, aggType, context, ValuesSource.GeoPoint.class).targetValueType(ValueType.GEOPOINT).scriptable(false);
    }

    private ValuesSourceParser(String aggName, InternalAggregation.Type aggType, SearchContext context, Class<VS> valuesSourceType) {
        this.aggName = aggName;
        this.aggType = aggType;
        this.context = context;
        this.valuesSourceType = valuesSourceType;
    }

    public boolean token(String currentFieldName, XContentParser.Token token, XContentParser parser) throws IOException {
        if (token == XContentParser.Token.VALUE_STRING) {
            if ("field".equals(currentFieldName)) {
                this.input.field = parser.text();
            } else if (this.formattable && "format".equals(currentFieldName)) {
                this.input.format = parser.text();
            } else {
                if (this.scriptable) {
                    if ("script".equals(currentFieldName)) {
                        this.input.script = parser.text();
                        this.input.scriptType = ScriptService.ScriptType.INLINE;
                    } else if ("script_id".equals(currentFieldName)) {
                        this.input.script = parser.text();
                        this.input.scriptType = ScriptService.ScriptType.INDEXED;
                    } else if ("script_file".equals(currentFieldName)) {
                        this.input.script = parser.text();
                        this.input.scriptType = ScriptService.ScriptType.FILE;
                    } else if ("lang".equals(currentFieldName)) {
                        this.input.lang = parser.text();
                    } else if ("value_type".equals(currentFieldName) || "valueType".equals(currentFieldName)) {
                        this.input.valueType = ValueType.resolveForScript(parser.text());
                        if (this.targetValueType != null && this.input.valueType.isNotA(this.targetValueType)) {
                            throw new SearchParseException(this.context, this.aggType.name() + " aggregation [" + this.aggName + "] was configured with an incompatible value type [" + (Object)((Object)this.input.valueType) + "]. [" + this.aggType + "] aggregation can only work on value of type [" + (Object)((Object)this.targetValueType) + "]");
                        }
                    } else {
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
        if (this.scriptable && token == XContentParser.Token.START_OBJECT) {
            if ("params".equals(currentFieldName)) {
                this.input.params = parser.map();
                return true;
            }
            return false;
        }
        return false;
    }

    public ValuesSourceConfig<VS> config() {
        ValueType valueType;
        ValueType valueType2 = valueType = this.input.valueType != null ? this.input.valueType : this.targetValueType;
        if (this.input.field == null) {
            Class<ValuesSource> valuesSourceType;
            if (this.input.script == null) {
                return new ValuesSourceConfig<ValuesSource>(ValuesSource.class);
            }
            Class<ValuesSource> clazz = valuesSourceType = valueType != null ? valueType.getValuesSourceType() : this.valuesSourceType;
            if (valuesSourceType == null || valuesSourceType == ValuesSource.class) {
                valuesSourceType = ValuesSource.Bytes.class;
            }
            ValuesSourceConfig<? extends ValuesSource> config = new ValuesSourceConfig<ValuesSource>(valuesSourceType);
            config.format = ValuesSourceParser.resolveFormat(this.input.format, valueType);
            config.script = this.createScript();
            config.scriptValueType = valueType;
            return config;
        }
        FieldMapper mapper = this.context.smartNameFieldMapper(this.input.field);
        if (mapper == null) {
            Class<ValuesSource> valuesSourceType = valueType != null ? valueType.getValuesSourceType() : this.valuesSourceType;
            ValuesSourceConfig<? extends ValuesSource> config = new ValuesSourceConfig<ValuesSource>(valuesSourceType);
            config.format = ValuesSourceParser.resolveFormat(this.input.format, valueType);
            config.unmapped = true;
            if (valueType != null) {
                config.scriptValueType = valueType;
            }
            return config;
        }
        Object indexFieldData = this.context.fieldData().getForField(mapper);
        ValuesSourceConfig<Object> config = this.valuesSourceType == ValuesSource.class ? (indexFieldData instanceof IndexNumericFieldData ? new ValuesSourceConfig<ValuesSource.Numeric>(ValuesSource.Numeric.class) : (indexFieldData instanceof IndexGeoPointFieldData ? new ValuesSourceConfig<ValuesSource.GeoPoint>(ValuesSource.GeoPoint.class) : new ValuesSourceConfig<ValuesSource.Bytes>(ValuesSource.Bytes.class))) : new ValuesSourceConfig<VS>(this.valuesSourceType);
        config.fieldContext = new FieldContext(this.input.field, (IndexFieldData<?>)indexFieldData, mapper);
        config.script = this.createScript();
        config.format = ValuesSourceParser.resolveFormat(this.input.format, mapper);
        return config;
    }

    private SearchScript createScript() {
        return this.input.script == null ? null : this.context.scriptService().search(this.context.lookup(), this.input.lang, this.input.script, this.input.scriptType, this.input.params);
    }

    private static ValueFormat resolveFormat(@Nullable String format, @Nullable ValueType valueType) {
        if (valueType == null) {
            return null;
        }
        ValueFormat valueFormat = valueType.defaultFormat;
        if (valueFormat != null && valueFormat instanceof ValueFormat.Patternable && format != null) {
            return ((ValueFormat.Patternable)valueFormat).create(format);
        }
        return valueFormat;
    }

    private static ValueFormat resolveFormat(@Nullable String format, FieldMapper mapper) {
        if (mapper instanceof DateFieldMapper) {
            return format != null ? ValueFormat.DateTime.format(format) : ValueFormat.DateTime.mapper((DateFieldMapper)mapper);
        }
        if (mapper instanceof IpFieldMapper) {
            return ValueFormat.IPv4;
        }
        if (mapper instanceof NumberFieldMapper) {
            return format != null ? ValueFormat.Number.format(format) : ValueFormat.RAW;
        }
        return null;
    }

    public static class Builder<VS extends ValuesSource> {
        private final ValuesSourceParser<VS> parser;

        private Builder(String aggName, InternalAggregation.Type aggType, SearchContext context, Class<VS> valuesSourceType) {
            this.parser = new ValuesSourceParser(aggName, aggType, context, valuesSourceType);
        }

        public Builder<VS> scriptable(boolean scriptable) {
            ((ValuesSourceParser)this.parser).scriptable = scriptable;
            return this;
        }

        public Builder<VS> formattable(boolean formattable) {
            ((ValuesSourceParser)this.parser).formattable = formattable;
            return this;
        }

        public Builder<VS> targetValueType(ValueType valueType) {
            ((ValuesSourceParser)this.parser).targetValueType = valueType;
            return this;
        }

        public ValuesSourceParser<VS> build() {
            return this.parser;
        }
    }

    private static class Input {
        String field = null;
        String script = null;
        ScriptService.ScriptType scriptType = null;
        String lang = null;
        Map<String, Object> params = null;
        ValueType valueType = null;
        String format = null;

        private Input() {
        }
    }
}

