/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.recovery.RecoveryState;

public class RecoveryStatus {
    final ShardId shardId;
    final long recoveryId;
    final InternalIndexShard indexShard;
    final RecoveryState recoveryState;
    final DiscoveryNode sourceNode;
    volatile Thread recoveryThread;
    private volatile boolean canceled;
    volatile boolean sentCanceledToSource;
    private volatile ConcurrentMap<String, IndexOutput> openIndexOutputs = ConcurrentCollections.newConcurrentMap();
    public final Store.LegacyChecksums legacyChecksums = new Store.LegacyChecksums();

    public RecoveryStatus(long recoveryId, InternalIndexShard indexShard, DiscoveryNode sourceNode) {
        this.recoveryId = recoveryId;
        this.indexShard = indexShard;
        this.sourceNode = sourceNode;
        this.shardId = indexShard.shardId();
        this.recoveryState = new RecoveryState(this.shardId);
        this.recoveryState.getTimer().startTime(System.currentTimeMillis());
    }

    public DiscoveryNode sourceNode() {
        return this.sourceNode;
    }

    public RecoveryState recoveryState() {
        return this.recoveryState;
    }

    public void stage(RecoveryState.Stage stage) {
        this.recoveryState.setStage(stage);
    }

    public RecoveryState.Stage stage() {
        return this.recoveryState.getStage();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public synchronized void cancel() {
        this.canceled = true;
    }

    public IndexOutput getOpenIndexOutput(String key) {
        ConcurrentMap<String, IndexOutput> outputs = this.openIndexOutputs;
        if (this.canceled || outputs == null) {
            return null;
        }
        return (IndexOutput)outputs.get(key);
    }

    public synchronized Set<Map.Entry<String, IndexOutput>> cancelAndClearOpenIndexInputs() {
        this.cancel();
        ConcurrentMap<String, IndexOutput> outputs = this.openIndexOutputs;
        this.openIndexOutputs = null;
        if (outputs == null) {
            return null;
        }
        Set<Map.Entry<String, IndexOutput>> entrySet = outputs.entrySet();
        return entrySet;
    }

    public IndexOutput removeOpenIndexOutputs(String name) {
        ConcurrentMap<String, IndexOutput> outputs = this.openIndexOutputs;
        if (outputs == null) {
            return null;
        }
        return (IndexOutput)outputs.remove(name);
    }

    public synchronized IndexOutput openAndPutIndexOutput(String key, String fileName, StoreFileMetaData metaData, Store store) throws IOException {
        if (this.isCanceled()) {
            return null;
        }
        ConcurrentMap<String, IndexOutput> outputs = this.openIndexOutputs;
        IndexOutput indexOutput = store.createVerifyingOutput(fileName, IOContext.DEFAULT, metaData);
        outputs.put(key, indexOutput);
        return indexOutput;
    }
}

