/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.geo.GeoPolygonFilter;

public class GeoPolygonFilterParser
implements FilterParser {
    public static final String NAME = "geo_polygon";
    public static final String POINTS = "points";

    @Inject
    public GeoPolygonFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "geoPolygon"};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        MapperService.SmartNameFieldMappers smartMappers;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String fieldName = null;
        ArrayList<GeoPoint> shell = Lists.newArrayList();
        boolean normalizeLon = true;
        boolean normalizeLat = true;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if (POINTS.equals(currentFieldName)) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                shell.add(GeoUtils.parseGeoPoint(parser));
                            }
                            continue;
                        }
                        throw new QueryParsingException(parseContext.index(), "[geo_polygon] filter does not support [" + currentFieldName + "]");
                    }
                    throw new QueryParsingException(parseContext.index(), "[geo_polygon] filter does not support token type [" + token.name() + "] under [" + currentFieldName + "]");
                }
                continue;
            }
            if (token.isValue()) {
                if ("_name".equals(currentFieldName)) {
                    filterName = parser.text();
                    continue;
                }
                if ("_cache".equals(currentFieldName)) {
                    cache = parser.booleanValue();
                    continue;
                }
                if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                    cacheKey = new CacheKeyFilter.Key(parser.text());
                    continue;
                }
                if ("normalize".equals(currentFieldName)) {
                    normalizeLat = parser.booleanValue();
                    normalizeLon = parser.booleanValue();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[geo_polygon] filter does not support [" + currentFieldName + "]");
            }
            throw new QueryParsingException(parseContext.index(), "[geo_polygon] unexpected token type [" + token.name() + "]");
        }
        if (shell.isEmpty()) {
            throw new QueryParsingException(parseContext.index(), "no points defined for geo_polygon filter");
        }
        if (shell.size() < 3) {
            throw new QueryParsingException(parseContext.index(), "to few points defined for geo_polygon filter");
        }
        GeoPoint start = (GeoPoint)shell.get(0);
        if (!start.equals(shell.get(shell.size() - 1))) {
            shell.add(start);
        }
        if (shell.size() < 4) {
            throw new QueryParsingException(parseContext.index(), "to few points defined for geo_polygon filter");
        }
        if (normalizeLat || normalizeLon) {
            for (GeoPoint point : shell) {
                GeoUtils.normalizePoint(point, normalizeLat, normalizeLon);
            }
        }
        if ((smartMappers = parseContext.smartFieldMappers(fieldName)) == null || !smartMappers.hasMapper()) {
            throw new QueryParsingException(parseContext.index(), "failed to find geo_point field [" + fieldName + "]");
        }
        FieldMapper mapper = smartMappers.mapper();
        if (!(mapper instanceof GeoPointFieldMapper)) {
            throw new QueryParsingException(parseContext.index(), "field [" + fieldName + "] is not a geo_point field");
        }
        IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)parseContext.getForField(mapper);
        GeoPolygonFilter filter = new GeoPolygonFilter(indexFieldData, shell.toArray(new GeoPoint[shell.size()]));
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, smartMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

