/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.ImmutableSortedSet;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.RamAccountingTermsEnum;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildFilteredTermsEnum;
import org.elasticsearch.index.fielddata.plain.ParentChildIntersectTermsEnum;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentTypeListener;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public class ParentChildIndexFieldData
extends AbstractIndexFieldData<AtomicParentChildFieldData>
implements IndexParentChildFieldData,
DocumentTypeListener {
    private final NavigableSet<BytesRef> parentTypes;
    private final CircuitBreakerService breakerService;
    private final Object lock = new Object();

    public ParentChildIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, MapperService mapperService, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.parentTypes = new TreeSet<BytesRef>(BytesRef.getUTF8SortedAsUnicodeComparator());
        this.breakerService = breakerService;
        for (DocumentMapper documentMapper : mapperService.docMappers(false)) {
            this.beforeCreate(documentMapper);
        }
        mapperService.addTypeListener(this);
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParentChildAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        ImmutableSortedSet<BytesRef> parentTypes;
        AtomicReader reader = context.reader();
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        Object object = this.lock;
        synchronized (object) {
            parentTypes = ImmutableSortedSet.copyOf(BytesRef.getUTF8SortedAsUnicodeComparator(), this.parentTypes);
        }
        boolean success = false;
        ParentChildAtomicFieldData data = null;
        ParentChildFilteredTermsEnum termsEnum = new ParentChildFilteredTermsEnum(new ParentChildIntersectTermsEnum(reader, "_uid", "_parent"), parentTypes);
        ParentChildEstimator estimator = new ParentChildEstimator(this.breakerService.getBreaker(CircuitBreaker.Name.FIELDDATA), (TermsEnum)termsEnum);
        TermsEnum estimatedTermsEnum = estimator.beforeLoad(null);
        ObjectObjectOpenHashMap<String, TypeBuilder> typeBuilders = ObjectObjectOpenHashMap.newInstance();
        try {
            try {
                DocsEnum docsEnum = null;
                BytesRef term = estimatedTermsEnum.next();
                while (term != null) {
                    String type = termsEnum.type();
                    TypeBuilder typeBuilder = (TypeBuilder)typeBuilders.get(type);
                    if (typeBuilder == null) {
                        typeBuilder = new TypeBuilder(acceptableTransientOverheadRatio, reader);
                        typeBuilders.put(type, typeBuilder);
                    }
                    BytesRef id = termsEnum.id();
                    long termOrd = typeBuilder.builder.nextOrdinal();
                    assert (termOrd == typeBuilder.termOrdToBytesOffset.size());
                    typeBuilder.termOrdToBytesOffset.add(typeBuilder.bytes.copyUsingLengthPrefix(id));
                    docsEnum = estimatedTermsEnum.docs(null, docsEnum, 0);
                    int docId = docsEnum.nextDoc();
                    while (docId != Integer.MAX_VALUE) {
                        typeBuilder.builder.addDoc(docId);
                        docId = docsEnum.nextDoc();
                    }
                    term = estimatedTermsEnum.next();
                }
                ImmutableOpenMap.Builder typeToAtomicFieldData = ImmutableOpenMap.builder(typeBuilders.size());
                for (ObjectObjectCursor cursor : typeBuilders) {
                    PagedBytes.Reader bytesReader = ((TypeBuilder)cursor.value).bytes.freeze(true);
                    Ordinals ordinals = ((TypeBuilder)cursor.value).builder.build(this.fieldDataType.getSettings());
                    typeToAtomicFieldData.put(cursor.key, new PagedBytesAtomicFieldData(bytesReader, ((TypeBuilder)cursor.value).termOrdToBytesOffset.build(), ordinals));
                }
                data = new ParentChildAtomicFieldData(typeToAtomicFieldData.build());
            }
            catch (Throwable throwable) {
                for (ObjectObjectCursor cursor : typeBuilders) {
                    ((TypeBuilder)cursor.value).builder.close();
                }
                throw throwable;
            }
            for (ObjectObjectCursor cursor : typeBuilders) {
                ((TypeBuilder)cursor.value).builder.close();
            }
            success = true;
            ParentChildAtomicFieldData parentChildAtomicFieldData = data;
            return parentChildAtomicFieldData;
        }
        finally {
            if (success) {
                estimator.afterLoad(estimatedTermsEnum, data.ramBytesUsed());
            } else {
                estimator.afterLoad(estimatedTermsEnum, 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeCreate(DocumentMapper mapper) {
        Object object = this.lock;
        synchronized (object) {
            ParentFieldMapper parentFieldMapper = mapper.parentFieldMapper();
            if (parentFieldMapper.active() && this.parentTypes.add(new BytesRef((CharSequence)parentFieldMapper.type()))) {
                this.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterRemove(DocumentMapper mapper) {
        Object object = this.lock;
        synchronized (object) {
            ParentFieldMapper parentFieldMapper = mapper.parentFieldMapper();
            if (parentFieldMapper.active()) {
                this.parentTypes.remove(new BytesRef((CharSequence)parentFieldMapper.type()));
            }
        }
    }

    @Override
    public IndexParentChildFieldData loadGlobal(IndexReader indexReader) {
        if (indexReader.leaves().size() <= 1) {
            return this;
        }
        try {
            return this.cache.load(indexReader, this);
        }
        catch (Throwable e) {
            if (e instanceof ElasticsearchException) {
                throw (ElasticsearchException)e;
            }
            throw new ElasticsearchException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexParentChildFieldData localGlobalDirect(IndexReader indexReader) throws Exception {
        Object[] values;
        long startTime = System.nanoTime();
        HashMap<String, Object[]> types = new HashMap<String, Object[]>();
        Object object = this.lock;
        synchronized (object) {
            for (BytesRef type : this.parentTypes) {
                values = new SortedDocValues[indexReader.leaves().size()];
                Arrays.fill(values, DocValues.emptySorted());
                types.put(type.utf8ToString(), values);
            }
        }
        for (Map.Entry entry : types.entrySet()) {
            String parentType = (String)entry.getKey();
            values = (SortedDocValues[])entry.getValue();
            for (AtomicReaderContext context : indexReader.leaves()) {
                SortedDocValues vals = ((AtomicParentChildFieldData)this.load(context)).getOrdinalsValues(parentType);
                if (vals == null) continue;
                values[context.ord] = vals;
            }
        }
        long ramBytesUsed = 0L;
        Map[] global = new Map[indexReader.leaves().size()];
        for (Map.Entry entry : types.entrySet()) {
            String parentType = (String)entry.getKey();
            final SortedDocValues[] values2 = (SortedDocValues[])entry.getValue();
            final MultiDocValues.OrdinalMap ordinalMap = MultiDocValues.OrdinalMap.build(null, (SortedDocValues[])((SortedDocValues[])entry.getValue()), (float)0.25f);
            ramBytesUsed += ordinalMap.ramBytesUsed();
            for (int i = 0; i < values2.length; ++i) {
                final SortedDocValues segmentValues = values2[i];
                final LongValues globalOrds = ordinalMap.getGlobalOrds(i);
                SortedDocValues globalSortedValues = new SortedDocValues(){

                    public BytesRef lookupOrd(int ord) {
                        int segmentNum = ordinalMap.getFirstSegmentNumber((long)ord);
                        int segmentOrd = (int)ordinalMap.getFirstSegmentOrd((long)ord);
                        return values2[segmentNum].lookupOrd(segmentOrd);
                    }

                    public int getValueCount() {
                        return (int)ordinalMap.getValueCount();
                    }

                    public int getOrd(int docID) {
                        int segmentOrd = segmentValues.getOrd(docID);
                        if (segmentOrd >= 0) {
                            return (int)globalOrds.get(segmentOrd);
                        }
                        return segmentOrd;
                    }
                };
                HashMap<String, 1> perSegmentGlobal = global[i];
                if (perSegmentGlobal == null) {
                    global[i] = perSegmentGlobal = new HashMap<String, 1>(1);
                }
                perSegmentGlobal.put(parentType, globalSortedValues);
            }
        }
        this.breakerService.getBreaker(CircuitBreaker.Name.FIELDDATA).addWithoutBreaking(ramBytesUsed);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Global-ordinals[_parent] took {}", new TimeValue(System.nanoTime() - startTime, TimeUnit.NANOSECONDS));
        }
        return new GlobalFieldData(indexReader, global, ramBytesUsed);
    }

    private class GlobalFieldData
    implements IndexParentChildFieldData,
    Accountable {
        private final AtomicParentChildFieldData[] atomicFDs;
        private final IndexReader reader;
        private final long ramBytesUsed;

        GlobalFieldData(IndexReader reader, final Map<String, SortedDocValues>[] globalValues, long ramBytesUsed) {
            this.reader = reader;
            this.ramBytesUsed = ramBytesUsed;
            this.atomicFDs = new AtomicParentChildFieldData[globalValues.length];
            for (int i = 0; i < globalValues.length; ++i) {
                final int ord = i;
                this.atomicFDs[i] = new AbstractAtomicParentChildFieldData(){

                    public long ramBytesUsed() {
                        return 0L;
                    }

                    @Override
                    public void close() {
                    }

                    @Override
                    public Set<String> types() {
                        return Collections.unmodifiableSet(globalValues[ord].keySet());
                    }

                    @Override
                    public SortedDocValues getOrdinalsValues(String type) {
                        SortedDocValues dv = (SortedDocValues)globalValues[ord].get(type);
                        if (dv == null) {
                            dv = DocValues.emptySorted();
                        }
                        return dv;
                    }
                };
            }
        }

        @Override
        public FieldMapper.Names getFieldNames() {
            return ParentChildIndexFieldData.this.getFieldNames();
        }

        @Override
        public FieldDataType getFieldDataType() {
            return ParentChildIndexFieldData.this.getFieldDataType();
        }

        @Override
        public AtomicParentChildFieldData load(AtomicReaderContext context) {
            assert (context.reader().getCoreCacheKey() == ((AtomicReaderContext)this.reader.leaves().get(context.ord)).reader().getCoreCacheKey());
            return this.atomicFDs[context.ord];
        }

        @Override
        public AtomicParentChildFieldData loadDirect(AtomicReaderContext context) throws Exception {
            return this.load(context);
        }

        @Override
        public IndexFieldData.XFieldComparatorSource comparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
            throw new UnsupportedOperationException("No sorting on global ords");
        }

        @Override
        public void clear() {
            ParentChildIndexFieldData.this.clear();
        }

        @Override
        public void clear(IndexReader reader) {
            ParentChildIndexFieldData.this.clear(reader);
        }

        @Override
        public Index index() {
            return ParentChildIndexFieldData.this.index();
        }

        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        @Override
        public IndexParentChildFieldData loadGlobal(IndexReader indexReader) {
            if (indexReader.getCoreCacheKey() == this.reader.getCoreCacheKey()) {
                return this;
            }
            throw new ElasticsearchIllegalStateException();
        }

        @Override
        public IndexParentChildFieldData localGlobalDirect(IndexReader indexReader) throws Exception {
            return this.loadGlobal(indexReader);
        }
    }

    public class ParentChildEstimator
    implements AbstractIndexFieldData.PerValueEstimator {
        private final CircuitBreaker breaker;
        private final TermsEnum filteredEnum;

        public ParentChildEstimator(CircuitBreaker breaker, TermsEnum filteredEnum) {
            this.breaker = breaker;
            this.filteredEnum = filteredEnum;
        }

        @Override
        public long bytesPerValue(BytesRef term) {
            if (term == null) {
                return 0L;
            }
            return 2 * term.length;
        }

        @Override
        public TermsEnum beforeLoad(Terms terms) throws IOException {
            return new RamAccountingTermsEnum(this.filteredEnum, this.breaker, this, "parent/child id cache");
        }

        @Override
        public void afterLoad(TermsEnum termsEnum, long actualUsed) {
            assert (termsEnum instanceof RamAccountingTermsEnum);
            long estimatedBytes = ((RamAccountingTermsEnum)termsEnum).getTotalBytes();
            this.breaker.addWithoutBreaking(-(estimatedBytes - actualUsed));
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new ParentChildIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, mapperService, breakerService);
        }
    }

    class TypeBuilder {
        final PagedBytes bytes = new PagedBytes(15);
        final PackedLongValues.Builder termOrdToBytesOffset = PackedLongValues.monotonicBuilder((float)0.0f);
        final OrdinalsBuilder builder;

        TypeBuilder(float acceptableTransientOverheadRatio, AtomicReader reader) throws IOException {
            this.builder = new OrdinalsBuilder(-1L, reader.maxDoc(), acceptableTransientOverheadRatio);
        }
    }
}

